package org.mule.weave.v2.debugger.client

trait ConnectionRetriesListener {

  def startConnecting()

  def connectedSuccessfully()

  def failToConnect(reason: String)

  def onRetry(count: Int, total: Int): Boolean

}

class EmptyConnectionRetriesListener extends ConnectionRetriesListener {
  override def startConnecting(): Unit = {}

  override def connectedSuccessfully(): Unit = {}

  override def failToConnect(reason: String): Unit = {}

  override def onRetry(count: Int, total: Int): Boolean = true

}

object EmptyConnectionRetriesListener {
  def apply(): EmptyConnectionRetriesListener = new EmptyConnectionRetriesListener()
}