package org.mule.weave.v2.debugger.client

import org.mule.weave.v2.debugger.commands.StepOutDebuggerCommand
import org.mule.weave.v2.debugger.event.BreakpointAddedEvent
import org.mule.weave.v2.debugger.event.BreakpointRemovedEvent
import org.mule.weave.v2.debugger.event.BreakpointsAddedEvent
import org.mule.weave.v2.debugger.event.BreakpointsCleanedEvent
import org.mule.weave.v2.debugger.event.ClientInitializedEvent
import org.mule.weave.v2.debugger.event.ExceptionBreakpointsAddedEvent
import org.mule.weave.v2.debugger.event.NextStepDebuggerEvent
import org.mule.weave.v2.debugger.event.OnFrameEvent
import org.mule.weave.v2.debugger.event.ResumeDebuggerEvent
import org.mule.weave.v2.debugger.event.StepIntoDebuggerEvent
import org.mule.weave.v2.debugger.event.StepOutDebuggerEvent
import org.mule.weave.v2.debugger.event.UnexpectedServerErrorEvent

trait DebuggerClientListener extends ScriptEvaluationListener {

  /**
    * Response on step out
    * @param stepOut The event
    */
  def onStepOutExecuted(stepOut: StepOutDebuggerEvent): Unit = {}

  /**
    * Response to exception breakpoints
    * @param ex The event
    */
  def onExceptionBreakpointsAdded(ex: ExceptionBreakpointsAddedEvent): Unit = {}

  /**
    * Response on next step
    *
    * @param nxt The next step even
    */
  def onNextStepExecuted(nxt: NextStepDebuggerEvent): Unit = {}

  /**
    * Response on stepInto
    * @param sie the step into event
    */
  def onStepIntoExecuted(sie: StepIntoDebuggerEvent): Unit = {}

  /**
    * Response to resume
    * @param rde The event
    */
  def onResumeExecuted(rde: ResumeDebuggerEvent): Unit = {}

  /**
    * Response to a collection of breakpoints added
    * @param bsae The event
    */
  def onBreakpointsAdded(bsae: BreakpointsAddedEvent): Unit = {}

  /**
    * Response on the breakpoint cleaned
    *
    * @param bce The event
    */
  def onBreakpointCleaned(bce: BreakpointsCleanedEvent): Unit = {}

  /**
    * Event sent when the debugger client is initialized
    */
  def onClientInitialized(ci: ClientInitializedEvent): Unit = {}

  /**
    * Message returned when the breakpoint has been added
    */
  def onBreakpointAdded(bae: BreakpointAddedEvent): Unit = {}

  /**
    * Response on the breakpoint removed
    * @param bre The breakpoint that was removed
    */
  def onBreakpointRemoved(bre: BreakpointRemovedEvent): Unit = {}

  /**
    * When the execution stops in a fram
    * @param client
    * @param frame
    */
  def onFrame(client: DebuggerClient, frame: OnFrameEvent): Unit = {}

  /**
    * When an unexpected error occurred when executing an event
    * @param unexpectedServerErrorEvent The error
    */
  def onUnexpectedError(unexpectedServerErrorEvent: UnexpectedServerErrorEvent): Unit = {}

}
