/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.deps;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.mule.weave.v2.deps.Artifact;
import org.mule.weave.v2.deps.Artifact$;
import org.mule.weave.v2.deps.DependencyManagerController;
import org.mule.weave.v2.deps.ResourceDependencyAnnotationProcessor$;
import org.mule.weave.v2.deps.utils.UnzipHelper$;
import org.mule.weave.v2.parser.DefaultMessage;
import org.mule.weave.v2.parser.Message;
import org.mule.weave.v2.parser.MessageCategory;
import org.mule.weave.v2.parser.MessageCollector;
import org.mule.weave.v2.parser.ParsingPhaseCategory$;
import org.mule.weave.v2.parser.ast.AstNode;
import org.mule.weave.v2.parser.ast.annotation.AnnotationNode;
import org.mule.weave.v2.parser.ast.annotation.AnnotationNodeHelper$;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.parser.phase.AnnotationProcessor;
import org.mule.weave.v2.scope.AstNavigator;
import org.mule.weave.v2.scope.ScopesNavigator;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015c\u0001B\b\u0011\u0001mA\u0001B\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\tg\u0001\u0011\t\u0011)A\u0005i!A\u0001\b\u0001B\u0001B\u0003%\u0011\bC\u0003B\u0001\u0011\u0005!\tC\u0004H\u0001\t\u0007I\u0011\u0001%\t\r9\u0003\u0001\u0015!\u0003J\u0011\u0015y\u0005\u0001\"\u0011Q\u0011\u00151\b\u0001\"\u0001x\u000f\u001d\ty\u0002\u0005E\u0001\u0003C1aa\u0004\t\t\u0002\u0005\r\u0002BB!\u000b\t\u0003\t)\u0003C\u0004\u0002()!\t!!\u000b\t\u0013\u0005M\"B1A\u0005\u0002\u0005U\u0002\u0002CA\"\u0015\u0001\u0006I!a\u000e\u0003KI+7o\\;sG\u0016$U\r]3oI\u0016t7-_!o]>$\u0018\r^5p]B\u0013xnY3tg>\u0014(BA\t\u0013\u0003\u0011!W\r]:\u000b\u0005M!\u0012A\u0001<3\u0015\t)b#A\u0003xK\u00064XM\u0003\u0002\u00181\u0005!Q.\u001e7f\u0015\u0005I\u0012aA8sO\u000e\u00011c\u0001\u0001\u001dEA\u0011Q\u0004I\u0007\u0002=)\tq$A\u0003tG\u0006d\u0017-\u0003\u0002\"=\t1\u0011I\\=SK\u001a\u0004\"a\t\u0015\u000e\u0003\u0011R!!\n\u0014\u0002\u000bAD\u0017m]3\u000b\u0005\u001d\u0012\u0012A\u00029beN,'/\u0003\u0002*I\t\u0019\u0012I\u001c8pi\u0006$\u0018n\u001c8Qe>\u001cWm]:pe\u0006i!/Z:pkJ\u001cWmQ1dQ\u0016\u0004\"\u0001L\u0019\u000e\u00035R!AL\u0018\u0002\u0005%|'\"\u0001\u0019\u0002\t)\fg/Y\u0005\u0003e5\u0012AAR5mK\u0006\u0001r/Z1wKB\u000bG\u000f[+qI\u0006$XM\u001d\t\u0003kYj\u0011\u0001E\u0005\u0003oA\u00111\u0004R3qK:$WM\\2z\u001b\u0006t\u0017mZ3s\u0007>tGO]8mY\u0016\u0014\u0018\u0001C3yK\u000e,Ho\u001c:\u0011\u0005izT\"A\u001e\u000b\u0005qj\u0014AC2p]\u000e,(O]3oi*\u0011ahL\u0001\u0005kRLG.\u0003\u0002Aw\tyQ\t_3dkR|'oU3sm&\u001cW-\u0001\u0004=S:LGO\u0010\u000b\u0005\u0007\u0012+e\t\u0005\u00026\u0001!)!\u0006\u0002a\u0001W!)1\u0007\u0002a\u0001i!)\u0001\b\u0002a\u0001s\u000591m\u001c8uKb$X#A%\u0011\u0005)cU\"A&\u000b\u0005qr\u0012BA'L\u0005a)\u00050Z2vi&|gnQ8oi\u0016DH/\u0012=fGV$xN]\u0001\tG>tG/\u001a=uA\u0005\u0019!/\u001e8\u0015\rE#F\fZ5p!\ti\"+\u0003\u0002T=\t!QK\\5u\u0011\u0015)v\u00011\u0001W\u00035\tgN\\8uCR,GMT8eKB\u0011qKW\u0007\u00021*\u0011\u0011LJ\u0001\u0004CN$\u0018BA.Y\u0005\u001d\t5\u000f\u001e(pI\u0016DQ!X\u0004A\u0002y\u000bA\"Y:u\u001d\u00064\u0018nZ1u_J\u0004\"a\u00182\u000e\u0003\u0001T!!\u0019\n\u0002\u000bM\u001cw\u000e]3\n\u0005\r\u0004'\u0001D!ti:\u000bg/[4bi>\u0014\b\"B3\b\u0001\u00041\u0017AD:d_B,g*\u0019<jO\u0006$xN\u001d\t\u0003?\u001eL!\u0001\u001b1\u0003\u001fM\u001bw\u000e]3t\u001d\u00064\u0018nZ1u_JDQA[\u0004A\u0002-\f\u0001#\\3tg\u0006<WmQ8mY\u0016\u001cGo\u001c:\u0011\u00051lW\"\u0001\u0014\n\u000594#\u0001E'fgN\fw-Z\"pY2,7\r^8s\u0011\u0015\u0001x\u00011\u0001r\u0003)\tgN\\8uCRLwN\u001c\t\u0003eRl\u0011a\u001d\u0006\u0003abK!!^:\u0003\u001d\u0005sgn\u001c;bi&|gNT8eK\u0006A!/\u001a;sS\u00164X\r\u0006\u0004Rq\u0006-\u0011Q\u0003\u0005\u0006s\"\u0001\rA_\u0001\u0004kJd\u0007cA>\u0002\u00069\u0019A0!\u0001\u0011\u0005utR\"\u0001@\u000b\u0005}T\u0012A\u0002\u001fs_>$h(C\u0002\u0002\u0004y\ta\u0001\u0015:fI\u00164\u0017\u0002BA\u0004\u0003\u0013\u0011aa\u0015;sS:<'bAA\u0002=!9\u0011Q\u0002\u0005A\u0002\u0005=\u0011aC:i_VdG-\u00168{SB\u00042!HA\t\u0013\r\t\u0019B\b\u0002\b\u0005>|G.Z1o\u0011\u001d\t9\u0002\u0003a\u0001\u00033\tA\"\u001a:s_JlUm]:bO\u0016\u0004R!HA\u000euFK1!!\b\u001f\u0005%1UO\\2uS>t\u0017'A\u0013SKN|WO]2f\t\u0016\u0004XM\u001c3f]\u000eL\u0018I\u001c8pi\u0006$\u0018n\u001c8Qe>\u001cWm]:peB\u0011QGC\n\u0003\u0015q!\"!!\t\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000f\r\u000bY#!\f\u00022!)!\u0006\u0004a\u0001W!1\u0011q\u0006\u0007A\u0002Q\n!bY8oiJ|G\u000e\\3s\u0011\u0015AD\u00021\u0001:\u0003=\teJT(U\u0003RKuJT0O\u00036+UCAA\u001c!\u0011\tI$a\u0010\u000e\u0005\u0005m\"bAA\u001f1\u0006Ia/\u0019:jC\ndWm]\u0005\u0005\u0003\u0003\nYD\u0001\bOC6,\u0017\nZ3oi&4\u0017.\u001a:\u0002!\u0005sej\u0014+B)&{ej\u0018(B\u001b\u0016\u0003\u0003")
public class ResourceDependencyAnnotationProcessor
implements AnnotationProcessor {
    private final File resourceCache;
    private final DependencyManagerController weavePathUpdater;
    private final ExecutionContextExecutor context;

    public static NameIdentifier ANNOTATION_NAME() {
        return ResourceDependencyAnnotationProcessor$.MODULE$.ANNOTATION_NAME();
    }

    public static ResourceDependencyAnnotationProcessor apply(File file, DependencyManagerController dependencyManagerController, ExecutorService executorService) {
        return ResourceDependencyAnnotationProcessor$.MODULE$.apply(file, dependencyManagerController, executorService);
    }

    public ExecutionContextExecutor context() {
        return this.context;
    }

    public void run(AstNode annotatedNode, AstNavigator astNavigator, ScopesNavigator scopeNavigator, MessageCollector messageCollector, AnnotationNode annotation) {
        block0: {
            Option maybeUrl = AnnotationNodeHelper$.MODULE$.argString("url", annotation);
            Option unzip = AnnotationNodeHelper$.MODULE$.argString("unzip", annotation).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ResourceDependencyAnnotationProcessor.$anonfun$run$1(x$1)));
            if (!maybeUrl.isDefined() || !unzip.isDefined()) break block0;
            String url = (String)maybeUrl.get();
            boolean shouldUnzip = BoxesRunTime.unboxToBoolean((Object)unzip.get());
            this.retrieve(url, shouldUnzip, (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)message -> {
                messageCollector.error((Message)new DefaultMessage(message, (MessageCategory)ParsingPhaseCategory$.MODULE$), annotatedNode.location());
                return BoxedUnit.UNIT;
            });
        }
    }

    public void retrieve(String url, boolean shouldUnzip, Function1<String, BoxedUnit> errorMessage) {
        block2: {
            Future future;
            if (!this.weavePathUpdater.shouldDownload(url, "resource")) break block2;
            String filename = URLEncoder.encode(url, "UTF-8");
            this.resourceCache.mkdirs();
            File theCachedFile = new File(this.resourceCache, filename);
            if (theCachedFile.exists()) {
                future = Future$.MODULE$.successful((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Artifact[]{new Artifact(theCachedFile, Artifact$.MODULE$.apply$default$2())})));
            } else {
                URL resourceUrl = new URL(url);
                future = Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                    Seq seq;
                    try {
                        URLConnection connection = resourceUrl.openConnection();
                        try (InputStream stream = connection.getInputStream();){
                            Files.copy(stream, theCachedFile.toPath(), new CopyOption[0]);
                            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Artifact[]{new Artifact(theCachedFile, Artifact$.MODULE$.apply$default$2())}));
                        }
                    }
                    catch (IOException io) {
                        errorMessage.apply((Object)io.getMessage());
                        seq = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
                    }
                    return seq;
                }, (ExecutionContext)this.context());
            }
            Future downloadedArtifact = future;
            Future unzippedArtifact = shouldUnzip ? downloadedArtifact.map((Function1 & Serializable & scala.Serializable)artifact -> {
                Seq seq;
                String filename = URLEncoder.encode(new StringBuilder(6).append("unzip:").append(url).toString(), "UTF-8");
                File theCachedFile = new File($this.resourceCache, filename);
                if (theCachedFile.exists()) {
                    seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Artifact[]{new Artifact(theCachedFile, true)}));
                } else if (artifact.nonEmpty()) {
                    try (FileInputStream zipStream = new FileInputStream(((Artifact)artifact.head()).file());){
                        UnzipHelper$.MODULE$.unZipIt(zipStream, theCachedFile);
                    }
                    seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Artifact[]{new Artifact(theCachedFile, true)}));
                } else {
                    seq = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
                }
                return seq;
            }, (ExecutionContext)this.context()) : downloadedArtifact;
            this.weavePathUpdater.downloaded(url, "resource", (Future<Seq<Artifact>>)unzippedArtifact);
        }
    }

    public static final /* synthetic */ boolean $anonfun$run$1(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toBoolean();
    }

    public ResourceDependencyAnnotationProcessor(File resourceCache, DependencyManagerController weavePathUpdater, ExecutorService executor) {
        this.resourceCache = resourceCache;
        this.weavePathUpdater = weavePathUpdater;
        this.context = ExecutionContext$.MODULE$.fromExecutor((Executor)executor);
    }
}

