/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.deps;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.mule.weave.v2.deps.Artifact;
import org.mule.weave.v2.deps.Artifact$;
import org.mule.weave.v2.deps.ArtifactResolutionCallback;
import org.mule.weave.v2.deps.ResourceDependencyAnnotationProcessor$;
import org.mule.weave.v2.deps.utils.UnzipHelper$;
import org.mule.weave.v2.parser.DefaultMessage;
import org.mule.weave.v2.parser.Message;
import org.mule.weave.v2.parser.MessageCategory;
import org.mule.weave.v2.parser.MessageCollector;
import org.mule.weave.v2.parser.ParsingPhaseCategory$;
import org.mule.weave.v2.parser.ast.AstNode;
import org.mule.weave.v2.parser.ast.annotation.AnnotationNode;
import org.mule.weave.v2.parser.ast.annotation.AnnotationNodeHelper$;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.parser.phase.AnnotationProcessor;
import org.mule.weave.v2.scope.AstNavigator;
import org.mule.weave.v2.scope.ScopesNavigator;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015c\u0001B\b\u0011\u0001mA\u0001B\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\tg\u0001\u0011\t\u0011)A\u0005i!A\u0001\b\u0001B\u0001B\u0003%\u0011\bC\u0003B\u0001\u0011\u0005!\tC\u0004H\u0001\t\u0007I\u0011\u0001%\t\r9\u0003\u0001\u0015!\u0003J\u0011\u0015y\u0005\u0001\"\u0011Q\u0011\u00151\b\u0001\"\u0001x\u000f\u001d\ty\u0002\u0005E\u0001\u0003C1aa\u0004\t\t\u0002\u0005\r\u0002BB!\u000b\t\u0003\t)\u0003C\u0004\u0002()!\t!!\u000b\t\u0013\u0005M\"B1A\u0005\u0002\u0005U\u0002\u0002CA\"\u0015\u0001\u0006I!a\u000e\u0003KI+7o\\;sG\u0016$U\r]3oI\u0016t7-_!o]>$\u0018\r^5p]B\u0013xnY3tg>\u0014(BA\t\u0013\u0003\u0011!W\r]:\u000b\u0005M!\u0012A\u0001<3\u0015\t)b#A\u0003xK\u00064XM\u0003\u0002\u00181\u0005!Q.\u001e7f\u0015\u0005I\u0012aA8sO\u000e\u00011c\u0001\u0001\u001dEA\u0011Q\u0004I\u0007\u0002=)\tq$A\u0003tG\u0006d\u0017-\u0003\u0002\"=\t1\u0011I\\=SK\u001a\u0004\"a\t\u0015\u000e\u0003\u0011R!!\n\u0014\u0002\u000bAD\u0017m]3\u000b\u0005\u001d\u0012\u0012A\u00029beN,'/\u0003\u0002*I\t\u0019\u0012I\u001c8pi\u0006$\u0018n\u001c8Qe>\u001cWm]:pe\u0006i!/Z:pkJ\u001cWmQ1dQ\u0016\u0004\"\u0001L\u0019\u000e\u00035R!AL\u0018\u0002\u0005%|'\"\u0001\u0019\u0002\t)\fg/Y\u0005\u0003e5\u0012AAR5mK\u0006\u0001r/Z1wKB\u000bG\u000f[+qI\u0006$XM\u001d\t\u0003kYj\u0011\u0001E\u0005\u0003oA\u0011!$\u0011:uS\u001a\f7\r\u001e*fg>dW\u000f^5p]\u000e\u000bG\u000e\u001c2bG.\f\u0001\"\u001a=fGV$xN\u001d\t\u0003u}j\u0011a\u000f\u0006\u0003yu\n!bY8oGV\u0014(/\u001a8u\u0015\tqt&\u0001\u0003vi&d\u0017B\u0001!<\u0005=)\u00050Z2vi>\u00148+\u001a:wS\u000e,\u0017A\u0002\u001fj]&$h\b\u0006\u0003D\t\u00163\u0005CA\u001b\u0001\u0011\u0015QC\u00011\u0001,\u0011\u0015\u0019D\u00011\u00015\u0011\u0015AD\u00011\u0001:\u0003\u001d\u0019wN\u001c;fqR,\u0012!\u0013\t\u0003\u00152k\u0011a\u0013\u0006\u0003yyI!!T&\u00031\u0015CXmY;uS>t7i\u001c8uKb$X\t_3dkR|'/\u0001\u0005d_:$X\r\u001f;!\u0003\r\u0011XO\u001c\u000b\u0007#RcF-[8\u0011\u0005u\u0011\u0016BA*\u001f\u0005\u0011)f.\u001b;\t\u000bU;\u0001\u0019\u0001,\u0002\u001b\u0005tgn\u001c;bi\u0016$gj\u001c3f!\t9&,D\u0001Y\u0015\tIf%A\u0002bgRL!a\u0017-\u0003\u000f\u0005\u001bHOT8eK\")Ql\u0002a\u0001=\u0006a\u0011m\u001d;OCZLw-\u0019;peB\u0011qLY\u0007\u0002A*\u0011\u0011ME\u0001\u0006g\u000e|\u0007/Z\u0005\u0003G\u0002\u0014A\"Q:u\u001d\u00064\u0018nZ1u_JDQ!Z\u0004A\u0002\u0019\fab]2pa\u0016t\u0015M^5hCR|'\u000f\u0005\u0002`O&\u0011\u0001\u000e\u0019\u0002\u0010'\u000e|\u0007/Z:OCZLw-\u0019;pe\")!n\u0002a\u0001W\u0006\u0001R.Z:tC\u001e,7i\u001c7mK\u000e$xN\u001d\t\u0003Y6l\u0011AJ\u0005\u0003]\u001a\u0012\u0001#T3tg\u0006<WmQ8mY\u0016\u001cGo\u001c:\t\u000bA<\u0001\u0019A9\u0002\u0015\u0005tgn\u001c;bi&|g\u000e\u0005\u0002si6\t1O\u0003\u0002q1&\u0011Qo\u001d\u0002\u000f\u0003:tw\u000e^1uS>tgj\u001c3f\u0003!\u0011X\r\u001e:jKZ,GCB)y\u0003\u0017\t)\u0002C\u0003z\u0011\u0001\u0007!0A\u0002ve2\u00042a_A\u0003\u001d\ra\u0018\u0011\u0001\t\u0003{zi\u0011A \u0006\u0003\u007fj\ta\u0001\u0010:p_Rt\u0014bAA\u0002=\u00051\u0001K]3eK\u001aLA!a\u0002\u0002\n\t11\u000b\u001e:j]\u001eT1!a\u0001\u001f\u0011\u001d\ti\u0001\u0003a\u0001\u0003\u001f\t1b\u001d5pk2$WK\u001c>jaB\u0019Q$!\u0005\n\u0007\u0005MaDA\u0004C_>dW-\u00198\t\u000f\u0005]\u0001\u00021\u0001\u0002\u001a\u0005aQM\u001d:pe6+7o]1hKB)Q$a\u0007{#&\u0019\u0011Q\u0004\u0010\u0003\u0013\u0019+hn\u0019;j_:\f\u0014!\n*fg>,(oY3EKB,g\u000eZ3oGf\feN\\8uCRLwN\u001c)s_\u000e,7o]8s!\t)$b\u0005\u0002\u000b9Q\u0011\u0011\u0011E\u0001\u0006CB\u0004H.\u001f\u000b\b\u0007\u0006-\u0012QFA\u0019\u0011\u0015QC\u00021\u0001,\u0011\u0019\ty\u0003\u0004a\u0001i\u0005Q1m\u001c8ue>dG.\u001a:\t\u000bab\u0001\u0019A\u001d\u0002\u001f\u0005sej\u0014+B)&{ej\u0018(B\u001b\u0016+\"!a\u000e\u0011\t\u0005e\u0012qH\u0007\u0003\u0003wQ1!!\u0010Y\u0003%1\u0018M]5bE2,7/\u0003\u0003\u0002B\u0005m\"A\u0004(b[\u0016LE-\u001a8uS\u001aLWM]\u0001\u0011\u0003:su\nV!U\u0013>suLT!N\u000b\u0002\u0002")
public class ResourceDependencyAnnotationProcessor
implements AnnotationProcessor {
    private final File resourceCache;
    private final ArtifactResolutionCallback weavePathUpdater;
    private final ExecutionContextExecutor context;

    public static NameIdentifier ANNOTATION_NAME() {
        return ResourceDependencyAnnotationProcessor$.MODULE$.ANNOTATION_NAME();
    }

    public static ResourceDependencyAnnotationProcessor apply(File file, ArtifactResolutionCallback artifactResolutionCallback, ExecutorService executorService) {
        return ResourceDependencyAnnotationProcessor$.MODULE$.apply(file, artifactResolutionCallback, executorService);
    }

    public ExecutionContextExecutor context() {
        return this.context;
    }

    public void run(AstNode annotatedNode, AstNavigator astNavigator, ScopesNavigator scopeNavigator, MessageCollector messageCollector, AnnotationNode annotation) {
        block0: {
            Option maybeUrl = AnnotationNodeHelper$.MODULE$.argString("url", annotation);
            Option unzip = AnnotationNodeHelper$.MODULE$.argString("unzip", annotation).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ResourceDependencyAnnotationProcessor.$anonfun$run$1(x$1)));
            if (!maybeUrl.isDefined() || !unzip.isDefined()) break block0;
            String url = (String)maybeUrl.get();
            boolean shouldUnzip = BoxesRunTime.unboxToBoolean((Object)unzip.get());
            this.retrieve(url, shouldUnzip, (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)message -> {
                messageCollector.error((Message)new DefaultMessage(message, (MessageCategory)ParsingPhaseCategory$.MODULE$), annotatedNode.location());
                return BoxedUnit.UNIT;
            });
        }
    }

    public void retrieve(String url, boolean shouldUnzip, Function1<String, BoxedUnit> errorMessage) {
        block2: {
            Future future;
            if (!this.weavePathUpdater.shouldDownload(url, "resource")) break block2;
            String filename = URLEncoder.encode(url, "UTF-8");
            this.resourceCache.mkdirs();
            File theCachedFile = new File(this.resourceCache, filename);
            if (theCachedFile.exists()) {
                future = Future$.MODULE$.successful((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Artifact[]{new Artifact(theCachedFile, Artifact$.MODULE$.apply$default$2())})));
            } else {
                URL resourceUrl = new URL(url);
                future = Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                    Seq seq;
                    try {
                        URLConnection connection = resourceUrl.openConnection();
                        try (InputStream stream = connection.getInputStream();){
                            Files.copy(stream, theCachedFile.toPath(), new CopyOption[0]);
                            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Artifact[]{new Artifact(theCachedFile, Artifact$.MODULE$.apply$default$2())}));
                        }
                    }
                    catch (IOException io) {
                        errorMessage.apply((Object)io.getMessage());
                        seq = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
                    }
                    return seq;
                }, (ExecutionContext)this.context());
            }
            Future downloadedArtifact = future;
            Future unzippedArtifact = shouldUnzip ? downloadedArtifact.map((Function1 & Serializable & scala.Serializable)artifact -> {
                Seq seq;
                String filename = URLEncoder.encode(new StringBuilder(6).append("unzip:").append(url).toString(), "UTF-8");
                File theCachedFile = new File($this.resourceCache, filename);
                if (theCachedFile.exists()) {
                    seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Artifact[]{new Artifact(theCachedFile, true)}));
                } else if (artifact.nonEmpty()) {
                    try (FileInputStream zipStream = new FileInputStream(((Artifact)artifact.head()).file());){
                        UnzipHelper$.MODULE$.unZipIt(zipStream, theCachedFile);
                    }
                    seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Artifact[]{new Artifact(theCachedFile, true)}));
                } else {
                    seq = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
                }
                return seq;
            }, (ExecutionContext)this.context()) : downloadedArtifact;
            this.weavePathUpdater.downloaded(url, "resource", (Future<Seq<Artifact>>)unzippedArtifact);
        }
    }

    public static final /* synthetic */ boolean $anonfun$run$1(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toBoolean();
    }

    public ResourceDependencyAnnotationProcessor(File resourceCache, ArtifactResolutionCallback weavePathUpdater, ExecutorService executor) {
        this.resourceCache = resourceCache;
        this.weavePathUpdater = weavePathUpdater;
        this.context = ExecutionContext$.MODULE$.fromExecutor((Executor)executor);
    }
}

