package org.mule.weave.v2.dwb.api;

import org.mule.weave.v2.dwb.api.values.*;

public interface IWeaveValueVisitor {
    void visitObject(IWeaveObjectValue value);
    void visitString(IWeaveStringValue value);
    void visitArray(IWeaveArrayValue value);
    void visitInt(IWeaveIntValue value);
    void visitLong(IWeaveLongValue value);
    void visitDouble(IWeaveDoubleValue value);
    void visitBigInt(IWeaveBigIntValue value);
    void visitBigDecimal(IWeaveBigDecimalValue value);
    void visitBinary(IWeaveBinaryValue value);
    void visitBoolean(IWeaveBooleanValue value);
    void visitNull(IWeaveNullValue value);
    void visitDateTime(IWeaveDateTimeValue value);
    void visitLocalDateTime(IWeaveLocalDateTimeValue value);
    void visitTime(IWeaveTimeValue value);
    void visitLocalTime(IWeaveLocalTimeValue value);
    void visitTimeZone(IWeaveTimeZoneValue value);
    void visitLocalDate(IWeaveLocalDateValue value);
    void visitPeriod(IWeavePeriodValue value);
}
