package org.mule.weave.v2.dwb.api;

import java.util.ServiceLoader;

public class WeaveStreamFactoryLoader {
    private WeaveStreamFactory factory = null;

    public WeaveStreamFactory getFactory() {
        initFactory();
        return factory;
    }

    private void initFactory() {
        if (factory == null) {
            ServiceLoader<WeaveStreamFactory> loader = ServiceLoader.load(WeaveStreamFactory.class, WeaveStreamFactory.class.getClassLoader());
            try {
                factory = loader.iterator().next();
            } catch (Exception e) {
                throw new RuntimeException("Couldn't instance a WeaveStreamFactory", e);
            }
        }
    }

}
