/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.dwb.reader;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.mule.weave.v2.dwb.api.IWeaveValue;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.model.structure.schema.Schema;
import org.mule.weave.v2.model.types.ArrayType$;
import org.mule.weave.v2.model.types.BinaryType$;
import org.mule.weave.v2.model.types.BooleanType$;
import org.mule.weave.v2.model.types.DateTimeType$;
import org.mule.weave.v2.model.types.LocalDateTimeType$;
import org.mule.weave.v2.model.types.LocalDateType$;
import org.mule.weave.v2.model.types.LocalTimeType$;
import org.mule.weave.v2.model.types.NullType$;
import org.mule.weave.v2.model.types.NumberType$;
import org.mule.weave.v2.model.types.ObjectType$;
import org.mule.weave.v2.model.types.PeriodType$;
import org.mule.weave.v2.model.types.StringType$;
import org.mule.weave.v2.model.types.TimeType$;
import org.mule.weave.v2.model.types.TimeZoneType$;
import org.mule.weave.v2.model.values.Value;
import org.mule.weave.v2.model.values.math.Number;
import org.mule.weave.v2.module.dwb.reader.NumberPrecisionHelper$;
import org.mule.weave.v2.module.dwb.reader.WeaveArrayValue;
import org.mule.weave.v2.module.dwb.reader.WeaveBigDecimalValue;
import org.mule.weave.v2.module.dwb.reader.WeaveBigIntValue;
import org.mule.weave.v2.module.dwb.reader.WeaveBinaryValue;
import org.mule.weave.v2.module.dwb.reader.WeaveBooleanValue;
import org.mule.weave.v2.module.dwb.reader.WeaveDateTimeValue;
import org.mule.weave.v2.module.dwb.reader.WeaveDoubleValue;
import org.mule.weave.v2.module.dwb.reader.WeaveIntValue;
import org.mule.weave.v2.module.dwb.reader.WeaveLocalDateTimeValue;
import org.mule.weave.v2.module.dwb.reader.WeaveLocalDateValue;
import org.mule.weave.v2.module.dwb.reader.WeaveLocalTimeValue;
import org.mule.weave.v2.module.dwb.reader.WeaveLongValue;
import org.mule.weave.v2.module.dwb.reader.WeaveNullValue;
import org.mule.weave.v2.module.dwb.reader.WeaveObjectValue;
import org.mule.weave.v2.module.dwb.reader.WeavePeriodValue;
import org.mule.weave.v2.module.dwb.reader.WeaveStringValue;
import org.mule.weave.v2.module.dwb.reader.WeaveTimeValue;
import org.mule.weave.v2.module.dwb.reader.WeaveTimeZoneValue;
import org.mule.weave.v2.module.dwb.reader.exceptions.DWBRuntimeExecutionException;
import org.mule.weave.v2.module.dwb.reader.exceptions.DWBRuntimeExecutionException$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Seq;

public final class WeaveValue$ {
    public static WeaveValue$ MODULE$;

    static {
        new WeaveValue$();
    }

    public IWeaveValue<?> apply(Value<?> value, EvaluationContext ctx) {
        Value<?> value2 = value;
        if (StringType$.MODULE$.accepts(value2, ctx)) {
            return new WeaveStringValue(value, ctx);
        }
        if (NumberType$.MODULE$.accepts(value2, ctx)) {
            Value<?> numberValue = value;
            return this.processNumber(numberValue, ctx);
        }
        if (BooleanType$.MODULE$.accepts(value2, ctx)) {
            return new WeaveBooleanValue(value, ctx);
        }
        if (ObjectType$.MODULE$.accepts(value2, ctx)) {
            return new WeaveObjectValue(value, ctx);
        }
        if (ArrayType$.MODULE$.accepts(value2, ctx)) {
            return new WeaveArrayValue(value, ctx);
        }
        if (BinaryType$.MODULE$.accepts(value2, ctx)) {
            return new WeaveBinaryValue(value, ctx);
        }
        if (NullType$.MODULE$.accepts(value2, ctx)) {
            return new WeaveNullValue(value, ctx);
        }
        if (DateTimeType$.MODULE$.accepts(value2, ctx)) {
            return new WeaveDateTimeValue(value, ctx);
        }
        if (LocalDateType$.MODULE$.accepts(value2, ctx)) {
            return new WeaveLocalDateValue(value, ctx);
        }
        if (PeriodType$.MODULE$.accepts(value2, ctx)) {
            return new WeavePeriodValue(value, ctx);
        }
        if (LocalDateTimeType$.MODULE$.accepts(value2, ctx)) {
            return new WeaveLocalDateTimeValue(value, ctx);
        }
        if (TimeType$.MODULE$.accepts(value2, ctx)) {
            return new WeaveTimeValue(value, ctx);
        }
        if (LocalTimeType$.MODULE$.accepts(value2, ctx)) {
            return new WeaveLocalTimeValue(value, ctx);
        }
        if (TimeZoneType$.MODULE$.accepts(value2, ctx)) {
            return new WeaveTimeZoneValue(value, ctx);
        }
        throw new DWBRuntimeExecutionException(new StringBuilder(19).append("Can't handle type: ").append(value.valueType(ctx).toString()).toString(), DWBRuntimeExecutionException$.MODULE$.$lessinit$greater$default$2());
    }

    private IWeaveValue<?> processNumber(Value<Number> numberValue, EvaluationContext ctx) {
        Option schemaMaybe = numberValue.schema(ctx);
        Option option = schemaMaybe;
        if (option instanceof Some) {
            Some some = (Some)option;
            Schema schema = (Schema)some.value();
            Option maybeClass = schema.valueOf("class", ctx);
            Option option2 = maybeClass;
            if (option2 instanceof Some) {
                Some some2 = (Some)option2;
                Value classPropValue = (Value)some2.value();
                return this.processNumberWithClass(numberValue, classPropValue, ctx);
            }
            if (None$.MODULE$.equals(option2)) {
                return this.processNumberWithoutClass(numberValue, ctx);
            }
            throw new MatchError((Object)option2);
        }
        if (None$.MODULE$.equals(option)) {
            return this.processNumberWithoutClass(numberValue, ctx);
        }
        throw new MatchError((Object)option);
    }

    private IWeaveValue<?> processNumberWithClass(Value<Number> numberValue, Value<?> classPropValue, EvaluationContext ctx) {
        String className = StringType$.MODULE$.coerce(classPropValue, ctx).evaluate(ctx).toString();
        if (NumberPrecisionHelper$.MODULE$.isInt(className)) {
            return new WeaveIntValue(numberValue, ctx);
        }
        if (NumberPrecisionHelper$.MODULE$.isLong(className)) {
            return new WeaveLongValue(numberValue, ctx);
        }
        if (NumberPrecisionHelper$.MODULE$.isDouble(className)) {
            return new WeaveDoubleValue(numberValue, ctx);
        }
        if (NumberPrecisionHelper$.MODULE$.isBigInt(className)) {
            return new WeaveBigIntValue(numberValue, ctx);
        }
        if (NumberPrecisionHelper$.MODULE$.isBigDecimal(className)) {
            return new WeaveBigDecimalValue(numberValue, ctx);
        }
        String message = new StringBuilder(55).append("Number class '").append(className).append("' not present in data-weave binary format").toString();
        throw new DWBRuntimeExecutionException(message, classPropValue.location());
    }

    private IWeaveValue<?> processNumberWithoutClass(Value<Number> numberValue, EvaluationContext ctx) {
        Number number = (Number)numberValue.evaluate(ctx);
        if (number.isWhole()) {
            if (number.withinInt()) {
                return new WeaveIntValue(numberValue, ctx);
            }
            if (number.withinLong()) {
                return new WeaveLongValue(numberValue, ctx);
            }
            return new WeaveBigIntValue(numberValue, ctx);
        }
        if (number.withinDouble()) {
            return new WeaveDoubleValue(numberValue, ctx);
        }
        return new WeaveBigDecimalValue(numberValue, ctx);
    }

    public Map<String, IWeaveValue<?>> getSchema(Value<?> value, EvaluationContext ctx) {
        Option option = value.schema(ctx);
        if (option instanceof Some) {
            Some some = (Some)option;
            Schema schema = (Schema)some.value();
            return this.toWeaveValueMap(schema, ctx);
        }
        if (None$.MODULE$.equals(option)) {
            return Collections.emptyMap();
        }
        throw new MatchError((Object)option);
    }

    public Map<String, IWeaveValue<?>> toWeaveValueMap(Schema schema, EvaluationContext ctx) {
        LinkedHashMap map = new LinkedHashMap();
        Seq props = schema.properties(ctx);
        props.foreach((Function1 & Serializable & scala.Serializable)prop -> {
            String propName = (String)prop.name().evaluate(ctx);
            IWeaveValue<?> propValue = MODULE$.apply(prop.value(), ctx);
            return map.put(propName, propValue);
        });
        return map;
    }

    private WeaveValue$() {
        MODULE$ = this;
    }
}

