package org.mule.weave.v2.module.dwb.reader.indexed

import java.time.LocalDateTime
import java.time.ZoneOffset

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.values.LocalDateTimeValue
import org.mule.weave.v2.module.dwb.BinaryLocation
import org.mule.weave.v2.module.dwb.DwTokenHelper
import org.mule.weave.v2.parser.location.Location

class WeaveBinaryLocalDateTime(token: Array[Long], input: BinaryParserInput) extends LocalDateTimeValue {

  private lazy val offset = DwTokenHelper.getOffset(token)
  private lazy val value: LocalDateTime = {
    val stream = input.dataInputStream
    input.seekableStream.seek(offset)
    val unixTimestamp = stream.readLong()
    val nanos = stream.readInt()
    LocalDateTime.ofEpochSecond(unixTimestamp, nanos, ZoneOffset.UTC)
  }

  override def evaluate(implicit ctx: EvaluationContext): T = value

  override def location(): Location = new BinaryLocation(offset)
}
