package org.mule.weave.v2.module.dwb.reader.indexed

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.ArraySeq
import org.mule.weave.v2.model.structure.UnBoundedArraySeq
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.module.dwb.DwTokenHelper
import org.mule.weave.v2.module.dwb.DwTokenType
import org.mule.weave.v2.module.core.xml.reader.indexed.TokenHelpers.LocationCacheEntryWrapper

class WeaveBinaryArraySeq(depth: Int, firstLcIndex: Long, lastLcIndex: Long, input: BinaryParserInput) extends UnBoundedArraySeq {
  private val locationCaches = input.locationCaches
  private val tokens = input.tokenArray
  private val childrenLC = locationCaches(depth + 1)

  private def elementAt(index: Long) = {
    val lcCursor = firstLcIndex + index
    val lcEntry = childrenLC(lcCursor)
    val tokenIndex = lcEntry.getTokenIndex
    val token = tokens(tokenIndex)
    val isStartToken = DwTokenHelper.getTokenType(token) == DwTokenType.ObjectStart || DwTokenHelper.getTokenType(token) == DwTokenType.ArrayStart
    val value = if (isStartToken) {
      WeaveBinaryValue(tokenIndex, Some(lcCursor), input)
    } else {
      WeaveBinaryValue(tokenIndex, None, input)
    }
    value
  }

  override def size(): Long = calculateSize()

  private def calculateSize() = {
    (lastLcIndex + 1) - firstLcIndex
  }

  override def apply(index: Long)(implicit ctx: EvaluationContext): Option[Value[_]] = {
    if (calculateSize() - index > 0) {
      Some(elementAt(index))
    } else {
      None
    }
  }

  override def toIterator(): Iterator[Value[_]] = {
    new WeaveBinaryArraySeqIterator()
  }

  class WeaveBinaryArraySeqIterator extends Iterator[Value[_]]() {
    private val seqSize = calculateSize()
    private var index: Long = 0L

    override def next(): Value[_] = {
      val result = elementAt(index)
      index = index + 1
      result
    }

    override def hasNext: Boolean = {
      (seqSize - index) > 0
    }

    override def foreach[U](f: Value[_] => U): Unit = {
      while (hasNext) {
        f(next())
      }
    }
  }

  override def materialized(): Boolean = true
}
