package org.mule.weave.v2.module.dwb.reader.indexed

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.ArraySeq
import org.mule.weave.v2.model.structure.schema.Schema
import org.mule.weave.v2.model.values.AlreadyMaterializedArrayValue
import org.mule.weave.v2.module.dwb.BinaryLocation
import org.mule.weave.v2.module.dwb.DwTokenHelper
import org.mule.weave.v2.parser.location.Location
import org.mule.weave.v2.parser.location.LocationCapable

class WeaveBinaryArray(startTokenIndex: Long, firstLcIndex: Long, lastLcIndex: Long, input: BinaryParserInput, startToken: Array[Long]) extends AlreadyMaterializedArrayValue with LocationCapable {
  private val offset = DwTokenHelper.getOffset(startToken)
  private val length = DwTokenHelper.getValueLength(startToken)
  private val depth = DwTokenHelper.getDepth(startToken)
  private var _schema: Option[Schema] = _

  override def location(): Location = new BinaryLocation(DwTokenHelper.getOffset(startToken))

  override def evaluate(implicit ctx: EvaluationContext): T = {
    if (firstLcIndex == -1) {
      ArraySeq.empty
    } else {
      val token = input.tokenArray(startTokenIndex)
      val depth = DwTokenHelper.getDepth(token)
      new WeaveBinaryArraySeq(depth, firstLcIndex, lastLcIndex, input)
    }

  }

  override def schema(implicit ctx: EvaluationContext): Option[Schema] = {
    import org.mule.weave.v2.module.core.xml.reader.indexed.TokenHelpers._
    if (_schema == null) {
      if (DwTokenHelper.hasSchemaProps(startToken)) {
        val schemaOffset = offset + length
        val lcEntry = input.locationCaches.apply(depth + 1).apply(lastLcIndex)
        val tokenIndex = lcEntry.getTokenIndex
        // Schema properties are at the same level as the object token.
        // Start searching for this after the last child key token
        val schemaPropKeyIndex = input.tokenArray.indexWhere((x) => DwTokenHelper.getDepth(x) == depth, tokenIndex)
        val schema = WeaveBinaryValue.readSchema(input, schemaPropKeyIndex.toInt - 1, schemaOffset)
        _schema = Some(schema)
      } else {
        _schema = None
      }
    }
    _schema
  }
}

