package org.mule.weave.v2.module.dwb.reader.indexed

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.values.RegexValue
import org.mule.weave.v2.module.dwb.BinaryLocation
import org.mule.weave.v2.module.dwb.DwTokenHelper
import org.mule.weave.v2.parser.location.Location

import scala.util.matching.Regex

class WeaveBinaryRegex(token: Array[Long], input: BinaryParserInput) extends RegexValue {
  private lazy val offset: Long = DwTokenHelper.getOffset(token)
  private lazy val value: Regex = {
    input.seekableStream.seek(offset)
    val length = DwTokenHelper.getValueLength(token).toInt
    val str = BinaryValueRetriever.readString(input.dataInputStream, length)
    new Regex(str)
  }

  override def evaluate(implicit ctx: EvaluationContext): T = value
  override def location(): Location = new BinaryLocation(offset)
}
