package org.mule.weave.v2.module.dwb.reader.indexed

import java.time.LocalTime
import java.time.OffsetTime

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.values.TimeValue
import org.mule.weave.v2.module.dwb.BinaryLocation
import org.mule.weave.v2.module.dwb.DwTokenHelper
import org.mule.weave.v2.parser.location.Location

class WeaveBinaryTime(token: Array[Long], input: BinaryParserInput) extends TimeValue {
  private lazy val offset: Long = DwTokenHelper.getOffset(token)
  private lazy val value: OffsetTime = {
    val stream = input.dataInputStream
    input.seekableStream.seek(offset)
    val nanoOfDay = stream.readLong()
    val localTime = LocalTime.ofNanoOfDay(nanoOfDay)
    val offsetIdIndex = stream.readUnsignedShort()
    val zoneOffset = input.zoneOffsets.get(offsetIdIndex)
    OffsetTime.of(localTime, zoneOffset)
  }

  override def evaluate(implicit ctx: EvaluationContext): T = value
  override def location(): Location = new BinaryLocation(offset)
}
