package org.mule.weave.v2.module.dwb.reader

object NumberPrecisionHelper {

  val int_name1: String = "int"
  val int_name2: String = "java.lang.Integer"
  val long_name1: String = "long"
  val long_name2: String = "java.lang.Long"
  val double_name1: String = "double"
  val double_name2: String = "java.lang.Double"
  val big_int_name: String = "java.math.BigInteger"
  val big_decimal_name: String = "java.math.BigDecimal"

  def isInt(className: String): Boolean = {
    className == int_name1 || className == int_name2
  }

  def isLong(className: String): Boolean = {
    className == long_name1 || className == long_name2
  }

  def isDouble(className: String): Boolean = {
    className == double_name1 || className == double_name2
  }

  def isBigInt(className: String): Boolean = {
    className == big_int_name
  }

  def isBigDecimal(className: String): Boolean = {
    className == big_decimal_name
  }
}
