package org.mule.weave.v2.module.dwb

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.module.DataFormat
import org.mule.weave.v2.module.dwb.reader.WeaveBinaryReader
import org.mule.weave.v2.module.dwb.reader.WeaveBinaryReaderSettings
import org.mule.weave.v2.module.dwb.writer.WeaveBinaryWriter
import org.mule.weave.v2.module.dwb.writer.WeaveBinaryWriterSettings
import org.mule.weave.v2.module.reader.Reader
import org.mule.weave.v2.module.reader.SourceProvider
import org.mule.weave.v2.module.writer.DeferredWriter
import org.mule.weave.v2.module.writer.TargetProvider
import org.mule.weave.v2.module.writer.Writer
import org.mule.weave.v2.parser.module.MimeType

class WeaveBinaryDataFormat extends DataFormat[WeaveBinaryReaderSettings, WeaveBinaryWriterSettings] {
  override def name(): String = "dwb"

  override def label(): String = "DataWeave Binary (dwb)"

  override val defaultMimeType: MimeType = WeaveBinaryDataFormatUtils.defaultMimeType

  override val acceptedMimeTypes: Seq[MimeType] = Seq(WeaveBinaryDataFormatUtils.defaultMimeType)

  override def reader(source: SourceProvider)(implicit ctx: EvaluationContext): Reader = new WeaveBinaryReader(source)

  override def writer(target: Option[Any], outputMimeType: MimeType = defaultMimeType)(implicit ctx: EvaluationContext): Writer = {
    DeferredWriter(WeaveBinaryWriter.apply, TargetProvider(target), createWriterSettings())
  }

  override protected def writerSettings(): WeaveBinaryWriterSettings = new WeaveBinaryWriterSettings

  override protected def readerSettings(): WeaveBinaryReaderSettings = new WeaveBinaryReaderSettings

  override def fileExtensions: Seq[String] = Seq(WeaveBinaryDataFormatUtils.BINARY_WEAVE_EXTENSION)

}

object DefaultWeaveBinaryDataFormat extends WeaveBinaryDataFormat

object WeaveBinaryDataFormatUtils {
  val BINARY_WEAVE_EXTENSION: String = ".dwb"

  val defaultMimeType: MimeType = {
    new MimeType("application", "dwb")
  }
}