package org.mule.weave.v2.module.dwb.reader

import java.io.InputStream

import org.mule.weave.v2.dwb.api.IWeaveValue
import org.mule.weave.v2.dwb.api.WeaveDOMReader
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.module.reader.SourceProvider

class DefaultWeaveDOMReader(is: InputStream) extends WeaveDOMReader {
  private implicit val ctx: EvaluationContext = EvaluationContext()

  private lazy val rootValue = new WeaveBinaryReader(SourceProvider(is)).read("in0")

  def read(): IWeaveValue[_] = {
    WeaveValue(rootValue)
  }

  override def close(): Unit = {
    ctx.close()
  }
}
