/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.dwb.reader.memory;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.mule.weave.v2.io.SeekableStream;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.model.capabilities.UnknownLocationCapable$;
import org.mule.weave.v2.model.structure.ArraySeq$;
import org.mule.weave.v2.model.structure.KeyValuePair;
import org.mule.weave.v2.model.structure.KeyValuePair$;
import org.mule.weave.v2.model.structure.NameSeq;
import org.mule.weave.v2.model.structure.NameValuePair;
import org.mule.weave.v2.model.structure.Namespace;
import org.mule.weave.v2.model.structure.ObjectSeq;
import org.mule.weave.v2.model.structure.ObjectSeq$;
import org.mule.weave.v2.model.structure.QualifiedName;
import org.mule.weave.v2.model.structure.schema.Schema;
import org.mule.weave.v2.model.structure.schema.Schema$;
import org.mule.weave.v2.model.structure.schema.SchemaProperty$;
import org.mule.weave.v2.model.types.ObjectType$;
import org.mule.weave.v2.model.types.StringType$;
import org.mule.weave.v2.model.values.ArrayValue;
import org.mule.weave.v2.model.values.AttributesValue$;
import org.mule.weave.v2.model.values.BinaryValue;
import org.mule.weave.v2.model.values.BinaryValue$;
import org.mule.weave.v2.model.values.BooleanValue$;
import org.mule.weave.v2.model.values.DateTimeValue$;
import org.mule.weave.v2.model.values.KeyValue;
import org.mule.weave.v2.model.values.KeyValue$;
import org.mule.weave.v2.model.values.LocalDateTimeValue$;
import org.mule.weave.v2.model.values.LocalDateValue$;
import org.mule.weave.v2.model.values.LocalTimeValue$;
import org.mule.weave.v2.model.values.MaterializedObjectValue;
import org.mule.weave.v2.model.values.MaterializedObjectValue$;
import org.mule.weave.v2.model.values.NullValue$;
import org.mule.weave.v2.model.values.NumberValue$;
import org.mule.weave.v2.model.values.ObjectValue;
import org.mule.weave.v2.model.values.StringValue;
import org.mule.weave.v2.model.values.StringValue$;
import org.mule.weave.v2.model.values.TimeValue$;
import org.mule.weave.v2.model.values.TimeZoneValue$;
import org.mule.weave.v2.model.values.Value;
import org.mule.weave.v2.module.dwb.DwTokenHelper$;
import org.mule.weave.v2.module.dwb.DwTokenType$;
import org.mule.weave.v2.module.dwb.reader.WeaveBinaryParser;
import org.mule.weave.v2.module.dwb.reader.exceptions.DWBRuntimeExecutionException;
import org.mule.weave.v2.module.dwb.reader.exceptions.DWBRuntimeExecutionException$;
import org.mule.weave.v2.module.dwb.reader.indexed.BinaryValueRetriever$;
import org.mule.weave.v2.module.json.reader.memory.InMemoryJsonArray;
import org.mule.weave.v2.parser.location.Location;
import org.mule.weave.v2.parser.location.LocationCapable;
import org.mule.weave.v2.parser.location.UnknownLocation$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.package$;
import scala.reflect.ScalaSignature;
import spire.math.Number$;

@ScalaSignature(bytes="\u0006\u0001\u0005Mg\u0001B\u0011#\u0001MB\u0001B\u0010\u0001\u0003\u0006\u0004%\ta\u0010\u0005\t\u0017\u0002\u0011\t\u0011)A\u0005\u0001\"AA\n\u0001BC\u0002\u0013\u0005Q\n\u0003\u0005U\u0001\t\u0005\t\u0015!\u0003O\u0011!)\u0006A!A!\u0002\u00171\u0006\"\u0002/\u0001\t\u0003i\u0006b\u00023\u0001\u0005\u0004%I!\u001a\u0005\u0007[\u0002\u0001\u000b\u0011\u00024\t\u000f9\u0004!\u0019!C\u0005_\"1a\u0010\u0001Q\u0001\nAD\u0001b \u0001C\u0002\u0013%\u0011\u0011\u0001\u0005\t\u0003\u000b\u0001\u0001\u0015!\u0003\u0002\u0004!I\u0011q\u0001\u0001C\u0002\u0013%\u0011\u0011\u0002\u0005\t\u0003S\u0001\u0001\u0015!\u0003\u0002\f!I\u00111\u0006\u0001C\u0002\u0013%\u0011Q\u0006\u0005\t\u0003o\u0001\u0001\u0015!\u0003\u00020!9\u0011\u0011\b\u0001\u0005\u0002\u0005m\u0002bBA\"\u0001\u0011\u0005\u0011Q\t\u0005\b\u0003W\u0002A\u0011AA7\u0011\u001d\tY\b\u0001C\u0001\u0003{Bq!!\"\u0001\t\u0003\t9\tC\u0004\u0002\u0018\u0002!I!!'\t\u000f\u0005m\u0005\u0001\"\u0001\u0002\u001a\"9\u0011Q\u0014\u0001\u0005\u0002\u0005}\u0005bBAQ\u0001\u0011%\u00111\u0015\u0005\b\u0003W\u0003A\u0011BAW\u0011\u001d\t)\f\u0001C\u0005\u0003oCq!a/\u0001\t\u0013\ti\fC\u0004\u0002H\u0002!\t!!'\t\u000f\u0005%\u0007\u0001\"\u0003\u0002 \"9\u00111\u001a\u0001\u0005\n\u00055\u0007bBAh\u0001\u0011%\u0011\u0011\u001b\u0002\u001a\u0013:lU-\\8ss^+\u0017M^3CS:\f'/\u001f)beN,'O\u0003\u0002$I\u00051Q.Z7pefT!!\n\u0014\u0002\rI,\u0017\rZ3s\u0015\t9\u0003&A\u0002eo\nT!!\u000b\u0016\u0002\r5|G-\u001e7f\u0015\tYC&\u0001\u0002we)\u0011QFL\u0001\u0006o\u0016\fg/\u001a\u0006\u0003_A\nA!\\;mK*\t\u0011'A\u0002pe\u001e\u001c\u0001aE\u0002\u0001ii\u0002\"!\u000e\u001d\u000e\u0003YR\u0011aN\u0001\u0006g\u000e\fG.Y\u0005\u0003sY\u0012a!\u00118z%\u00164\u0007CA\u001e=\u001b\u0005!\u0013BA\u001f%\u0005E9V-\u0019<f\u0005&t\u0017M]=QCJ\u001cXM]\u0001\u0005]\u0006lW-F\u0001A!\t\t\u0005J\u0004\u0002C\rB\u00111IN\u0007\u0002\t*\u0011QIM\u0001\u0007yI|w\u000e\u001e \n\u0005\u001d3\u0014A\u0002)sK\u0012,g-\u0003\u0002J\u0015\n11\u000b\u001e:j]\u001eT!a\u0012\u001c\u0002\u000b9\fW.\u001a\u0011\u0002\u0017%t\u0007/\u001e;TiJ,\u0017-\\\u000b\u0002\u001dB\u0011qJU\u0007\u0002!*\u0011\u0011KK\u0001\u0003S>L!a\u0015)\u0003\u001dM+Wm[1cY\u0016\u001cFO]3b[\u0006a\u0011N\u001c9viN#(/Z1nA\u0005\u00191\r\u001e=\u0011\u0005]SV\"\u0001-\u000b\u0005eS\u0013!B7pI\u0016d\u0017BA.Y\u0005E)e/\u00197vCRLwN\\\"p]R,\u0007\u0010^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007y\u00137\r\u0006\u0002`CB\u0011\u0001\rA\u0007\u0002E!)QK\u0002a\u0002-\")aH\u0002a\u0001\u0001\")AJ\u0002a\u0001\u001d\u0006)\u0011N\u001c9viV\ta\r\u0005\u0002hW6\t\u0001N\u0003\u0002RS*\t!.\u0001\u0003kCZ\f\u0017B\u00017i\u0005=!\u0015\r^1J]B,Ho\u0015;sK\u0006l\u0017AB5oaV$\b%\u0001\u0006oC6,7\u000f]1dKN,\u0012\u0001\u001d\t\u0004cZDX\"\u0001:\u000b\u0005M$\u0018aB7vi\u0006\u0014G.\u001a\u0006\u0003kZ\n!bY8mY\u0016\u001cG/[8o\u0013\t9(OA\u0006BeJ\f\u0017PQ;gM\u0016\u0014\bCA=}\u001b\u0005Q(BA>Y\u0003%\u0019HO];diV\u0014X-\u0003\u0002~u\nIa*Y7fgB\f7-Z\u0001\f]\u0006lWm\u001d9bG\u0016\u001c\b%A\u0003oC6,7/\u0006\u0002\u0002\u0004A\u0019\u0011O\u001e!\u0002\r9\fW.Z:!\u0003\u001dQxN\\3JIN,\"!a\u0003\u0011\u000fE\fi!!\u0005\u0002\u001e%\u0019\u0011q\u0002:\u0003\u000f!\u000b7\u000f['baB!\u00111CA\r\u001b\t\t)BC\u0002\u0002\u0018%\fA\u0001\\1oO&!\u00111DA\u000b\u0005\u001dIe\u000e^3hKJ\u0004B!a\b\u0002&5\u0011\u0011\u0011\u0005\u0006\u0004\u0003GI\u0017\u0001\u0002;j[\u0016LA!a\n\u0002\"\t1!l\u001c8f\u0013\u0012\f\u0001B_8oK&#7\u000fI\u0001\fu>tWm\u00144gg\u0016$8/\u0006\u0002\u00020A9\u0011/!\u0004\u0002\u0012\u0005E\u0002\u0003BA\u0010\u0003gIA!!\u000e\u0002\"\tQ!l\u001c8f\u001f\u001a47/\u001a;\u0002\u0019i|g.Z(gMN,Go\u001d\u0011\u0002\u0015I,\u0017\r\u001a%fC\u0012,'\u000f\u0006\u0002\u0002>A\u0019Q'a\u0010\n\u0007\u0005\u0005cG\u0001\u0003V]&$\u0018!\u00029beN,GCAA$a\u0011\tI%!\u0017\u0011\r\u0005-\u0013\u0011KA+\u001b\t\tiEC\u0002\u0002Pa\u000baA^1mk\u0016\u001c\u0018\u0002BA*\u0003\u001b\u0012QAV1mk\u0016\u0004B!a\u0016\u0002Z1\u0001AaCA.%\u0005\u0005\t\u0011!B\u0001\u0003;\u00121a\u0018\u00132#\u0011\ty&!\u001a\u0011\u0007U\n\t'C\u0002\u0002dY\u0012qAT8uQ&tw\rE\u00026\u0003OJ1!!\u001b7\u0005\r\te._\u0001\u000be\u0016\fGmU2iK6\fGCAA8!\u0011\t\t(a\u001e\u000e\u0005\u0005M$bAA;u\u000611o\u00195f[\u0006LA!!\u001f\u0002t\t11k\u00195f[\u0006\fQB]3bIR{7.\u001a8UsB,GCAA@!\r)\u0014\u0011Q\u0005\u0004\u0003\u00073$aA%oi\u0006I!/Z1e-\u0006dW/\u001a\u000b\u0005\u0003\u0013\u000b\u0019\n\r\u0003\u0002\f\u0006=\u0005CBA&\u0003#\ni\t\u0005\u0003\u0002X\u0005=EaCAI+\u0005\u0005\t\u0011!B\u0001\u0003;\u00121a\u0018\u00133\u0011\u001d\t)*\u0006a\u0001\u0003\u007f\n!\u0003^8lK:$\u0016\u0010]3XSRDg\t\\1hg\u0006y!/Z1e'\"|'\u000f^*ue&tw\rF\u0001A\u0003M\u0011X-\u00193OC6,G)Z2mCJ\fG/[8o\u0003E\u0011X-\u00193O'\u0012+7\r\\1sCRLwN\u001c\u000b\u0002q\u0006I!/Z1e\u0003J\u0014\u0018-\u001f\u000b\u0003\u0003K\u0003B!a\u0013\u0002(&!\u0011\u0011VA'\u0005)\t%O]1z-\u0006dW/Z\u0001\u000be\u0016\fGm\u00142kK\u000e$HCAAX!\u0011\tY%!-\n\t\u0005M\u0016Q\n\u0002\f\u001f\nTWm\u0019;WC2,X-A\u0005u_.,g\u000eV=qKR!\u0011qPA]\u0011\u001d\t)j\u0007a\u0001\u0003\u007f\naB]3bI\u0006#HO]5ckR,7\u000f\u0006\u0002\u0002@B1\u00111JA)\u0003\u0003\u00042!_Ab\u0013\r\t)M\u001f\u0002\b\u001d\u0006lWmU3r\u00035\u0011X-\u00193M_\u000e\fGNT1nK\u0006i!/Z1e\u001d\u0006lWm\u001d9bG\u0016\f!B]3bIj{g.Z%e)\t\ti\"\u0001\bsK\u0006$'l\u001c8f\u001f\u001a47/\u001a;\u0015\u0005\u0005E\u0002")
public class InMemoryWeaveBinaryParser
implements WeaveBinaryParser {
    private final String name;
    private final SeekableStream inputStream;
    private final EvaluationContext ctx;
    private final DataInputStream input;
    private final ArrayBuffer<Namespace> namespaces;
    private final ArrayBuffer<String> names;
    private final HashMap<Integer, ZoneId> zoneIds;
    private final HashMap<Integer, ZoneOffset> zoneOffsets;
    private final int org$mule$weave$v2$module$dwb$reader$WeaveBinaryParser$$readBufferSize;
    private final byte[] org$mule$weave$v2$module$dwb$reader$WeaveBinaryParser$$readBuffer;

    @Override
    public void verifyMagicWord(DataInputStream dataInputStream) {
        WeaveBinaryParser.verifyMagicWord$(this, dataInputStream);
    }

    @Override
    public void verifyVersion(DataInputStream dataInputStream) {
        WeaveBinaryParser.verifyVersion$(this, dataInputStream);
    }

    @Override
    public boolean verifyIndexPresence(DataInputStream dataInputStream) {
        return WeaveBinaryParser.verifyIndexPresence$(this, dataInputStream);
    }

    @Override
    public byte[] getReadBuffer() {
        return WeaveBinaryParser.getReadBuffer$(this);
    }

    @Override
    public byte[] getReadBuffer(int length) {
        return WeaveBinaryParser.getReadBuffer$(this, length);
    }

    @Override
    public int org$mule$weave$v2$module$dwb$reader$WeaveBinaryParser$$readBufferSize() {
        return this.org$mule$weave$v2$module$dwb$reader$WeaveBinaryParser$$readBufferSize;
    }

    @Override
    public byte[] org$mule$weave$v2$module$dwb$reader$WeaveBinaryParser$$readBuffer() {
        return this.org$mule$weave$v2$module$dwb$reader$WeaveBinaryParser$$readBuffer;
    }

    @Override
    public final void org$mule$weave$v2$module$dwb$reader$WeaveBinaryParser$_setter_$org$mule$weave$v2$module$dwb$reader$WeaveBinaryParser$$readBufferSize_$eq(int x$1) {
        this.org$mule$weave$v2$module$dwb$reader$WeaveBinaryParser$$readBufferSize = x$1;
    }

    @Override
    public final void org$mule$weave$v2$module$dwb$reader$WeaveBinaryParser$_setter_$org$mule$weave$v2$module$dwb$reader$WeaveBinaryParser$$readBuffer_$eq(byte[] x$1) {
        this.org$mule$weave$v2$module$dwb$reader$WeaveBinaryParser$$readBuffer = x$1;
    }

    public String name() {
        return this.name;
    }

    public SeekableStream inputStream() {
        return this.inputStream;
    }

    private DataInputStream input() {
        return this.input;
    }

    private ArrayBuffer<Namespace> namespaces() {
        return this.namespaces;
    }

    private ArrayBuffer<String> names() {
        return this.names;
    }

    private HashMap<Integer, ZoneId> zoneIds() {
        return this.zoneIds;
    }

    private HashMap<Integer, ZoneOffset> zoneOffsets() {
        return this.zoneOffsets;
    }

    public void readHeader() {
        this.verifyMagicWord(this.input());
        this.verifyVersion(this.input());
        this.input().read();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Value<?> parse() {
        void var2_2;
        this.readHeader();
        int nextValueType = this.input().read();
        if (nextValueType == -1) {
            throw new IllegalArgumentException("Input should not be empty");
        }
        Value<?> value = this.readValue(nextValueType);
        return var2_2;
    }

    public Schema readSchema() {
        ArrayBuffer props = new ArrayBuffer();
        int propCount = this.input().readUnsignedShort();
        for (int i = 0; i < propCount; ++i) {
            int nextKeyValueType = this.input().read();
            KeyValue key = (KeyValue)this.readValue(nextKeyValueType);
            StringValue keyStrValue = StringValue$.MODULE$.apply(((QualifiedName)key.evaluate(this.ctx)).name());
            Value<?> value = this.readValue(this.input().read());
            props.$plus$eq((Object)SchemaProperty$.MODULE$.apply((Value)keyStrValue, value));
        }
        return Schema$.MODULE$.apply((Seq)props);
    }

    public int readTokenType() {
        return this.input().read();
    }

    public Value<?> readValue(int tokenTypeWithFlags) {
        BinaryValue binaryValue;
        int tokenType = DwTokenHelper$.MODULE$.getTokenType(tokenTypeWithFlags);
        boolean hasSchema = DwTokenHelper$.MODULE$.hasSchemaProps(tokenTypeWithFlags);
        int n = tokenType;
        if (DwTokenType$.MODULE$.Key() == n) {
            String name = this.readLocalName();
            QualifiedName qName = new QualifiedName(name, (Option)None$.MODULE$);
            binaryValue = KeyValue$.MODULE$.apply(qName, (Option)None$.MODULE$);
        } else if (DwTokenType$.MODULE$.KeyWithNS() == n) {
            String name = this.readLocalName();
            Namespace namespace = this.readNamespace();
            QualifiedName qName = new QualifiedName(name, (Option)new Some((Object)namespace));
            binaryValue = KeyValue$.MODULE$.apply(qName, (Option)None$.MODULE$);
        } else if (DwTokenType$.MODULE$.KeyWithAttr() == n) {
            String name = this.readLocalName();
            QualifiedName qName = new QualifiedName(name, (Option)None$.MODULE$);
            Value<NameSeq> attrs = this.readAttributes();
            binaryValue = KeyValue$.MODULE$.apply(qName, (Option)new Some(attrs));
        } else if (DwTokenType$.MODULE$.KeyWithNSAttr() == n) {
            String name = this.readLocalName();
            Namespace namespace = this.readNamespace();
            QualifiedName qName = new QualifiedName(name, (Option)new Some((Object)namespace));
            Value<NameSeq> attrs = this.readAttributes();
            binaryValue = KeyValue$.MODULE$.apply(qName, (Option)new Some(attrs));
        } else if (DwTokenType$.MODULE$.String8() == n) {
            StringValue stringValue;
            int length = this.input().read();
            String str = BinaryValueRetriever$.MODULE$.readString(this.input(), length, this.getReadBuffer(length));
            if (hasSchema) {
                Schema schema = this.readSchema();
                stringValue = StringValue$.MODULE$.apply(str, (LocationCapable)UnknownLocationCapable$.MODULE$, StringType$.MODULE$.withSchema(schema));
            } else {
                stringValue = StringValue$.MODULE$.apply(str);
            }
            binaryValue = stringValue;
        } else if (DwTokenType$.MODULE$.String32() == n) {
            StringValue stringValue;
            int length = this.input().readInt();
            String str = BinaryValueRetriever$.MODULE$.readString(this.input(), length, this.getReadBuffer(length));
            if (hasSchema) {
                Schema schema = this.readSchema();
                stringValue = StringValue$.MODULE$.apply(str, (LocationCapable)UnknownLocationCapable$.MODULE$, StringType$.MODULE$.withSchema(schema));
            } else {
                stringValue = StringValue$.MODULE$.apply(str);
            }
            binaryValue = stringValue;
        } else if (DwTokenType$.MODULE$.Null() == n) {
            binaryValue = NullValue$.MODULE$;
        } else if (DwTokenType$.MODULE$.True() == n) {
            binaryValue = BooleanValue$.MODULE$.TRUE_BOOL();
        } else if (DwTokenType$.MODULE$.False() == n) {
            binaryValue = BooleanValue$.MODULE$.FALSE_BOOL();
        } else if (DwTokenType$.MODULE$.Int() == n) {
            int number = this.input().readInt();
            binaryValue = NumberValue$.MODULE$.apply(Number$.MODULE$.apply(number));
        } else if (DwTokenType$.MODULE$.Long() == n) {
            long number = this.input().readLong();
            binaryValue = NumberValue$.MODULE$.apply(Number$.MODULE$.apply(number));
        } else if (DwTokenType$.MODULE$.BigInt() == n) {
            int length = this.input().readUnsignedShort();
            byte[] buffer = new byte[length];
            this.input().readFully(buffer, 0, length);
            binaryValue = NumberValue$.MODULE$.apply(Number$.MODULE$.apply(package$.MODULE$.BigInt().apply(buffer)));
        } else if (DwTokenType$.MODULE$.Double() == n) {
            double number = this.input().readDouble();
            binaryValue = NumberValue$.MODULE$.apply(Number$.MODULE$.apply(number));
        } else if (DwTokenType$.MODULE$.BigDecimal() == n) {
            String str = BinaryValueRetriever$.MODULE$.readShortString(this.input(), this.getReadBuffer());
            binaryValue = NumberValue$.MODULE$.apply(Number$.MODULE$.apply(package$.MODULE$.BigDecimal().apply(str)));
        } else if (DwTokenType$.MODULE$.ObjectStart() == n) {
            binaryValue = this.readObject();
        } else if (DwTokenType$.MODULE$.ArrayStart() == n) {
            binaryValue = this.readArray();
        } else if (DwTokenType$.MODULE$.Binary() == n) {
            int length = this.input().readInt();
            byte[] buffer = new byte[length];
            this.input().readFully(buffer, 0, length);
            binaryValue = BinaryValue$.MODULE$.apply(buffer, this.ctx);
        } else if (DwTokenType$.MODULE$.DeclareNS() == n) {
            this.readNSDeclaration();
            binaryValue = this.readValue(this.readTokenType());
        } else if (DwTokenType$.MODULE$.DeclareName() == n) {
            this.readNameDeclaration();
            binaryValue = this.readValue(this.readTokenType());
        } else if (DwTokenType$.MODULE$.DateTime() == n) {
            long unixTimestamp = this.input().readLong();
            int nanos = this.input().readInt();
            Instant instant = Instant.ofEpochSecond(unixTimestamp, nanos);
            ZoneId zoneId = this.readZoneId();
            ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(instant, zoneId);
            binaryValue = DateTimeValue$.MODULE$.apply(zonedDateTime);
        } else if (DwTokenType$.MODULE$.LocalDateTime() == n) {
            long unixTimestamp = this.input().readLong();
            int nanos = this.input().readInt();
            binaryValue = LocalDateTimeValue$.MODULE$.apply(LocalDateTime.ofEpochSecond(unixTimestamp, nanos, ZoneOffset.UTC));
        } else if (DwTokenType$.MODULE$.LocalDate() == n) {
            long epochDay = this.input().readLong();
            binaryValue = LocalDateValue$.MODULE$.apply(LocalDate.ofEpochDay(epochDay));
        } else if (DwTokenType$.MODULE$.Time() == n) {
            long nanoOfDay = this.input().readLong();
            LocalTime localTime = LocalTime.ofNanoOfDay(nanoOfDay);
            ZoneOffset zoneOffset = this.readZoneOffset();
            OffsetTime offsetTime = OffsetTime.of(localTime, zoneOffset);
            binaryValue = TimeValue$.MODULE$.apply(offsetTime);
        } else if (DwTokenType$.MODULE$.LocalTime() == n) {
            long nanoOfDay = this.input().readLong();
            LocalTime localTime = LocalTime.ofNanoOfDay(nanoOfDay);
            binaryValue = LocalTimeValue$.MODULE$.apply(localTime);
        } else if (DwTokenType$.MODULE$.TimeZone() == n) {
            ZoneId zoneId = this.readZoneId();
            binaryValue = TimeZoneValue$.MODULE$.apply(zoneId);
        } else {
            if (DwTokenType$.MODULE$.Period() == n) {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }
            if (DwTokenType$.MODULE$.Range() == n) {
                String str = this.input().readUTF();
                binaryValue = StringValue$.MODULE$.apply(str);
            } else {
                throw new DWBRuntimeExecutionException(new StringBuilder(23).append("Unexpected value type: ").append(DwTokenType$.MODULE$.getNameFor(n)).toString(), DWBRuntimeExecutionException$.MODULE$.$lessinit$greater$default$2());
            }
        }
        BinaryValue value = binaryValue;
        return value;
    }

    private String readShortString() {
        return BinaryValueRetriever$.MODULE$.readShortString(this.input(), this.getReadBuffer());
    }

    /*
     * WARNING - void declaration
     */
    public String readNameDeclaration() {
        void var1_1;
        String name = this.readShortString();
        this.names().$plus$eq((Object)name);
        return var1_1;
    }

    public Namespace readNSDeclaration() {
        String str = this.readShortString();
        Tuple2 tuple2 = new StringOps(Predef$.MODULE$.augmentString(str)).splitAt(str.indexOf(":"));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String prefix = (String)tuple2._1();
        String uri = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)prefix, (Object)uri);
        Tuple2 tuple23 = tuple22;
        String prefix2 = (String)tuple23._1();
        String uri2 = (String)tuple23._2();
        Namespace ns = new Namespace(prefix2, uri2.substring(1));
        this.namespaces().$plus$eq((Object)ns);
        return ns;
    }

    private ArrayValue readArray() {
        ArrayBuffer values = new ArrayBuffer();
        int nextValueType = this.readTokenType();
        while (nextValueType != DwTokenType$.MODULE$.StructureEnd()) {
            Value<?> value = this.readValue(nextValueType);
            values.$plus$eq(value);
            nextValueType = this.readTokenType();
        }
        return new InMemoryJsonArray(ArraySeq$.MODULE$.apply((Seq)values, true), (Location)UnknownLocation$.MODULE$);
    }

    private ObjectValue readObject() {
        MaterializedObjectValue materializedObjectValue;
        ArrayBuffer kvps = new ArrayBuffer();
        int tokenTypeWithFlags = this.readTokenType();
        while (this.tokenType(tokenTypeWithFlags) != DwTokenType$.MODULE$.StructureEnd()) {
            KeyValue key = (KeyValue)this.readValue(tokenTypeWithFlags);
            Value<?> value = this.readValue(this.readTokenType());
            kvps.$plus$eq((Object)new KeyValuePair((Value)key, value, KeyValuePair$.MODULE$.apply$default$3()));
            tokenTypeWithFlags = this.readTokenType();
        }
        ObjectSeq objectSeq = ObjectSeq$.MODULE$.apply((Seq)kvps, true);
        boolean objectHasSchema = DwTokenHelper$.MODULE$.hasSchemaProps(tokenTypeWithFlags);
        if (objectHasSchema) {
            Schema schema = this.readSchema();
            materializedObjectValue = new MaterializedObjectValue(objectSeq, (LocationCapable)UnknownLocationCapable$.MODULE$, ObjectType$.MODULE$.withSchema(schema));
        } else {
            materializedObjectValue = new MaterializedObjectValue(objectSeq, (LocationCapable)UnknownLocationCapable$.MODULE$, MaterializedObjectValue$.MODULE$.$lessinit$greater$default$3());
        }
        return materializedObjectValue;
    }

    private int tokenType(int tokenTypeWithFlags) {
        return tokenTypeWithFlags & DwTokenHelper$.MODULE$.TOKEN_TYPE_MASK();
    }

    private Value<NameSeq> readAttributes() {
        ArrayBuffer attrPairs = new ArrayBuffer();
        int attrCount = this.input().readUnsignedShort();
        for (int i = 0; i < attrCount; ++i) {
            int nextValueType = this.readTokenType();
            KeyValue qName = (KeyValue)this.readValue(nextValueType);
            Value<?> value = this.readValue(this.readTokenType());
            attrPairs.$plus$eq((Object)new NameValuePair((Value)qName, value));
        }
        return AttributesValue$.MODULE$.apply((Seq)attrPairs);
    }

    public String readLocalName() {
        int nameIndex = this.input().readUnsignedShort();
        return (String)this.names().apply(nameIndex);
    }

    /*
     * WARNING - void declaration
     */
    private Namespace readNamespace() {
        void var2_2;
        int nsIndex = this.input().readUnsignedShort();
        Namespace namespace = (Namespace)this.namespaces().apply(nsIndex);
        return var2_2;
    }

    private ZoneId readZoneId() {
        ZoneId zoneId;
        int nameIndex = this.input().readUnsignedShort();
        Option zoneIdMaybe = this.zoneIds().get((Object)Predef$.MODULE$.int2Integer(nameIndex));
        Option option = zoneIdMaybe;
        if (option instanceof Some) {
            ZoneId zoneId2;
            Some some = (Some)option;
            zoneId = zoneId2 = (ZoneId)some.value();
        } else if (None$.MODULE$.equals(option)) {
            String nameStr = (String)this.names().apply(nameIndex);
            ZoneId zoneId3 = ZoneId.of(nameStr);
            this.zoneIds().put((Object)Predef$.MODULE$.int2Integer(nameIndex), (Object)zoneId3);
            zoneId = zoneId3;
        } else {
            throw new MatchError((Object)option);
        }
        return zoneId;
    }

    private ZoneOffset readZoneOffset() {
        ZoneOffset zoneOffset;
        int nameIndex = this.input().readUnsignedShort();
        Option zoneOffsetMaybe = this.zoneOffsets().get((Object)Predef$.MODULE$.int2Integer(nameIndex));
        Option option = zoneOffsetMaybe;
        if (option instanceof Some) {
            ZoneOffset zoneId;
            Some some = (Some)option;
            zoneOffset = zoneId = (ZoneOffset)some.value();
        } else if (None$.MODULE$.equals(option)) {
            String nameStr = (String)this.names().apply(nameIndex);
            ZoneOffset zoneOffset2 = ZoneOffset.of(nameStr);
            this.zoneOffsets().put((Object)Predef$.MODULE$.int2Integer(nameIndex), (Object)zoneOffset2);
            zoneOffset = zoneOffset2;
        } else {
            throw new MatchError((Object)option);
        }
        return zoneOffset;
    }

    public InMemoryWeaveBinaryParser(String name, SeekableStream inputStream, EvaluationContext ctx) {
        this.name = name;
        this.inputStream = inputStream;
        this.ctx = ctx;
        WeaveBinaryParser.$init$(this);
        this.input = new DataInputStream(new BufferedInputStream((InputStream)inputStream));
        this.namespaces = new ArrayBuffer(0);
        this.names = new ArrayBuffer();
        this.zoneIds = new HashMap();
        this.zoneOffsets = new HashMap();
    }
}

