/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.dwb.reader.indexed;

import java.io.DataInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import org.mule.weave.v2.io.SeekableStream;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.model.structure.Namespace;
import org.mule.weave.v2.model.values.Value;
import org.mule.weave.v2.module.common.LocationCacheBuilder;
import org.mule.weave.v2.module.common.TokenHelper;
import org.mule.weave.v2.module.dwb.DwTokenHelper$;
import org.mule.weave.v2.module.dwb.DwTokenType$;
import org.mule.weave.v2.module.dwb.WeaveBinaryUtils$;
import org.mule.weave.v2.module.dwb.WeaveKeyToken$;
import org.mule.weave.v2.module.dwb.WeaveValueToken$;
import org.mule.weave.v2.module.dwb.reader.WeaveBinaryParser;
import org.mule.weave.v2.module.dwb.reader.exceptions.DWBRuntimeExecutionException;
import org.mule.weave.v2.module.dwb.reader.exceptions.DWBRuntimeExecutionException$;
import org.mule.weave.v2.module.dwb.reader.indexed.BinaryParserInput;
import org.mule.weave.v2.module.dwb.reader.indexed.BinaryValueRetriever$;
import org.mule.weave.v2.module.dwb.reader.indexed.WeaveBinaryValue$;
import org.mule.weave.v2.module.dwb.reader.indexed.ZoneIdMap;
import org.mule.weave.v2.module.dwb.reader.indexed.ZoneOffsetMap;
import org.mule.weave.v2.module.dwb.writer.WeaveBinaryWriter$;
import org.mule.weave.v2.module.reader.DefaultLongArray;
import org.mule.weave.v2.module.reader.DefaultLongArray$;
import org.mule.weave.v2.module.reader.ILongArray;
import org.mule.weave.v2.module.reader.SeekableStreamSourceReader$;
import org.mule.weave.v2.module.reader.SourceReader;
import org.mule.weave.v2.module.xml.reader.LocationCaches;
import org.mule.weave.v2.module.xml.reader.TokenArray;
import org.mule.weave.v2.module.xml.reader.TokenArray$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\tMf\u0001\u0002\u001e<\u00011C\u0001b\u0016\u0001\u0003\u0006\u0004%\t\u0001\u0017\u0005\tI\u0002\u0011\t\u0011)A\u00053\"AQ\r\u0001B\u0001B\u0003%a\r\u0003\u0005m\u0001\t\u0005\t\u0015a\u0003n\u0011\u0015\u0019\b\u0001\"\u0001u\u0011\u001dY\bA1A\u0005\nqDa! \u0001!\u0002\u00131\u0007b\u0002@\u0001\u0005\u0004%Ia \u0005\t\u0003'\u0001\u0001\u0015!\u0003\u0002\u0002!I\u0011Q\u0003\u0001C\u0002\u0013%\u0011q\u0003\u0005\t\u0003G\u0001\u0001\u0015!\u0003\u0002\u001a!I\u0011Q\u0005\u0001C\u0002\u0013%\u0011q\u0005\u0005\t\u0003g\u0001\u0001\u0015!\u0003\u0002*!I\u0011Q\u0007\u0001C\u0002\u0013%\u0011q\u0007\u0005\t\u0003+\u0002\u0001\u0015!\u0003\u0002:!I\u0011q\u000b\u0001C\u0002\u0013%\u0011\u0011\f\u0005\t\u0003;\u0002\u0001\u0015!\u0003\u0002\\!I\u0011q\f\u0001C\u0002\u0013%\u0011\u0011\r\u0005\t\u0003S\u0002\u0001\u0015!\u0003\u0002d!I\u00111\u000e\u0001C\u0002\u0013%\u0011Q\u000e\u0005\t\u0003k\u0002\u0001\u0015!\u0003\u0002p!I\u0011q\u000f\u0001C\u0002\u0013%\u0011\u0011\u0010\u0005\t\u0003\u000f\u0003\u0001\u0015!\u0003\u0002|!Y\u0011\u0011\u0012\u0001A\u0002\u0003\u0007I\u0011AAF\u0011-\tY\n\u0001a\u0001\u0002\u0004%\t!!(\t\u0017\u0005%\u0006\u00011A\u0001B\u0003&\u0011Q\u0012\u0005\f\u0003W\u0003\u0001\u0019!a\u0001\n\u0003\ti\u000bC\u0006\u00026\u0002\u0001\r\u00111A\u0005\u0002\u0005]\u0006bCA^\u0001\u0001\u0007\t\u0011)Q\u0005\u0003_C\u0011\"!0\u0001\u0001\u0004%I!a0\t\u0013\u0005\u001d\u0007\u00011A\u0005\n\u0005%\u0007\u0002CAg\u0001\u0001\u0006K!!1\t\u0017\u0005=\u0007\u00011AA\u0002\u0013%\u0011\u0011\u001b\u0005\f\u00033\u0004\u0001\u0019!a\u0001\n\u0013\tY\u000eC\u0006\u0002`\u0002\u0001\r\u0011!Q!\n\u0005M\u0007bBAq\u0001\u0011\u0005\u00111\u001d\u0005\b\u0003K\u0004A\u0011AAt\u0011\u001d\ty\u000f\u0001C\u0001\u0003cDqAa\u0002\u0001\t\u0003\u0011I\u0001C\u0004\u00030\u0001!\t!a9\t\u000f\tE\u0002\u0001\"\u0001\u0002d\"9!1\u0007\u0001\u0005\u0002\tU\u0002b\u0002B\u001f\u0001\u0011%!q\b\u0005\b\u0005k\u0002A\u0011\u0002B<\u0011\u001d\u0011\u0019\t\u0001C\u0001\u0005\u000bCqAa\"\u0001\t\u0013\t\u0019\u000fC\u0004\u0003\n\u0002!\t!a9\t\u000f\t5\u0003\u0001\"\u0003\u0003\f\"9!q\u0012\u0001\u0005\n\t\u0015\u0005b\u0002BI\u0001\u0011%!Q\u0011\u0005\b\u0005'\u0003A\u0011\u0002BK\u0011\u001d\u00119\n\u0001C\u0001\u0005+CqA!'\u0001\t\u0003\u0011Y\nC\u0004\u0003\u001e\u0002!IAa(\t\u000f\t\u0015\u0006\u0001\"\u0001\u0002d\"9!q\u0015\u0001\u0005\u0002\t%\u0006b\u0002BX\u0001\u0011\u0005!\u0011\u0017\u0002\u0019\u0013:$W\r_3e/\u0016\fg/\u001a\"j]\u0006\u0014\u0018\u0010U1sg\u0016\u0014(B\u0001\u001f>\u0003\u001dIg\u000eZ3yK\u0012T!AP \u0002\rI,\u0017\rZ3s\u0015\t\u0001\u0015)A\u0002eo\nT!AQ\"\u0002\r5|G-\u001e7f\u0015\t!U)\u0001\u0002we)\u0011aiR\u0001\u0006o\u0016\fg/\u001a\u0006\u0003\u0011&\u000bA!\\;mK*\t!*A\u0002pe\u001e\u001c\u0001aE\u0002\u0001\u001bN\u0003\"AT)\u000e\u0003=S\u0011\u0001U\u0001\u0006g\u000e\fG.Y\u0005\u0003%>\u0013a!\u00118z%\u00164\u0007C\u0001+V\u001b\u0005i\u0014B\u0001,>\u0005E9V-\u0019<f\u0005&t\u0017M]=QCJ\u001cXM]\u0001\u0005]\u0006lW-F\u0001Z!\tQ\u0016M\u0004\u0002\\?B\u0011AlT\u0007\u0002;*\u0011alS\u0001\u0007yI|w\u000e\u001e \n\u0005\u0001|\u0015A\u0002)sK\u0012,g-\u0003\u0002cG\n11\u000b\u001e:j]\u001eT!\u0001Y(\u0002\u000b9\fW.\u001a\u0011\u0002\u0005M\u001c\bCA4k\u001b\u0005A'BA5D\u0003\tIw.\u0003\u0002lQ\nq1+Z3lC\ndWm\u0015;sK\u0006l\u0017aA2uqB\u0011a.]\u0007\u0002_*\u0011\u0001oQ\u0001\u0006[>$W\r\\\u0005\u0003e>\u0014\u0011#\u0012<bYV\fG/[8o\u0007>tG/\u001a=u\u0003\u0019a\u0014N\\5u}Q\u0019Q/\u001f>\u0015\u0005YD\bCA<\u0001\u001b\u0005Y\u0004\"\u00027\u0006\u0001\bi\u0007\"B,\u0006\u0001\u0004I\u0006\"B3\u0006\u0001\u00041\u0017AD:fK.\f'\r\\3TiJ,\u0017-\\\u000b\u0002M\u0006y1/Z3lC\ndWm\u0015;sK\u0006l\u0007%A\u0004dQ\u0006\u00148/\u001a;\u0016\u0005\u0005\u0005\u0001\u0003BA\u0002\u0003\u001fi!!!\u0002\u000b\u0007y\f9A\u0003\u0003\u0002\n\u0005-\u0011a\u00018j_*\u0011\u0011QB\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u0012\u0005\u0015!aB\"iCJ\u001cX\r^\u0001\tG\"\f'o]3uA\u0005yA-\u0019;b\u0013:\u0004X\u000f^*ue\u0016\fW.\u0006\u0002\u0002\u001aA!\u00111DA\u0010\u001b\t\tiBC\u0002j\u0003\u0017IA!!\t\u0002\u001e\tyA)\u0019;b\u0013:\u0004X\u000f^*ue\u0016\fW.\u0001\teCR\f\u0017J\u001c9viN#(/Z1nA\u0005a1o\\;sG\u0016\u0014V-\u00193feV\u0011\u0011\u0011\u0006\t\u0005\u0003W\ty#\u0004\u0002\u0002.)\u0011a(Q\u0005\u0005\u0003c\tiC\u0001\u0007T_V\u00148-\u001a*fC\u0012,'/A\u0007t_V\u00148-\u001a*fC\u0012,'\u000fI\u0001\u000b]\u0006lWm\u001d9bG\u0016\u001cXCAA\u001d!\u0019\tY$!\u0012\u0002J5\u0011\u0011Q\b\u0006\u0005\u0003\u007f\t\t%A\u0004nkR\f'\r\\3\u000b\u0007\u0005\rs*\u0001\u0006d_2dWm\u0019;j_:LA!a\u0012\u0002>\tY\u0011I\u001d:bs\n+hMZ3s!\u0011\tY%!\u0015\u000e\u0005\u00055#bAA(_\u0006I1\u000f\u001e:vGR,(/Z\u0005\u0005\u0003'\niEA\u0005OC6,7\u000f]1dK\u0006Ya.Y7fgB\f7-Z:!\u0003\u0015q\u0017-\\3t+\t\tY\u0006E\u0003\u0002<\u0005\u0015\u0013,\u0001\u0004oC6,7\u000fI\u0001\bu>tW-\u00133t+\t\t\u0019\u0007E\u0002x\u0003KJ1!a\u001a<\u0005%QvN\\3JI6\u000b\u0007/\u0001\u0005{_:,\u0017\nZ:!\u0003-QxN\\3PM\u001a\u001cX\r^:\u0016\u0005\u0005=\u0004cA<\u0002r%\u0019\u00111O\u001e\u0003\u001bi{g.Z(gMN,G/T1q\u00031QxN\\3PM\u001a\u001cX\r^:!\u0003%a7MQ;jY\u0012,'/\u0006\u0002\u0002|A!\u0011QPAB\u001b\t\tyHC\u0002\u0002\u0002\u0006\u000baaY8n[>t\u0017\u0002BAC\u0003\u007f\u0012A\u0003T8dCRLwN\\\"bG\",')^5mI\u0016\u0014\u0018A\u00037d\u0005VLG\u000eZ3sA\u0005QAo\\6f]\u0006\u0013(/Y=\u0016\u0005\u00055\u0005\u0003BAH\u0003/k!!!%\u000b\u0007y\n\u0019JC\u0002\u0002\u0016\u0006\u000b1\u0001_7m\u0013\u0011\tI*!%\u0003\u0015Q{7.\u001a8BeJ\f\u00170\u0001\bu_.,g.\u0011:sCf|F%Z9\u0015\t\u0005}\u0015Q\u0015\t\u0004\u001d\u0006\u0005\u0016bAAR\u001f\n!QK\\5u\u0011%\t9+GA\u0001\u0002\u0004\ti)A\u0002yIE\n1\u0002^8lK:\f%O]1zA\u0005qAn\\2bi&|gnQ1dQ\u0016\u001cXCAAX!\u0011\ty)!-\n\t\u0005M\u0016\u0011\u0013\u0002\u000f\u0019>\u001c\u0017\r^5p]\u000e\u000b7\r[3t\u0003IawnY1uS>t7)Y2iKN|F%Z9\u0015\t\u0005}\u0015\u0011\u0018\u0005\n\u0003Oc\u0012\u0011!a\u0001\u0003_\u000bq\u0002\\8dCRLwN\\\"bG\",7\u000fI\u0001\u0006I\u0016\u0004H\u000f[\u000b\u0003\u0003\u0003\u00042ATAb\u0013\r\t)m\u0014\u0002\u0004\u0013:$\u0018!\u00033faRDw\fJ3r)\u0011\ty*a3\t\u0013\u0005\u001dv$!AA\u0002\u0005\u0005\u0017A\u00023faRD\u0007%\u0001\u0005iCNLe\u000eZ3y+\t\t\u0019\u000eE\u0002O\u0003+L1!a6P\u0005\u001d\u0011un\u001c7fC:\fA\u0002[1t\u0013:$W\r_0%KF$B!a(\u0002^\"I\u0011q\u0015\u0012\u0002\u0002\u0003\u0007\u00111[\u0001\nQ\u0006\u001c\u0018J\u001c3fq\u0002\nQa\u00197pg\u0016$\"!a(\u0002\u0011\u001d,G/\u00138qkR$\"!!;\u0011\u0007]\fY/C\u0002\u0002nn\u0012\u0011CQ5oCJL\b+\u0019:tKJLe\u000e];u\u0003!\tG\r\u001a+pW\u0016tGCBAP\u0003g\u0014\u0019\u0001C\u0004\u0002v\u001a\u0002\r!a>\u0002\u000bQ|7.\u001a8\u0011\u000b9\u000bI0!@\n\u0007\u0005mxJA\u0003BeJ\f\u0017\u0010E\u0002O\u0003\u007fL1A!\u0001P\u0005\u0011auN\\4\t\u000f\t\u0015a\u00051\u0001\u0002T\u0006a\u0001/\u001e;U_.,g.\u00138M\u0007\u0006)\u0001/\u0019:tKR\u0011!1\u0002\u0019\u0005\u0005\u001b\u0011i\u0002\u0005\u0004\u0003\u0010\tU!\u0011D\u0007\u0003\u0005#Q1Aa\u0005p\u0003\u00191\u0018\r\\;fg&!!q\u0003B\t\u0005\u00151\u0016\r\\;f!\u0011\u0011YB!\b\r\u0001\u0011Y!qD\u0014\u0002\u0002\u0003\u0005)\u0011\u0001B\u0011\u0005\ryF%M\t\u0005\u0005G\u0011I\u0003E\u0002O\u0005KI1Aa\nP\u0005\u001dqu\u000e\u001e5j]\u001e\u00042A\u0014B\u0016\u0013\r\u0011ic\u0014\u0002\u0004\u0003:L\u0018A\u0003:fC\u0012DU-\u00193fe\u0006QAn\\1e\u0007\u0006\u001c\u0007.Z:\u0002\u0019A\u0014xnY3tgZ\u000bG.^3\u0015\r\u0005}%q\u0007B\u001e\u0011\u001d\u0011ID\u000ba\u0001\u0003\u0003\f!\u0003^8lK:$\u0016\u0010]3XSRDg\t\\1hg\"9!Q\u0001\u0016A\u0002\u0005M\u0017AD2sK\u0006$XmS3z)>\\WM\u001c\u000b\u000b\u0003o\u0014\tEa\u0011\u0003H\t-\u0003\"B,,\u0001\u0004I\u0006b\u0002B#W\u0001\u0007\u0011\u0011Y\u0001\n]\u0006lW-\u00138eKbDqA!\u0013,\u0001\u0004\t\t-A\u0004og&sG-\u001a=\t\u000f\t53\u00061\u0001\u0003P\u0005IAo\\6f]RK\b/\u001a\t\u0005\u0005#\u0012yG\u0004\u0003\u0003T\t-d\u0002\u0002B+\u0005SrAAa\u0016\u0003h9!!\u0011\fB3\u001d\u0011\u0011YFa\u0019\u000f\t\tu#\u0011\r\b\u00049\n}\u0013\"\u0001&\n\u0005!K\u0015B\u0001$H\u0013\t!U)\u0003\u0002C\u0007&\u0011\u0001)Q\u0005\u0004\u0005[z\u0014a\u0003#x)>\\WM\u001c+za\u0016LAA!\u001d\u0003t\tYAi\u001e+pW\u0016tG+\u001f9f\u0015\r\u0011igP\u0001\u0011GJ,\u0017\r^3WC2,X\rV8lK:$\u0002\"a>\u0003z\tu$q\u0010\u0005\b\u0005wb\u0003\u0019AA\u007f\u0003\u0019aWM\\4uQ\"9!Q\n\u0017A\u0002\t=\u0003b\u0002BAY\u0001\u0007\u00111[\u0001\nQ\u0006\u001c8k\u00195f[\u0006\fQB]3bIR{7.\u001a8UsB,GCAAa\u00039\u0011X-\u00193BiR\u0014\u0018NY;uKN\f!B]3bIN\u001b\u0007.Z7b)\u0011\t\tM!$\t\u000f\te\u0002\u00071\u0001\u0002B\u0006I!/Z1e\u0003J\u0014\u0018-_\u0001\u000be\u0016\fGm\u00142kK\u000e$\u0018a\u0004:fC\u0012\u001c\u0006n\u001c:u'R\u0014\u0018N\\4\u0015\u0003e\u000b1C]3bI:\u000bW.\u001a#fG2\f'/\u0019;j_:\f\u0011C]3bI:\u001bF)Z2mCJ\fG/[8o)\t\tI%A\u0005tW&\u0004()\u001f;fgR!\u0011q\u0014BQ\u0011\u001d\u0011\u0019K\u000ea\u0001\u0003\u0003\f\u0011A\\\u0001\u000be\u0016\fGmQ1dQ\u0016\u001c\u0018\u0001\u0006:fC\u0012<En\u001c2bYR{7.\u001a8J]\u0012,\u0007\u0010\u0006\u0003\u0002\u000e\n-\u0006b\u0002BWq\u0001\u0007\u0011Q`\u0001\u0011i>\\WM\\:M_:<7oQ8v]R\f!C]3bI2{7-\u0019;j_:\u001c\u0015m\u00195fgR\u0011\u0011q\u0016")
public class IndexedWeaveBinaryParser
implements WeaveBinaryParser {
    private final String name;
    private final SeekableStream ss;
    private final EvaluationContext ctx;
    private final SeekableStream seekableStream;
    private final Charset charset;
    private final DataInputStream dataInputStream;
    private final SourceReader sourceReader;
    private final ArrayBuffer<Namespace> namespaces;
    private final ArrayBuffer<String> names;
    private final ZoneIdMap zoneIds;
    private final ZoneOffsetMap zoneOffsets;
    private final LocationCacheBuilder lcBuilder;
    private TokenArray tokenArray;
    private LocationCaches locationCaches;
    private int depth;
    private boolean hasIndex;
    private final int org$mule$weave$v2$module$dwb$reader$WeaveBinaryParser$$readBufferSize;
    private final byte[] org$mule$weave$v2$module$dwb$reader$WeaveBinaryParser$$readBuffer;

    @Override
    public void verifyMagicWord(DataInputStream dataInputStream) {
        WeaveBinaryParser.verifyMagicWord$(this, dataInputStream);
    }

    @Override
    public void verifyVersion(DataInputStream dataInputStream) {
        WeaveBinaryParser.verifyVersion$(this, dataInputStream);
    }

    @Override
    public boolean verifyIndexPresence(DataInputStream dataInputStream) {
        return WeaveBinaryParser.verifyIndexPresence$(this, dataInputStream);
    }

    @Override
    public byte[] getReadBuffer() {
        return WeaveBinaryParser.getReadBuffer$(this);
    }

    @Override
    public byte[] getReadBuffer(int length) {
        return WeaveBinaryParser.getReadBuffer$(this, length);
    }

    @Override
    public int org$mule$weave$v2$module$dwb$reader$WeaveBinaryParser$$readBufferSize() {
        return this.org$mule$weave$v2$module$dwb$reader$WeaveBinaryParser$$readBufferSize;
    }

    @Override
    public byte[] org$mule$weave$v2$module$dwb$reader$WeaveBinaryParser$$readBuffer() {
        return this.org$mule$weave$v2$module$dwb$reader$WeaveBinaryParser$$readBuffer;
    }

    @Override
    public final void org$mule$weave$v2$module$dwb$reader$WeaveBinaryParser$_setter_$org$mule$weave$v2$module$dwb$reader$WeaveBinaryParser$$readBufferSize_$eq(int x$1) {
        this.org$mule$weave$v2$module$dwb$reader$WeaveBinaryParser$$readBufferSize = x$1;
    }

    @Override
    public final void org$mule$weave$v2$module$dwb$reader$WeaveBinaryParser$_setter_$org$mule$weave$v2$module$dwb$reader$WeaveBinaryParser$$readBuffer_$eq(byte[] x$1) {
        this.org$mule$weave$v2$module$dwb$reader$WeaveBinaryParser$$readBuffer = x$1;
    }

    public String name() {
        return this.name;
    }

    private SeekableStream seekableStream() {
        return this.seekableStream;
    }

    private Charset charset() {
        return this.charset;
    }

    private DataInputStream dataInputStream() {
        return this.dataInputStream;
    }

    private SourceReader sourceReader() {
        return this.sourceReader;
    }

    private ArrayBuffer<Namespace> namespaces() {
        return this.namespaces;
    }

    private ArrayBuffer<String> names() {
        return this.names;
    }

    private ZoneIdMap zoneIds() {
        return this.zoneIds;
    }

    private ZoneOffsetMap zoneOffsets() {
        return this.zoneOffsets;
    }

    private LocationCacheBuilder lcBuilder() {
        return this.lcBuilder;
    }

    public TokenArray tokenArray() {
        return this.tokenArray;
    }

    public void tokenArray_$eq(TokenArray x$1) {
        this.tokenArray = x$1;
    }

    public LocationCaches locationCaches() {
        return this.locationCaches;
    }

    public void locationCaches_$eq(LocationCaches x$1) {
        this.locationCaches = x$1;
    }

    private int depth() {
        return this.depth;
    }

    private void depth_$eq(int x$1) {
        this.depth = x$1;
    }

    private boolean hasIndex() {
        return this.hasIndex;
    }

    private void hasIndex_$eq(boolean x$1) {
        this.hasIndex = x$1;
    }

    public void close() {
        this.dataInputStream().close();
        this.sourceReader().close();
    }

    public BinaryParserInput getInput() {
        return new BinaryParserInput(this.ss, this.seekableStream(), this.dataInputStream(), this.sourceReader(), this.locationCaches(), this.tokenArray(), this.namespaces(), this.names(), this.zoneIds(), this.zoneOffsets(), this.ctx);
    }

    public void addToken(long[] token, boolean putTokenInLC) {
        block0: {
            this.tokenArray().$plus$eq(token);
            if (!putTokenInLC) break block0;
            this.lcBuilder().addToken(token, this.tokenArray().length() - 1L);
        }
    }

    @Override
    public Value<?> parse() {
        this.readHeader();
        if (this.hasIndex()) {
            this.readCaches();
        } else {
            this.loadCaches();
        }
        return WeaveBinaryValue$.MODULE$.apply(0, (Option<Object>)None$.MODULE$, this.getInput());
    }

    public void readHeader() {
        this.verifyMagicWord(this.dataInputStream());
        this.verifyVersion(this.dataInputStream());
        this.hasIndex_$eq(this.verifyIndexPresence(this.dataInputStream()));
    }

    public void loadCaches() {
        if (this.tokenArray() != null) {
            return;
        }
        this.tokenArray_$eq((TokenArray)this.ctx.registerCloseable((AutoCloseable)new TokenArray(TokenArray$.MODULE$.$lessinit$greater$default$1(), this.ctx)));
        int nextValueType = this.readTokenType();
        if (nextValueType == -1) {
            throw new IllegalArgumentException("Input should not be empty");
        }
        this.processValue(nextValueType, true);
        this.locationCaches_$eq((LocationCaches)this.ctx.registerCloseable((AutoCloseable)this.lcBuilder().build()));
        this.seekableStream().seek((long)WeaveBinaryWriter$.MODULE$.HEADER_BYTES());
    }

    public void processValue(int tokenTypeWithFlags, boolean putTokenInLC) {
        block60: {
            Object object;
            int tokenType = DwTokenHelper$.MODULE$.getTokenType(tokenTypeWithFlags);
            boolean hasSchema = DwTokenHelper$.MODULE$.hasSchemaProps(tokenTypeWithFlags);
            int n = tokenType;
            if (DwTokenType$.MODULE$.Key() == n) {
                int nameIndex = this.dataInputStream().readUnsignedShort();
                String nameStr = (String)this.names().apply(nameIndex);
                long[] token = this.createKeyToken(nameStr, nameIndex, DwTokenHelper$.MODULE$.NO_NAMESPACE(), DwTokenType$.MODULE$.Key());
                this.addToken(token, putTokenInLC);
                object = BoxedUnit.UNIT;
            } else if (DwTokenType$.MODULE$.KeyWithNS() == n) {
                int nameIndex = this.dataInputStream().readUnsignedShort();
                String nameStr = (String)this.names().apply(nameIndex);
                int nsIndex = this.dataInputStream().readUnsignedShort();
                long[] token = this.createKeyToken(nameStr, nameIndex, nsIndex, DwTokenType$.MODULE$.KeyWithNS());
                this.addToken(token, putTokenInLC);
                object = BoxedUnit.UNIT;
            } else if (DwTokenType$.MODULE$.KeyWithAttr() == n) {
                int nameIndex = this.dataInputStream().readUnsignedShort();
                String nameStr = (String)this.names().apply(nameIndex);
                long[] token = this.createKeyToken(nameStr, nameIndex, DwTokenHelper$.MODULE$.NO_NAMESPACE(), DwTokenType$.MODULE$.KeyWithAttr());
                this.addToken(token, putTokenInLC);
                this.readAttributes();
                object = BoxedUnit.UNIT;
            } else if (DwTokenType$.MODULE$.KeyWithNSAttr() == n) {
                int nameIndex = this.dataInputStream().readUnsignedShort();
                String nameStr = (String)this.names().apply(nameIndex);
                int nsIndex = this.dataInputStream().readUnsignedShort();
                long[] token = this.createKeyToken(nameStr, nameIndex, nsIndex, DwTokenType$.MODULE$.KeyWithNSAttr());
                this.addToken(token, putTokenInLC);
                this.readAttributes();
                object = BoxedUnit.UNIT;
            } else if (DwTokenType$.MODULE$.String8() == n) {
                int length = this.dataInputStream().read();
                long[] token = this.createValueToken(length, tokenType, hasSchema);
                this.addToken(token, putTokenInLC);
                byte[] readBuffer = this.getReadBuffer(length);
                object = BinaryValueRetriever$.MODULE$.readString(this.dataInputStream(), length, readBuffer);
            } else if (DwTokenType$.MODULE$.String32() == n) {
                int length = this.dataInputStream().readInt();
                long[] token = this.createValueToken(length, tokenType, hasSchema);
                this.addToken(token, putTokenInLC);
                object = BinaryValueRetriever$.MODULE$.readString(this.dataInputStream(), length, this.getReadBuffer(length));
            } else if (DwTokenType$.MODULE$.Null() == n) {
                long[] token = this.createValueToken(0L, tokenType, hasSchema);
                this.addToken(token, putTokenInLC);
                object = BoxedUnit.UNIT;
            } else if (DwTokenType$.MODULE$.True() == n) {
                long[] token = this.createValueToken(0L, tokenType, hasSchema);
                this.addToken(token, putTokenInLC);
                object = BoxedUnit.UNIT;
            } else if (DwTokenType$.MODULE$.False() == n) {
                long[] token = this.createValueToken(0L, tokenType, hasSchema);
                this.addToken(token, putTokenInLC);
                object = BoxedUnit.UNIT;
            } else if (DwTokenType$.MODULE$.Int() == n) {
                long[] token = this.createValueToken(4L, tokenType, hasSchema);
                this.addToken(token, putTokenInLC);
                this.skipBytes(4);
                object = BoxedUnit.UNIT;
            } else if (DwTokenType$.MODULE$.Long() == n) {
                long[] token = this.createValueToken(8L, tokenType, hasSchema);
                this.addToken(token, putTokenInLC);
                this.skipBytes(8);
                object = BoxedUnit.UNIT;
            } else if (DwTokenType$.MODULE$.BigInt() == n) {
                int length = this.dataInputStream().readUnsignedShort();
                long[] token = this.createValueToken(length, tokenType, hasSchema);
                this.addToken(token, putTokenInLC);
                this.skipBytes(length);
                object = BoxedUnit.UNIT;
            } else if (DwTokenType$.MODULE$.Double() == n) {
                long[] token = this.createValueToken(8L, tokenType, hasSchema);
                this.addToken(token, putTokenInLC);
                this.skipBytes(8);
                object = BoxedUnit.UNIT;
            } else if (DwTokenType$.MODULE$.BigDecimal() == n) {
                int length = this.dataInputStream().readUnsignedShort();
                long[] token = this.createValueToken(length, tokenType, hasSchema);
                this.addToken(token, putTokenInLC);
                this.skipBytes(length);
                object = BoxedUnit.UNIT;
            } else if (DwTokenType$.MODULE$.ObjectStart() == n) {
                BoxedUnit boxedUnit;
                long[] startToken = this.createValueToken(0L, tokenType, false);
                long startTokenIndex = this.tokenArray().length();
                this.addToken(startToken, putTokenInLC);
                int structureEndToken = this.readObject();
                hasSchema = DwTokenHelper$.MODULE$.hasSchemaProps(structureEndToken);
                if (hasSchema) {
                    long startOffset = DwTokenHelper$.MODULE$.getOffset(startToken);
                    long length = this.seekableStream().position() - startOffset;
                    long[] newStartToken = WeaveValueToken$.MODULE$.apply(startOffset, DwTokenType$.MODULE$.ObjectStart(), this.depth(), length, hasSchema);
                    this.tokenArray().update(startTokenIndex, newStartToken);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                object = boxedUnit;
            } else if (DwTokenType$.MODULE$.ArrayStart() == n) {
                BoxedUnit boxedUnit;
                long[] startToken = this.createValueToken(0L, tokenType, false);
                long startTokenIndex = this.tokenArray().length();
                this.addToken(startToken, putTokenInLC);
                int structureEndToken = this.readArray();
                hasSchema = DwTokenHelper$.MODULE$.hasSchemaProps(structureEndToken);
                if (hasSchema) {
                    long startOffset = DwTokenHelper$.MODULE$.getOffset(startToken);
                    long length = this.seekableStream().position() - startOffset;
                    long[] newStartToken = WeaveValueToken$.MODULE$.apply(startOffset, DwTokenType$.MODULE$.ArrayStart(), this.depth(), length, hasSchema);
                    this.tokenArray().update(startTokenIndex, newStartToken);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                object = boxedUnit;
            } else if (DwTokenType$.MODULE$.Binary() == n) {
                int length = this.dataInputStream().readInt();
                long[] token = this.createValueToken(length, tokenType, hasSchema);
                this.addToken(token, putTokenInLC);
                this.skipBytes(length);
                object = BoxedUnit.UNIT;
            } else if (DwTokenType$.MODULE$.DeclareNS() == n) {
                this.readNSDeclaration();
                this.processValue(this.readTokenType(), putTokenInLC);
                object = BoxedUnit.UNIT;
            } else if (DwTokenType$.MODULE$.DeclareName() == n) {
                this.readNameDeclaration();
                this.processValue(this.readTokenType(), putTokenInLC);
                object = BoxedUnit.UNIT;
            } else if (DwTokenType$.MODULE$.DateTime() == n) {
                int length = 20;
                long[] token = this.createValueToken(length, tokenType, hasSchema);
                this.addToken(token, putTokenInLC);
                this.skipBytes(length);
                object = BoxedUnit.UNIT;
            } else if (DwTokenType$.MODULE$.LocalDateTime() == n) {
                int length = 12;
                long[] token = this.createValueToken(length, tokenType, hasSchema);
                this.addToken(token, putTokenInLC);
                this.skipBytes(length);
                object = BoxedUnit.UNIT;
            } else if (DwTokenType$.MODULE$.LocalDate() == n) {
                int length = 8;
                long[] token = this.createValueToken(length, tokenType, hasSchema);
                this.addToken(token, putTokenInLC);
                this.skipBytes(length);
                object = BoxedUnit.UNIT;
            } else if (DwTokenType$.MODULE$.Time() == n) {
                int length = 16;
                long[] token = this.createValueToken(length, tokenType, hasSchema);
                this.addToken(token, putTokenInLC);
                this.skipBytes(length);
                object = BoxedUnit.UNIT;
            } else if (DwTokenType$.MODULE$.LocalTime() == n) {
                int length = 8;
                long[] token = this.createValueToken(length, tokenType, hasSchema);
                this.addToken(token, putTokenInLC);
                this.skipBytes(length);
                object = BoxedUnit.UNIT;
            } else if (DwTokenType$.MODULE$.TimeZone() == n) {
                int length = 8;
                long[] token = this.createValueToken(length, tokenType, hasSchema);
                this.addToken(token, putTokenInLC);
                this.skipBytes(length);
                object = BoxedUnit.UNIT;
            } else if (DwTokenType$.MODULE$.Period() == n) {
                int length = this.dataInputStream().readUnsignedShort();
                long[] token = this.createValueToken(length, tokenType, hasSchema);
                this.addToken(token, putTokenInLC);
                this.skipBytes(length);
                object = BoxedUnit.UNIT;
            } else if (DwTokenType$.MODULE$.Range() == n) {
                int length = 8;
                long[] token = this.createValueToken(length, tokenType, hasSchema);
                this.addToken(token, putTokenInLC);
                this.skipBytes(length);
                object = BoxedUnit.UNIT;
            } else if (DwTokenType$.MODULE$.Regex() == n) {
                int length = this.dataInputStream().readUnsignedShort();
                long[] token = this.createValueToken(length, tokenType, hasSchema);
                this.addToken(token, putTokenInLC);
                this.skipBytes(length);
                object = BoxedUnit.UNIT;
            } else {
                throw new DWBRuntimeExecutionException(new StringBuilder(24).append("Unexpected value type '").append(DwTokenType$.MODULE$.getNameFor(n)).append("'").toString(), DWBRuntimeExecutionException$.MODULE$.$lessinit$greater$default$2());
            }
            if (!hasSchema) break block60;
            this.readSchema();
        }
    }

    private long[] createKeyToken(String name, int nameIndex, int nsIndex, int tokenType) {
        int length = WeaveBinaryUtils$.MODULE$.getUTFByteLength(name);
        int nameHash = DwTokenHelper$.MODULE$.hash(name);
        return WeaveKeyToken$.MODULE$.apply(this.seekableStream().position(), tokenType, this.depth(), length, nameHash, nameIndex, nsIndex);
    }

    private long[] createValueToken(long length, int tokenType, boolean hasSchema) {
        return WeaveValueToken$.MODULE$.apply(this.seekableStream().position(), tokenType, this.depth(), length, hasSchema);
    }

    public int readTokenType() {
        return this.dataInputStream().read();
    }

    private void readAttributes() {
        int attrCount = this.dataInputStream().readUnsignedShort();
        for (int i = 0; i < attrCount; ++i) {
            int nextValueType = this.readTokenType();
            this.processValue(nextValueType, false);
            this.processValue(this.readTokenType(), false);
        }
    }

    public void readSchema() {
        int propCount = this.dataInputStream().readUnsignedShort();
        for (int i = 0; i < propCount; ++i) {
            int nextKeyValueType = this.dataInputStream().read();
            this.processValue(nextKeyValueType, false);
            this.processValue(this.dataInputStream().read(), false);
        }
    }

    private int tokenType(int tokenTypeWithFlags) {
        return tokenTypeWithFlags & DwTokenHelper$.MODULE$.TOKEN_TYPE_MASK();
    }

    /*
     * WARNING - void declaration
     */
    private int readArray() {
        void var1_1;
        this.depth_$eq(this.depth() + 1);
        int tokenTypeWithFlags = this.readTokenType();
        while (this.tokenType(tokenTypeWithFlags) != DwTokenType$.MODULE$.StructureEnd()) {
            this.processValue(tokenTypeWithFlags, true);
            tokenTypeWithFlags = this.readTokenType();
        }
        this.depth_$eq(this.depth() - 1);
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private int readObject() {
        void var1_1;
        this.depth_$eq(this.depth() + 1);
        int tokenTypeWithFlags = this.readTokenType();
        while (this.tokenType(tokenTypeWithFlags) != DwTokenType$.MODULE$.StructureEnd()) {
            this.processValue(tokenTypeWithFlags, true);
            this.processValue(this.readTokenType(), false);
            tokenTypeWithFlags = this.readTokenType();
        }
        this.depth_$eq(this.depth() - 1);
        return (int)var1_1;
    }

    private String readShortString() {
        return BinaryValueRetriever$.MODULE$.readShortString(this.dataInputStream(), this.getReadBuffer());
    }

    /*
     * WARNING - void declaration
     */
    public String readNameDeclaration() {
        void var1_1;
        String name = this.readShortString();
        this.names().$plus$eq((Object)name);
        return var1_1;
    }

    public Namespace readNSDeclaration() {
        String str = this.readShortString();
        Tuple2 tuple2 = new StringOps(Predef$.MODULE$.augmentString(str)).splitAt(str.indexOf(":"));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String prefix = (String)tuple2._1();
        String uri = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)prefix, (Object)uri);
        Tuple2 tuple23 = tuple22;
        String prefix2 = (String)tuple23._1();
        String uri2 = (String)tuple23._2();
        Namespace ns = new Namespace(prefix2, uri2.substring(1));
        this.namespaces().$plus$eq((Object)ns);
        return ns;
    }

    private void skipBytes(int n) {
        for (int i = 0; i < n; ++i) {
            this.dataInputStream().read();
        }
    }

    public void readCaches() {
        if (this.tokenArray() != null) {
            return;
        }
        long size = this.seekableStream().size();
        this.seekableStream().seek(size - 32L);
        int namesIndexBytes = this.dataInputStream().readInt();
        int namesIndexCount = this.dataInputStream().readInt();
        int nsIndexBytes = this.dataInputStream().readInt();
        int nsIndexCount = this.dataInputStream().readInt();
        long tokensLongsCount = this.dataInputStream().readLong();
        long lcIndexLength = this.dataInputStream().readLong();
        long offset = size - 32L - (long)namesIndexBytes - (long)nsIndexBytes - tokensLongsCount * 8L - lcIndexLength;
        this.seekableStream().seek(offset);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), namesIndexCount).foreach((Function1 & Serializable & scala.Serializable)_ -> IndexedWeaveBinaryParser.$anonfun$readCaches$1(this, BoxesRunTime.unboxToInt((Object)_)));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), nsIndexCount).foreach((Function1 & Serializable & scala.Serializable)_ -> IndexedWeaveBinaryParser.$anonfun$readCaches$2(this, BoxesRunTime.unboxToInt((Object)_)));
        this.tokenArray_$eq((TokenArray)this.ctx.registerCloseable((AutoCloseable)this.readGlobalTokenIndex(tokensLongsCount)));
        this.locationCaches_$eq((LocationCaches)this.ctx.registerCloseable((AutoCloseable)this.readLocationCaches()));
        this.seekableStream().seek((long)WeaveBinaryWriter$.MODULE$.HEADER_BYTES());
    }

    /*
     * WARNING - void declaration
     */
    public TokenArray readGlobalTokenIndex(long tokensLongsCount) {
        void var3_2;
        TokenArray tokenArray = new TokenArray(TokenArray$.MODULE$.$lessinit$greater$default$1(), this.ctx);
        int i = 0;
        long[] token = new long[2];
        while ((long)i < tokensLongsCount / 2L) {
            long firstLong = this.dataInputStream().readLong();
            long secondLong = this.dataInputStream().readLong();
            token[0] = firstLong;
            token[1] = secondLong;
            tokenArray.$plus$eq(token);
            ++i;
        }
        return var3_2;
    }

    public LocationCaches readLocationCaches() {
        int lcsLength = this.dataInputStream().readUnsignedShort();
        ILongArray[] lcs = new ILongArray[lcsLength];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), lcsLength).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)depth -> {
            DefaultLongArray lc = new DefaultLongArray(DefaultLongArray$.MODULE$.$lessinit$greater$default$1(), $this.ctx);
            long lcLength = this.dataInputStream().readLong();
            for (long entryIndex = 0L; entryIndex < lcLength; ++entryIndex) {
                lc.$plus$eq(this.dataInputStream().readLong());
            }
            lcs$1[depth] = lc;
        });
        return new LocationCaches(lcs);
    }

    public static final /* synthetic */ ArrayBuffer $anonfun$readCaches$1(IndexedWeaveBinaryParser $this, int _) {
        int length = $this.dataInputStream().readUnsignedShort();
        String name = BinaryValueRetriever$.MODULE$.readString($this.dataInputStream(), length, $this.getReadBuffer(length));
        return $this.names().$plus$eq((Object)name);
    }

    public static final /* synthetic */ ArrayBuffer $anonfun$readCaches$2(IndexedWeaveBinaryParser $this, int _) {
        int length = $this.dataInputStream().readUnsignedShort();
        String prefixUriStr = BinaryValueRetriever$.MODULE$.readString($this.dataInputStream(), length, $this.getReadBuffer(length));
        int index = prefixUriStr.indexOf(":");
        Tuple2 tuple2 = new StringOps(Predef$.MODULE$.augmentString(prefixUriStr)).splitAt(index);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String prefix = (String)tuple2._1();
        String uri = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)prefix, (Object)uri);
        Tuple2 tuple23 = tuple22;
        String prefix2 = (String)tuple23._1();
        String uri2 = (String)tuple23._2();
        return $this.namespaces().$plus$eq((Object)new Namespace(prefix2, uri2.substring(1)));
    }

    public IndexedWeaveBinaryParser(String name, SeekableStream ss, EvaluationContext ctx) {
        this.name = name;
        this.ss = ss;
        this.ctx = ctx;
        WeaveBinaryParser.$init$(this);
        this.seekableStream = ss.spinOff(ctx);
        this.charset = Charset.forName("UTF-8");
        this.dataInputStream = new DataInputStream((InputStream)this.seekableStream());
        this.sourceReader = SeekableStreamSourceReader$.MODULE$.apply(this.seekableStream(), this.charset(), ctx.serviceManager().memoryService());
        this.namespaces = new ArrayBuffer(0);
        this.names = new ArrayBuffer();
        this.zoneIds = new ZoneIdMap(this.names());
        this.zoneOffsets = new ZoneOffsetMap(this.names());
        this.lcBuilder = new LocationCacheBuilder((TokenHelper)DwTokenHelper$.MODULE$, ctx);
        this.depth = 0;
    }
}

