/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.dwb.reader.memory;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Map;
import org.mule.runtime.weave.dwb.api.IWeaveValue;
import org.mule.weave.v2.io.SeekableStream;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.model.capabilities.UnknownLocationCapable$;
import org.mule.weave.v2.model.structure.ArraySeq$;
import org.mule.weave.v2.model.structure.KeyValuePair;
import org.mule.weave.v2.model.structure.KeyValuePair$;
import org.mule.weave.v2.model.structure.NameSeq;
import org.mule.weave.v2.model.structure.NameValuePair;
import org.mule.weave.v2.model.structure.Namespace;
import org.mule.weave.v2.model.structure.ObjectSeq;
import org.mule.weave.v2.model.structure.ObjectSeq$;
import org.mule.weave.v2.model.structure.QualifiedName;
import org.mule.weave.v2.model.structure.schema.Schema;
import org.mule.weave.v2.model.structure.schema.Schema$;
import org.mule.weave.v2.model.structure.schema.SchemaProperty$;
import org.mule.weave.v2.model.types.ObjectType$;
import org.mule.weave.v2.model.types.StringType$;
import org.mule.weave.v2.model.values.ArrayValue;
import org.mule.weave.v2.model.values.AttributesValue$;
import org.mule.weave.v2.model.values.BinaryValue;
import org.mule.weave.v2.model.values.BinaryValue$;
import org.mule.weave.v2.model.values.BooleanValue$;
import org.mule.weave.v2.model.values.DateTimeValue$;
import org.mule.weave.v2.model.values.KeyValue;
import org.mule.weave.v2.model.values.KeyValue$;
import org.mule.weave.v2.model.values.LocalDateTimeValue$;
import org.mule.weave.v2.model.values.LocalDateValue$;
import org.mule.weave.v2.model.values.LocalTimeValue$;
import org.mule.weave.v2.model.values.MaterializedObjectValue;
import org.mule.weave.v2.model.values.MaterializedObjectValue$;
import org.mule.weave.v2.model.values.NullValue$;
import org.mule.weave.v2.model.values.NumberValue$;
import org.mule.weave.v2.model.values.ObjectValue;
import org.mule.weave.v2.model.values.PeriodValue$;
import org.mule.weave.v2.model.values.RangeValue$;
import org.mule.weave.v2.model.values.RegexValue$;
import org.mule.weave.v2.model.values.StringValue;
import org.mule.weave.v2.model.values.StringValue$;
import org.mule.weave.v2.model.values.TimeValue$;
import org.mule.weave.v2.model.values.TimeZoneValue$;
import org.mule.weave.v2.model.values.Value;
import org.mule.weave.v2.module.dwb.DwTokenHelper$;
import org.mule.weave.v2.module.dwb.DwTokenType$;
import org.mule.weave.v2.module.dwb.reader.WeaveBinaryParser;
import org.mule.weave.v2.module.dwb.reader.WeaveValue$;
import org.mule.weave.v2.module.dwb.reader.exceptions.DWBRuntimeExecutionException;
import org.mule.weave.v2.module.dwb.reader.exceptions.DWBRuntimeExecutionException$;
import org.mule.weave.v2.module.dwb.reader.indexed.BinaryValueRetriever$;
import org.mule.weave.v2.module.dwb.reader.memory.RedefinedObjectSeq;
import org.mule.weave.v2.module.json.reader.memory.InMemoryJsonArray;
import org.mule.weave.v2.parser.location.Location;
import org.mule.weave.v2.parser.location.LocationCapable;
import org.mule.weave.v2.parser.location.UnknownLocation$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.package$;
import scala.reflect.ScalaSignature;
import spire.math.Number$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005h\u0001\u0002\u0012$\u0001QB\u0001b\u0010\u0001\u0003\u0006\u0004%\t\u0001\u0011\u0005\t\u0019\u0002\u0011\t\u0011)A\u0005\u0003\"AQ\n\u0001BC\u0002\u0013\u0005a\n\u0003\u0005V\u0001\t\u0005\t\u0015!\u0003P\u0011!1\u0006A!A!\u0002\u00179\u0006\"B/\u0001\t\u0003q\u0006bB3\u0001\u0005\u0004%IA\u001a\u0005\u0007]\u0002\u0001\u000b\u0011B4\t\u000f=\u0004!\u0019!C\u0005a\"1q\u0010\u0001Q\u0001\nED\u0011\"!\u0001\u0001\u0005\u0004%I!a\u0001\t\u0011\u0005\u001d\u0001\u0001)A\u0005\u0003\u000bA\u0011\"!\u0003\u0001\u0005\u0004%I!a\u0003\t\u0011\u0005-\u0002\u0001)A\u0005\u0003\u001bA\u0011\"!\f\u0001\u0005\u0004%I!a\f\t\u0011\u0005e\u0002\u0001)A\u0005\u0003cAq!a\u000f\u0001\t\u0003\ti\u0004C\u0004\u0002F\u0001!\t!a\u0012\t\u000f\u00055\u0004\u0001\"\u0001\u0002p!9\u0011Q\u0010\u0001\u0005\u0002\u0005}\u0004bBAD\u0001\u0011\u0005\u0011\u0011\u0012\u0005\b\u00033\u0003A\u0011BAN\u0011\u001d\ti\n\u0001C\u0001\u00037Cq!a(\u0001\t\u0003\t\t\u000bC\u0004\u0002$\u0002!I!!*\t\u000f\u00055\u0006\u0001\"\u0003\u00020\"9\u0011q\u0017\u0001\u0005\n\u0005e\u0006bBAb\u0001\u0011%\u0011Q\u0019\u0005\b\u0003\u0013\u0004A\u0011BAf\u0011\u001d\t)\u000e\u0001C\u0001\u00037Cq!a6\u0001\t\u0013\t\t\u000bC\u0004\u0002Z\u0002!I!a7\t\u000f\u0005u\u0007\u0001\"\u0003\u0002`\nI\u0012J\\'f[>\u0014\u0018pV3bm\u0016\u0014\u0015N\\1ssB\u000b'o]3s\u0015\t!S%\u0001\u0004nK6|'/\u001f\u0006\u0003M\u001d\naA]3bI\u0016\u0014(B\u0001\u0015*\u0003\r!wO\u0019\u0006\u0003U-\na!\\8ek2,'B\u0001\u0017.\u0003\t1(G\u0003\u0002/_\u0005)q/Z1wK*\u0011\u0001'M\u0001\u0005[VdWMC\u00013\u0003\ry'oZ\u0002\u0001'\r\u0001Qg\u000f\t\u0003mej\u0011a\u000e\u0006\u0002q\u0005)1oY1mC&\u0011!h\u000e\u0002\u0007\u0003:L(+\u001a4\u0011\u0005qjT\"A\u0013\n\u0005y*#!E,fCZ,')\u001b8bef\u0004\u0016M]:fe\u0006!a.Y7f+\u0005\t\u0005C\u0001\"J\u001d\t\u0019u\t\u0005\u0002Eo5\tQI\u0003\u0002Gg\u00051AH]8pizJ!\u0001S\u001c\u0002\rA\u0013X\rZ3g\u0013\tQ5J\u0001\u0004TiJLgn\u001a\u0006\u0003\u0011^\nQA\\1nK\u0002\n1\"\u001b8qkR\u001cFO]3b[V\tq\n\u0005\u0002Q'6\t\u0011K\u0003\u0002SW\u0005\u0011\u0011n\\\u0005\u0003)F\u0013abU3fW\u0006\u0014G.Z*ue\u0016\fW.\u0001\u0007j]B,Ho\u0015;sK\u0006l\u0007%A\u0002dib\u0004\"\u0001W.\u000e\u0003eS!AW\u0016\u0002\u000b5|G-\u001a7\n\u0005qK&!E#wC2,\u0018\r^5p]\u000e{g\u000e^3yi\u00061A(\u001b8jiz\"2aX2e)\t\u0001'\r\u0005\u0002b\u00015\t1\u0005C\u0003W\r\u0001\u000fq\u000bC\u0003@\r\u0001\u0007\u0011\tC\u0003N\r\u0001\u0007q*A\u0003j]B,H/F\u0001h!\tAG.D\u0001j\u0015\t\u0011&NC\u0001l\u0003\u0011Q\u0017M^1\n\u00055L'a\u0004#bi\u0006Le\u000e];u'R\u0014X-Y7\u0002\r%t\u0007/\u001e;!\u0003)q\u0017-\\3ta\u0006\u001cWm]\u000b\u0002cB\u0019!o^=\u000e\u0003MT!\u0001^;\u0002\u000f5,H/\u00192mK*\u0011aoN\u0001\u000bG>dG.Z2uS>t\u0017B\u0001=t\u0005-\t%O]1z\u0005V4g-\u001a:\u0011\u0005ilX\"A>\u000b\u0005qL\u0016!C:ueV\u001cG/\u001e:f\u0013\tq8PA\u0005OC6,7\u000f]1dK\u0006Ya.Y7fgB\f7-Z:!\u0003\u0015q\u0017-\\3t+\t\t)\u0001E\u0002so\u0006\u000baA\\1nKN\u0004\u0013a\u0002>p]\u0016LEm]\u000b\u0003\u0003\u001b\u0001rA]A\b\u0003'\ty\"C\u0002\u0002\u0012M\u0014q\u0001S1tQ6\u000b\u0007\u000f\u0005\u0003\u0002\u0016\u0005mQBAA\f\u0015\r\tIB[\u0001\u0005Y\u0006tw-\u0003\u0003\u0002\u001e\u0005]!aB%oi\u0016<WM\u001d\t\u0005\u0003C\t9#\u0004\u0002\u0002$)\u0019\u0011Q\u00056\u0002\tQLW.Z\u0005\u0005\u0003S\t\u0019C\u0001\u0004[_:,\u0017\nZ\u0001\tu>tW-\u00133tA\u0005Y!p\u001c8f\u001f\u001a47/\u001a;t+\t\t\t\u0004E\u0004s\u0003\u001f\t\u0019\"a\r\u0011\t\u0005\u0005\u0012QG\u0005\u0005\u0003o\t\u0019C\u0001\u0006[_:,wJ\u001a4tKR\fAB_8oK>3gm]3ug\u0002\n!B]3bI\"+\u0017\rZ3s)\t\ty\u0004E\u00027\u0003\u0003J1!a\u00118\u0005\u0011)f.\u001b;\u0002\u000bA\f'o]3\u0015\u0005\u0005%\u0003\u0007BA&\u00037\u0002b!!\u0014\u0002T\u0005]SBAA(\u0015\r\t\t&W\u0001\u0007m\u0006dW/Z:\n\t\u0005U\u0013q\n\u0002\u0006-\u0006dW/\u001a\t\u0005\u00033\nY\u0006\u0004\u0001\u0005\u0017\u0005u##!A\u0001\u0002\u000b\u0005\u0011q\f\u0002\u0004?\u0012\n\u0014\u0003BA1\u0003O\u00022ANA2\u0013\r\t)g\u000e\u0002\b\u001d>$\b.\u001b8h!\r1\u0014\u0011N\u0005\u0004\u0003W:$aA!os\u0006Q!/Z1e'\u000eDW-\\1\u0015\u0005\u0005E\u0004\u0003BA:\u0003sj!!!\u001e\u000b\u0007\u0005]40\u0001\u0004tG\",W.Y\u0005\u0005\u0003w\n)H\u0001\u0004TG\",W.Y\u0001\u000ee\u0016\fG\rV8lK:$\u0016\u0010]3\u0015\u0005\u0005\u0005\u0005c\u0001\u001c\u0002\u0004&\u0019\u0011QQ\u001c\u0003\u0007%sG/A\u0005sK\u0006$g+\u00197vKR!\u00111RAKa\u0011\ti)!%\u0011\r\u00055\u00131KAH!\u0011\tI&!%\u0005\u0017\u0005MU#!A\u0001\u0002\u000b\u0005\u0011q\f\u0002\u0004?\u0012\u0012\u0004bBAL+\u0001\u0007\u0011\u0011Q\u0001\u0013i>\\WM\u001c+za\u0016<\u0016\u000e\u001e5GY\u0006<7/A\bsK\u0006$7\u000b[8siN#(/\u001b8h)\u0005\t\u0015a\u0005:fC\u0012t\u0015-\\3EK\u000ed\u0017M]1uS>t\u0017!\u0005:fC\u0012t5\u000bR3dY\u0006\u0014\u0018\r^5p]R\t\u00110A\u0005sK\u0006$\u0017I\u001d:bsR\u0011\u0011q\u0015\t\u0005\u0003\u001b\nI+\u0003\u0003\u0002,\u0006=#AC!se\u0006Lh+\u00197vK\u0006Q!/Z1e\u001f\nTWm\u0019;\u0015\u0005\u0005E\u0006\u0003BA'\u0003gKA!!.\u0002P\tYqJ\u00196fGR4\u0016\r\\;f\u000319W\r\u001e)s_\u000e,7o]8s)\u0011\tY,!1\u0011\tY\ni,Q\u0005\u0004\u0003\u007f;$AB(qi&|g\u000eC\u0004\u0002xm\u0001\r!!\u001d\u0002\u0013Q|7.\u001a8UsB,G\u0003BAA\u0003\u000fDq!a&\u001d\u0001\u0004\t\t)\u0001\bsK\u0006$\u0017\t\u001e;sS\n,H/Z:\u0015\u0005\u00055\u0007CBA'\u0003'\ny\rE\u0002{\u0003#L1!a5|\u0005\u001dq\u0015-\\3TKF\fQB]3bI2{7-\u00197OC6,\u0017!\u0004:fC\u0012t\u0015-\\3ta\u0006\u001cW-\u0001\u0006sK\u0006$'l\u001c8f\u0013\u0012$\"!a\b\u0002\u001dI,\u0017\r\u001a.p]\u0016|eMZ:fiR\u0011\u00111\u0007")
public class InMemoryWeaveBinaryParser
implements WeaveBinaryParser {
    private final String name;
    private final SeekableStream inputStream;
    private final EvaluationContext ctx;
    private final DataInputStream input;
    private final ArrayBuffer<Namespace> namespaces;
    private final ArrayBuffer<String> names;
    private final HashMap<Integer, ZoneId> zoneIds;
    private final HashMap<Integer, ZoneOffset> zoneOffsets;
    private final int org$mule$weave$v2$module$dwb$reader$WeaveBinaryParser$$readBufferSize;
    private final byte[] org$mule$weave$v2$module$dwb$reader$WeaveBinaryParser$$readBuffer;

    @Override
    public void verifyMagicWord(DataInputStream dataInputStream) {
        WeaveBinaryParser.verifyMagicWord$(this, dataInputStream);
    }

    @Override
    public void verifyVersion(DataInputStream dataInputStream) {
        WeaveBinaryParser.verifyVersion$(this, dataInputStream);
    }

    @Override
    public boolean verifyIndexPresence(DataInputStream dataInputStream) {
        return WeaveBinaryParser.verifyIndexPresence$(this, dataInputStream);
    }

    @Override
    public byte[] getReadBuffer() {
        return WeaveBinaryParser.getReadBuffer$(this);
    }

    @Override
    public byte[] getReadBuffer(int length) {
        return WeaveBinaryParser.getReadBuffer$(this, length);
    }

    @Override
    public int org$mule$weave$v2$module$dwb$reader$WeaveBinaryParser$$readBufferSize() {
        return this.org$mule$weave$v2$module$dwb$reader$WeaveBinaryParser$$readBufferSize;
    }

    @Override
    public byte[] org$mule$weave$v2$module$dwb$reader$WeaveBinaryParser$$readBuffer() {
        return this.org$mule$weave$v2$module$dwb$reader$WeaveBinaryParser$$readBuffer;
    }

    @Override
    public final void org$mule$weave$v2$module$dwb$reader$WeaveBinaryParser$_setter_$org$mule$weave$v2$module$dwb$reader$WeaveBinaryParser$$readBufferSize_$eq(int x$1) {
        this.org$mule$weave$v2$module$dwb$reader$WeaveBinaryParser$$readBufferSize = x$1;
    }

    @Override
    public final void org$mule$weave$v2$module$dwb$reader$WeaveBinaryParser$_setter_$org$mule$weave$v2$module$dwb$reader$WeaveBinaryParser$$readBuffer_$eq(byte[] x$1) {
        this.org$mule$weave$v2$module$dwb$reader$WeaveBinaryParser$$readBuffer = x$1;
    }

    public String name() {
        return this.name;
    }

    public SeekableStream inputStream() {
        return this.inputStream;
    }

    private DataInputStream input() {
        return this.input;
    }

    private ArrayBuffer<Namespace> namespaces() {
        return this.namespaces;
    }

    private ArrayBuffer<String> names() {
        return this.names;
    }

    private HashMap<Integer, ZoneId> zoneIds() {
        return this.zoneIds;
    }

    private HashMap<Integer, ZoneOffset> zoneOffsets() {
        return this.zoneOffsets;
    }

    public void readHeader() {
        this.verifyMagicWord(this.input());
        this.verifyVersion(this.input());
        this.input().read();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Value<?> parse() {
        void var2_2;
        this.readHeader();
        int nextValueType = this.input().read();
        if (nextValueType == -1) {
            throw new IllegalArgumentException("Input should not be empty");
        }
        Value<?> value = this.readValue(nextValueType);
        return var2_2;
    }

    public Schema readSchema() {
        ArrayBuffer props = new ArrayBuffer();
        int propCount = this.input().readUnsignedShort();
        for (int i = 0; i < propCount; ++i) {
            int nextKeyValueType = this.input().read();
            KeyValue key = (KeyValue)this.readValue(nextKeyValueType);
            StringValue keyStrValue = StringValue$.MODULE$.apply(((QualifiedName)key.evaluate(this.ctx)).name());
            Value<?> value = this.readValue(this.input().read());
            props.$plus$eq((Object)SchemaProperty$.MODULE$.apply((Value)keyStrValue, value));
        }
        return Schema$.MODULE$.apply((Seq)props);
    }

    public int readTokenType() {
        return this.input().read();
    }

    public Value<?> readValue(int tokenTypeWithFlags) {
        BinaryValue binaryValue;
        int tokenType = DwTokenHelper$.MODULE$.getTokenType(tokenTypeWithFlags);
        boolean hasSchema = DwTokenHelper$.MODULE$.hasSchemaProps(tokenTypeWithFlags);
        int n = tokenType;
        if (DwTokenType$.MODULE$.Key() == n) {
            String name = this.readLocalName();
            QualifiedName qName = new QualifiedName(name, (Option)None$.MODULE$);
            binaryValue = KeyValue$.MODULE$.apply(qName, (Option)None$.MODULE$);
        } else if (DwTokenType$.MODULE$.KeyWithNS() == n) {
            String name = this.readLocalName();
            Namespace namespace = this.readNamespace();
            QualifiedName qName = new QualifiedName(name, (Option)new Some((Object)namespace));
            binaryValue = KeyValue$.MODULE$.apply(qName, (Option)None$.MODULE$);
        } else if (DwTokenType$.MODULE$.KeyWithAttr() == n) {
            String name = this.readLocalName();
            QualifiedName qName = new QualifiedName(name, (Option)None$.MODULE$);
            Value<NameSeq> attrs = this.readAttributes();
            binaryValue = KeyValue$.MODULE$.apply(qName, (Option)new Some(attrs));
        } else if (DwTokenType$.MODULE$.KeyWithNSAttr() == n) {
            String name = this.readLocalName();
            Namespace namespace = this.readNamespace();
            QualifiedName qName = new QualifiedName(name, (Option)new Some((Object)namespace));
            Value<NameSeq> attrs = this.readAttributes();
            binaryValue = KeyValue$.MODULE$.apply(qName, (Option)new Some(attrs));
        } else if (DwTokenType$.MODULE$.String8() == n) {
            StringValue stringValue;
            int length = this.input().read();
            String str = BinaryValueRetriever$.MODULE$.readString(this.input(), length, this.getReadBuffer(length));
            if (hasSchema) {
                Schema schema = this.readSchema();
                stringValue = StringValue$.MODULE$.apply(str, (LocationCapable)UnknownLocationCapable$.MODULE$, StringType$.MODULE$.withSchema(schema, this.ctx));
            } else {
                stringValue = StringValue$.MODULE$.apply(str);
            }
            binaryValue = stringValue;
        } else if (DwTokenType$.MODULE$.String32() == n) {
            StringValue stringValue;
            int length = this.input().readInt();
            String str = BinaryValueRetriever$.MODULE$.readString(this.input(), length, this.getReadBuffer(length));
            if (hasSchema) {
                Schema schema = this.readSchema();
                stringValue = StringValue$.MODULE$.apply(str, (LocationCapable)UnknownLocationCapable$.MODULE$, StringType$.MODULE$.withSchema(schema, this.ctx));
            } else {
                stringValue = StringValue$.MODULE$.apply(str);
            }
            binaryValue = stringValue;
        } else if (DwTokenType$.MODULE$.Null() == n) {
            binaryValue = NullValue$.MODULE$;
        } else if (DwTokenType$.MODULE$.True() == n) {
            binaryValue = BooleanValue$.MODULE$.TRUE_BOOL();
        } else if (DwTokenType$.MODULE$.False() == n) {
            binaryValue = BooleanValue$.MODULE$.FALSE_BOOL();
        } else if (DwTokenType$.MODULE$.Int() == n) {
            int number = this.input().readInt();
            binaryValue = NumberValue$.MODULE$.apply(number);
        } else if (DwTokenType$.MODULE$.Long() == n) {
            long number = this.input().readLong();
            binaryValue = NumberValue$.MODULE$.apply(Number$.MODULE$.apply(number));
        } else if (DwTokenType$.MODULE$.BigInt() == n) {
            int length = this.input().readUnsignedShort();
            byte[] buffer = new byte[length];
            this.input().readFully(buffer, 0, length);
            binaryValue = NumberValue$.MODULE$.apply(Number$.MODULE$.apply(package$.MODULE$.BigInt().apply(buffer)));
        } else if (DwTokenType$.MODULE$.Double() == n) {
            double number = this.input().readDouble();
            binaryValue = NumberValue$.MODULE$.apply(Number$.MODULE$.apply(number));
        } else if (DwTokenType$.MODULE$.BigDecimal() == n) {
            String str = BinaryValueRetriever$.MODULE$.readShortString(this.input(), this.getReadBuffer());
            binaryValue = NumberValue$.MODULE$.apply(Number$.MODULE$.apply(package$.MODULE$.BigDecimal().apply(str)));
        } else if (DwTokenType$.MODULE$.ObjectStart() == n) {
            binaryValue = this.readObject();
        } else if (DwTokenType$.MODULE$.ArrayStart() == n) {
            binaryValue = this.readArray();
        } else if (DwTokenType$.MODULE$.Binary() == n) {
            int length = this.input().readInt();
            byte[] buffer = new byte[length];
            this.input().readFully(buffer, 0, length);
            binaryValue = BinaryValue$.MODULE$.apply(buffer, this.ctx);
        } else if (DwTokenType$.MODULE$.DeclareNS() == n) {
            this.readNSDeclaration();
            binaryValue = this.readValue(this.readTokenType());
        } else if (DwTokenType$.MODULE$.DeclareName() == n) {
            this.readNameDeclaration();
            binaryValue = this.readValue(this.readTokenType());
        } else if (DwTokenType$.MODULE$.DateTime() == n) {
            long unixTimestamp = this.input().readLong();
            int nanos = this.input().readInt();
            Instant instant = Instant.ofEpochSecond(unixTimestamp, nanos);
            ZoneId zoneId = this.readZoneId();
            ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(instant, zoneId);
            binaryValue = DateTimeValue$.MODULE$.apply(zonedDateTime);
        } else if (DwTokenType$.MODULE$.LocalDateTime() == n) {
            long unixTimestamp = this.input().readLong();
            int nanos = this.input().readInt();
            binaryValue = LocalDateTimeValue$.MODULE$.apply(LocalDateTime.ofEpochSecond(unixTimestamp, nanos, ZoneOffset.UTC));
        } else if (DwTokenType$.MODULE$.LocalDate() == n) {
            long epochDay = this.input().readLong();
            binaryValue = LocalDateValue$.MODULE$.apply(LocalDate.ofEpochDay(epochDay));
        } else if (DwTokenType$.MODULE$.Time() == n) {
            long nanoOfDay = this.input().readLong();
            LocalTime localTime = LocalTime.ofNanoOfDay(nanoOfDay);
            ZoneOffset zoneOffset = this.readZoneOffset();
            OffsetTime offsetTime = OffsetTime.of(localTime, zoneOffset);
            binaryValue = TimeValue$.MODULE$.apply(offsetTime);
        } else if (DwTokenType$.MODULE$.LocalTime() == n) {
            long nanoOfDay = this.input().readLong();
            LocalTime localTime = LocalTime.ofNanoOfDay(nanoOfDay);
            binaryValue = LocalTimeValue$.MODULE$.apply(localTime);
        } else if (DwTokenType$.MODULE$.TimeZone() == n) {
            ZoneId zoneId = this.readZoneId();
            binaryValue = TimeZoneValue$.MODULE$.apply(zoneId);
        } else if (DwTokenType$.MODULE$.Period() == n) {
            String str = this.input().readUTF();
            binaryValue = PeriodValue$.MODULE$.apply(str, (LocationCapable)UnknownLocationCapable$.MODULE$);
        } else if (DwTokenType$.MODULE$.Regex() == n) {
            String str = this.input().readUTF();
            binaryValue = RegexValue$.MODULE$.apply(str);
        } else if (DwTokenType$.MODULE$.Range() == n) {
            int start = this.input().readInt();
            int end = this.input().readInt();
            binaryValue = RangeValue$.MODULE$.apply(start, end, (LocationCapable)UnknownLocationCapable$.MODULE$);
        } else {
            throw new DWBRuntimeExecutionException(new StringBuilder(24).append("Unexpected value type '").append(DwTokenType$.MODULE$.getNameFor(n)).append("'").toString(), DWBRuntimeExecutionException$.MODULE$.$lessinit$greater$default$2());
        }
        BinaryValue value = binaryValue;
        return value;
    }

    private String readShortString() {
        return BinaryValueRetriever$.MODULE$.readShortString(this.input(), this.getReadBuffer());
    }

    /*
     * WARNING - void declaration
     */
    public String readNameDeclaration() {
        void var1_1;
        String name = this.readShortString();
        this.names().$plus$eq((Object)name);
        return var1_1;
    }

    public Namespace readNSDeclaration() {
        String str = this.readShortString();
        Tuple2 tuple2 = new StringOps(Predef$.MODULE$.augmentString(str)).splitAt(str.indexOf(":"));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String prefix = (String)tuple2._1();
        String uri = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)prefix, (Object)uri);
        Tuple2 tuple23 = tuple22;
        String prefix2 = (String)tuple23._1();
        String uri2 = (String)tuple23._2();
        Namespace ns = new Namespace(prefix2, uri2.substring(1));
        this.namespaces().$plus$eq((Object)ns);
        return ns;
    }

    private ArrayValue readArray() {
        ArrayBuffer values = new ArrayBuffer();
        int nextValueType = this.readTokenType();
        while (nextValueType != DwTokenType$.MODULE$.StructureEnd()) {
            Value<?> value = this.readValue(nextValueType);
            values.$plus$eq(value);
            nextValueType = this.readTokenType();
        }
        return new InMemoryJsonArray(ArraySeq$.MODULE$.apply((Seq)values, true), (Location)UnknownLocation$.MODULE$);
    }

    private ObjectValue readObject() {
        MaterializedObjectValue materializedObjectValue;
        ArrayBuffer kvps = new ArrayBuffer();
        int tokenTypeWithFlags = this.readTokenType();
        while (this.tokenType(tokenTypeWithFlags) != DwTokenType$.MODULE$.StructureEnd()) {
            KeyValue key = (KeyValue)this.readValue(tokenTypeWithFlags);
            Value<?> value = this.readValue(this.readTokenType());
            kvps.$plus$eq((Object)new KeyValuePair((Value)key, value, KeyValuePair$.MODULE$.apply$default$3()));
            tokenTypeWithFlags = this.readTokenType();
        }
        ObjectSeq objectSeq = ObjectSeq$.MODULE$.apply((Seq)kvps, true);
        boolean objectHasSchema = DwTokenHelper$.MODULE$.hasSchemaProps(tokenTypeWithFlags);
        if (objectHasSchema) {
            MaterializedObjectValue materializedObjectValue2;
            Schema schema = this.readSchema();
            Option<String> option = this.getProcessor(schema);
            if (option instanceof Some) {
                Some some = (Some)option;
                String processor = (String)some.value();
                Map<String, IWeaveValue<?>> schemaMap = WeaveValue$.MODULE$.toWeaveValueMap(schema, this.ctx);
                RedefinedObjectSeq redefinedObjectSeq = new RedefinedObjectSeq(objectSeq, processor, schemaMap, (LocationCapable)UnknownLocationCapable$.MODULE$, this.ctx);
                materializedObjectValue2 = new MaterializedObjectValue((ObjectSeq)redefinedObjectSeq, (LocationCapable)UnknownLocationCapable$.MODULE$, ObjectType$.MODULE$.withSchema(schema, this.ctx));
            } else if (None$.MODULE$.equals(option)) {
                materializedObjectValue2 = new MaterializedObjectValue(objectSeq, (LocationCapable)UnknownLocationCapable$.MODULE$, ObjectType$.MODULE$.withSchema(schema, this.ctx));
            } else {
                throw new MatchError(option);
            }
            materializedObjectValue = materializedObjectValue2;
        } else {
            materializedObjectValue = new MaterializedObjectValue(objectSeq, (LocationCapable)UnknownLocationCapable$.MODULE$, MaterializedObjectValue$.MODULE$.$lessinit$greater$default$3());
        }
        return materializedObjectValue;
    }

    private Option<String> getProcessor(Schema schema) {
        return schema.valueOf("processor", this.ctx).map((Function1 & Serializable & scala.Serializable)processor -> (String)StringType$.MODULE$.coerce(processor, $this.ctx).evaluate($this.ctx));
    }

    private int tokenType(int tokenTypeWithFlags) {
        return tokenTypeWithFlags & DwTokenHelper$.MODULE$.TOKEN_TYPE_MASK();
    }

    private Value<NameSeq> readAttributes() {
        ArrayBuffer attrPairs = new ArrayBuffer();
        int attrCount = this.input().readUnsignedShort();
        for (int i = 0; i < attrCount; ++i) {
            int nextValueType = this.readTokenType();
            KeyValue qName = (KeyValue)this.readValue(nextValueType);
            Value<?> value = this.readValue(this.readTokenType());
            attrPairs.$plus$eq((Object)new NameValuePair((Value)qName, value));
        }
        return AttributesValue$.MODULE$.apply((Seq)attrPairs);
    }

    public String readLocalName() {
        int nameIndex = this.input().readUnsignedShort();
        return (String)this.names().apply(nameIndex);
    }

    /*
     * WARNING - void declaration
     */
    private Namespace readNamespace() {
        void var2_2;
        int nsIndex = this.input().readUnsignedShort();
        Namespace namespace = (Namespace)this.namespaces().apply(nsIndex);
        return var2_2;
    }

    private ZoneId readZoneId() {
        ZoneId zoneId;
        int nameIndex = this.input().readUnsignedShort();
        Option zoneIdMaybe = this.zoneIds().get((Object)Predef$.MODULE$.int2Integer(nameIndex));
        Option option = zoneIdMaybe;
        if (option instanceof Some) {
            ZoneId zoneId2;
            Some some = (Some)option;
            zoneId = zoneId2 = (ZoneId)some.value();
        } else if (None$.MODULE$.equals(option)) {
            String nameStr = (String)this.names().apply(nameIndex);
            ZoneId zoneId3 = ZoneId.of(nameStr);
            this.zoneIds().put((Object)Predef$.MODULE$.int2Integer(nameIndex), (Object)zoneId3);
            zoneId = zoneId3;
        } else {
            throw new MatchError((Object)option);
        }
        return zoneId;
    }

    private ZoneOffset readZoneOffset() {
        ZoneOffset zoneOffset;
        int nameIndex = this.input().readUnsignedShort();
        Option zoneOffsetMaybe = this.zoneOffsets().get((Object)Predef$.MODULE$.int2Integer(nameIndex));
        Option option = zoneOffsetMaybe;
        if (option instanceof Some) {
            ZoneOffset zoneId;
            Some some = (Some)option;
            zoneOffset = zoneId = (ZoneOffset)some.value();
        } else if (None$.MODULE$.equals(option)) {
            String nameStr = (String)this.names().apply(nameIndex);
            ZoneOffset zoneOffset2 = ZoneOffset.of(nameStr);
            this.zoneOffsets().put((Object)Predef$.MODULE$.int2Integer(nameIndex), (Object)zoneOffset2);
            zoneOffset = zoneOffset2;
        } else {
            throw new MatchError((Object)option);
        }
        return zoneOffset;
    }

    public InMemoryWeaveBinaryParser(String name, SeekableStream inputStream, EvaluationContext ctx) {
        this.name = name;
        this.inputStream = inputStream;
        this.ctx = ctx;
        WeaveBinaryParser.$init$(this);
        this.input = new DataInputStream(new BufferedInputStream((InputStream)inputStream));
        this.namespaces = new ArrayBuffer(0);
        this.names = new ArrayBuffer();
        this.zoneIds = new HashMap();
        this.zoneOffsets = new HashMap();
    }
}

