package org.mule.weave.v2.module.dwb.reader.indexed

import java.time.Instant
import java.time.ZonedDateTime

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.values.DateTimeValue
import org.mule.weave.v2.module.dwb.BinaryLocation
import org.mule.weave.v2.module.dwb.DwTokenHelper
import org.mule.weave.v2.parser.location.Location

class WeaveBinaryDateTime(token: Array[Long], input: BinaryParserInput) extends DateTimeValue {

  private lazy val offset = DwTokenHelper.getOffset(token)
  private lazy val value: ZonedDateTime = {
    val stream = input.dataInputStream
    input.seekableStream.seek(offset)
    val unixTimestamp = stream.readLong()
    val nanos = stream.readInt()
    val zoneIndex = stream.readUnsignedShort()

    val instant = Instant.ofEpochSecond(unixTimestamp, nanos)
    val zoneId = input.zoneIds.get(zoneIndex)

    ZonedDateTime.ofInstant(instant, zoneId)
  }

  override def evaluate(implicit ctx: EvaluationContext): T = value

  override def location(): Location = new BinaryLocation(offset)
}
