package org.mule.weave.v2.module.dwb
import java.lang.reflect.Field

/**
  * This token is written as 1 byte before the data.
  *
  */
object DwTokenType extends Enumeration {
  type DwTokenType = Int

  val Null: Int = 0
  val ArrayStart: Int = 1
  val StructureEnd: Int = 2
  val ObjectStart: Int = 3
  val Key: Int = 4
  val KeyWithNS: Int = 5
  val KeyWithAttr: Int = 6
  val KeyWithNSAttr: Int = 7
  val String32: Int = 8
  val True: Int = 9
  val False: Int = 10
  val Int: Int = 11
  val Long: Int = 12
  val BigInt: Int = 13
  val Double: Int = 14
  val BigDecimal: Int = 15
  val DateTime: Int = 16
  val LocalDate: Int = 17
  val Period: Int = 18
  val LocalDateTime: Int = 19
  val Time: Int = 20
  val LocalTime: Int = 21
  val TimeZone: Int = 22
  val Binary: Int = 23
  val DeclareNS: Int = 24
  val DeclareName: Int = 25
  val Regex: Int = 26
  val Range: Int = 27
  val String8: Int = 28

  private lazy val idsToNames = {
    val fields: Array[Field] = getClass.getDeclaredFields
    (for (field <- fields if field.getType.isAssignableFrom(Int.getClass)) yield {
      field.getInt(DwTokenType) -> field.getName
    }).toMap
  }

  /**
    * NOTE: This is meant to be used for DEBUGGING ONLY
    */
  def getNameFor(id: Int): String = {
    idsToNames.getOrElse(id, id.toString)
  }

}