package org.mule.weave.v2.module.dwb.reader.indexed

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.values.DWRange
import org.mule.weave.v2.model.values.math.Number
import org.mule.weave.v2.model.values.RangeHelper
import org.mule.weave.v2.model.values.RangeValue
import org.mule.weave.v2.module.dwb.BinaryLocation
import org.mule.weave.v2.module.dwb.DwTokenHelper
import org.mule.weave.v2.parser.location.Location

class WeaveBinaryRange(token: Array[Long], input: BinaryParserInput) extends RangeValue {
  private lazy val offset: Long = DwTokenHelper.getOffset(token)
  private lazy val value: DWRange = {
    val stream = input.dataInputStream
    input.seekableStream.seek(offset)
    val start = stream.readInt()
    val end = stream.readInt()
    RangeHelper.inclusiveRange(Number(start), Number(end))
  }

  override def evaluate(implicit ctx: EvaluationContext): T = value
  override def location(): Location = new BinaryLocation(offset)
}
