package org.mule.weave.v2.module.dwb.reader.indexed

import java.time.temporal.TemporalAmount

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.values.PeriodValue
import org.mule.weave.v2.model.values.coercion.PeriodCoercer
import org.mule.weave.v2.module.dwb.BinaryLocation
import org.mule.weave.v2.module.dwb.DwTokenHelper
import org.mule.weave.v2.module.dwb.reader.exceptions.DWBRuntimeExecutionException
import org.mule.weave.v2.parser.location.Location

class WeaveBinaryPeriod(token: Array[Long], input: BinaryParserInput) extends PeriodValue {
  private lazy val offset: Long = DwTokenHelper.getOffset(token)
  private lazy val value: TemporalAmount = {
    input.seekableStream.seek(offset)
    val length = DwTokenHelper.getValueLength(token).toInt
    val periodStr = BinaryValueRetriever.readString(input.dataInputStream, length)
    try {
      PeriodCoercer.fromString(periodStr)
    } catch {
      case _: Exception => throw new DWBRuntimeExecutionException("Error while parsing period: " + periodStr)
    }

  }

  override def evaluate(implicit ctx: EvaluationContext): T = value
  override def location(): Location = new BinaryLocation(offset)
}
