/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.dwb.reader.memory;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.mule.weave.v2.io.SeekableStream;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.model.capabilities.UnknownLocationCapable$;
import org.mule.weave.v2.model.structure.ArraySeq$;
import org.mule.weave.v2.model.structure.KeyValuePair;
import org.mule.weave.v2.model.structure.KeyValuePair$;
import org.mule.weave.v2.model.structure.NameSeq;
import org.mule.weave.v2.model.structure.NameValuePair;
import org.mule.weave.v2.model.structure.Namespace;
import org.mule.weave.v2.model.structure.ObjectSeq;
import org.mule.weave.v2.model.structure.ObjectSeq$;
import org.mule.weave.v2.model.structure.QualifiedName;
import org.mule.weave.v2.model.structure.schema.Schema;
import org.mule.weave.v2.model.structure.schema.Schema$;
import org.mule.weave.v2.model.structure.schema.SchemaProperty$;
import org.mule.weave.v2.model.types.StringType$;
import org.mule.weave.v2.model.values.ArrayValue;
import org.mule.weave.v2.model.values.AttributesValue$;
import org.mule.weave.v2.model.values.BinaryValue$;
import org.mule.weave.v2.model.values.BooleanValue$;
import org.mule.weave.v2.model.values.DateTimeValue$;
import org.mule.weave.v2.model.values.KeyValue;
import org.mule.weave.v2.model.values.KeyValue$;
import org.mule.weave.v2.model.values.LocalDateTimeValue$;
import org.mule.weave.v2.model.values.LocalDateValue;
import org.mule.weave.v2.model.values.LocalDateValue$;
import org.mule.weave.v2.model.values.LocalTimeValue$;
import org.mule.weave.v2.model.values.MaterializedObjectValue;
import org.mule.weave.v2.model.values.MaterializedObjectValue$;
import org.mule.weave.v2.model.values.NullValue$;
import org.mule.weave.v2.model.values.NumberValue$;
import org.mule.weave.v2.model.values.ObjectValue;
import org.mule.weave.v2.model.values.StringValue;
import org.mule.weave.v2.model.values.StringValue$;
import org.mule.weave.v2.model.values.TimeValue$;
import org.mule.weave.v2.model.values.TimeZoneValue$;
import org.mule.weave.v2.model.values.Value;
import org.mule.weave.v2.module.dwb.DwTokenHelper$;
import org.mule.weave.v2.module.dwb.DwTokenType$;
import org.mule.weave.v2.module.dwb.reader.indexed.BinaryValueRetriever$;
import org.mule.weave.v2.module.dwb.reader.indexed.WeaveBinaryParser;
import org.mule.weave.v2.module.json.reader.memory.InMemoryJsonArray;
import org.mule.weave.v2.parser.location.Location;
import org.mule.weave.v2.parser.location.LocationCapable;
import org.mule.weave.v2.parser.location.UnknownLocation$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.package$;
import scala.reflect.ScalaSignature;
import spire.math.Number$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015g\u0001B\u0010!\u0001EB\u0001B\u0010\u0001\u0003\u0006\u0004%\ta\u0010\u0005\t\u0017\u0002\u0011\t\u0011)A\u0005\u0001\"AA\n\u0001BC\u0002\u0013\u0005Q\n\u0003\u0005U\u0001\t\u0005\t\u0015!\u0003O\u0011!)\u0006A!A!\u0002\u00171\u0006\"\u0002/\u0001\t\u0003i\u0006b\u00023\u0001\u0005\u0004%I!\u001a\u0005\u0007[\u0002\u0001\u000b\u0011\u00024\t\u000f9\u0004!\u0019!C\u0005_\"1a\u0010\u0001Q\u0001\nAD\u0001b \u0001C\u0002\u0013%\u0011\u0011\u0001\u0005\t\u0003\u000b\u0001\u0001\u0015!\u0003\u0002\u0004!I\u0011q\u0001\u0001C\u0002\u0013%\u0011\u0011\u0002\u0005\t\u0003S\u0001\u0001\u0015!\u0003\u0002\f!I\u00111\u0006\u0001C\u0002\u0013%\u0011Q\u0006\u0005\t\u0003o\u0001\u0001\u0015!\u0003\u00020!9\u0011\u0011\b\u0001\u0005\u0002\u0005m\u0002bBA1\u0001\u0011%\u00111\r\u0005\b\u0003c\u0002A\u0011BA:\u0011\u001d\tI\t\u0001C\u0005\u0003\u0017Cq!!$\u0001\t\u0013\tY\tC\u0004\u0002\u0010\u0002!I!!%\t\u000f\u0005M\u0005\u0001\"\u0003\u0002\u0016\"9\u0011Q\u0014\u0001\u0005\n\u0005}\u0005bBAT\u0001\u0011%\u0011\u0011\u0016\u0005\b\u0003[\u0003A\u0011BAX\u0011\u001d\tI\f\u0001C\u0005\u0003\u0017Cq!a/\u0001\t\u0013\t\t\nC\u0004\u0002>\u0002!I!a0\t\u000f\u0005\u0005\u0007\u0001\"\u0003\u0002D\nI\u0012J\\'f[>\u0014\u0018pV3bm\u0016\u0014\u0015N\\1ssB\u000b'o]3s\u0015\t\t#%\u0001\u0004nK6|'/\u001f\u0006\u0003G\u0011\naA]3bI\u0016\u0014(BA\u0013'\u0003\r!wO\u0019\u0006\u0003O!\na!\\8ek2,'BA\u0015+\u0003\t1(G\u0003\u0002,Y\u0005)q/Z1wK*\u0011QFL\u0001\u0005[VdWMC\u00010\u0003\ry'oZ\u0002\u0001'\r\u0001!\u0007\u000f\t\u0003gYj\u0011\u0001\u000e\u0006\u0002k\u0005)1oY1mC&\u0011q\u0007\u000e\u0002\u0007\u0003:L(+\u001a4\u0011\u0005ebT\"\u0001\u001e\u000b\u0005m\u0012\u0013aB5oI\u0016DX\rZ\u0005\u0003{i\u0012\u0011cV3bm\u0016\u0014\u0015N\\1ssB\u000b'o]3s\u0003\u0011q\u0017-\\3\u0016\u0003\u0001\u0003\"!\u0011%\u000f\u0005\t3\u0005CA\"5\u001b\u0005!%BA#1\u0003\u0019a$o\\8u}%\u0011q\tN\u0001\u0007!J,G-\u001a4\n\u0005%S%AB*ue&twM\u0003\u0002Hi\u0005)a.Y7fA\u0005Y\u0011N\u001c9viN#(/Z1n+\u0005q\u0005CA(S\u001b\u0005\u0001&BA))\u0003\tIw.\u0003\u0002T!\nq1+Z3lC\ndWm\u0015;sK\u0006l\u0017\u0001D5oaV$8\u000b\u001e:fC6\u0004\u0013aA2uqB\u0011qKW\u0007\u00021*\u0011\u0011\fK\u0001\u0006[>$W\r\\\u0005\u00037b\u0013\u0011#\u0012<bYV\fG/[8o\u0007>tG/\u001a=u\u0003\u0019a\u0014N\\5u}Q\u0019aLY2\u0015\u0005}\u000b\u0007C\u00011\u0001\u001b\u0005\u0001\u0003\"B+\u0007\u0001\b1\u0006\"\u0002 \u0007\u0001\u0004\u0001\u0005\"\u0002'\u0007\u0001\u0004q\u0015!B5oaV$X#\u00014\u0011\u0005\u001d\\W\"\u00015\u000b\u0005EK'\"\u00016\u0002\t)\fg/Y\u0005\u0003Y\"\u0014q\u0002R1uC&s\u0007/\u001e;TiJ,\u0017-\\\u0001\u0007S:\u0004X\u000f\u001e\u0011\u0002\u00159\fW.Z:qC\u000e,7/F\u0001q!\r\th\u000f_\u0007\u0002e*\u00111\u000f^\u0001\b[V$\u0018M\u00197f\u0015\t)H'\u0001\u0006d_2dWm\u0019;j_:L!a\u001e:\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM\u001d\t\u0003srl\u0011A\u001f\u0006\u0003wb\u000b\u0011b\u001d;sk\u000e$XO]3\n\u0005uT(!\u0003(b[\u0016\u001c\b/Y2f\u0003-q\u0017-\\3ta\u0006\u001cWm\u001d\u0011\u0002\u000b9\fW.Z:\u0016\u0005\u0005\r\u0001cA9w\u0001\u00061a.Y7fg\u0002\nqA_8oK&#7/\u0006\u0002\u0002\fA9\u0011/!\u0004\u0002\u0012\u0005u\u0011bAA\be\n9\u0001*Y:i\u001b\u0006\u0004\b\u0003BA\n\u00033i!!!\u0006\u000b\u0007\u0005]\u0011.\u0001\u0003mC:<\u0017\u0002BA\u000e\u0003+\u0011q!\u00138uK\u001e,'\u000f\u0005\u0003\u0002 \u0005\u0015RBAA\u0011\u0015\r\t\u0019#[\u0001\u0005i&lW-\u0003\u0003\u0002(\u0005\u0005\"A\u0002.p]\u0016LE-\u0001\u0005{_:,\u0017\nZ:!\u0003-QxN\\3PM\u001a\u001cX\r^:\u0016\u0005\u0005=\u0002cB9\u0002\u000e\u0005E\u0011\u0011\u0007\t\u0005\u0003?\t\u0019$\u0003\u0003\u00026\u0005\u0005\"A\u0003.p]\u0016|eMZ:fi\u0006a!p\u001c8f\u001f\u001a47/\u001a;tA\u0005)\u0001/\u0019:tKR\u0011\u0011Q\b\u0019\u0005\u0003\u007f\ty\u0005\u0005\u0004\u0002B\u0005\u001d\u00131J\u0007\u0003\u0003\u0007R1!!\u0012Y\u0003\u00191\u0018\r\\;fg&!\u0011\u0011JA\"\u0005\u00151\u0016\r\\;f!\u0011\ti%a\u0014\r\u0001\u0011Y\u0011\u0011K\t\u0002\u0002\u0003\u0005)\u0011AA*\u0005\ryF%M\t\u0005\u0003+\nY\u0006E\u00024\u0003/J1!!\u00175\u0005\u001dqu\u000e\u001e5j]\u001e\u00042aMA/\u0013\r\ty\u0006\u000e\u0002\u0004\u0003:L\u0018A\u0003:fC\u0012\u001c6\r[3nCR\u0011\u0011Q\r\t\u0005\u0003O\ni'\u0004\u0002\u0002j)\u0019\u00111\u000e>\u0002\rM\u001c\u0007.Z7b\u0013\u0011\ty'!\u001b\u0003\rM\u001b\u0007.Z7b\u0003%\u0011X-\u00193WC2,X\r\u0006\u0003\u0002v\u0005}\u0004\u0007BA<\u0003w\u0002b!!\u0011\u0002H\u0005e\u0004\u0003BA'\u0003w\"1\"! \u0014\u0003\u0003\u0005\tQ!\u0001\u0002T\t\u0019q\f\n\u001a\t\u000f\u0005\u00055\u00031\u0001\u0002\u0004\u0006\u0011Bo\\6f]RK\b/Z,ji\"4E.Y4t!\r\u0019\u0014QQ\u0005\u0004\u0003\u000f#$aA%oi\u0006y!/Z1e'\"|'\u000f^*ue&tw\rF\u0001A\u0003M\u0011X-\u00193OC6,G)Z2mCJ\fG/[8o\u0003E\u0011X-\u00193O'\u0012+7\r\\1sCRLwN\u001c\u000b\u0002q\u0006I!/Z1e\u0003J\u0014\u0018-\u001f\u000b\u0003\u0003/\u0003B!!\u0011\u0002\u001a&!\u00111TA\"\u0005)\t%O]1z-\u0006dW/Z\u0001\u000be\u0016\fGm\u00142kK\u000e$HCAAQ!\u0011\t\t%a)\n\t\u0005\u0015\u00161\t\u0002\f\u001f\nTWm\u0019;WC2,X-A\u0005u_.,g\u000eV=qKR!\u00111QAV\u0011\u001d\t\t)\u0007a\u0001\u0003\u0007\u000baB]3bI\u0006#HO]5ckR,7\u000f\u0006\u0002\u00022B1\u0011\u0011IA$\u0003g\u00032!_A[\u0013\r\t9L\u001f\u0002\b\u001d\u0006lWmU3r\u00035\u0011X-\u00193M_\u000e\fGNT1nK\u0006i!/Z1e\u001d\u0006lWm\u001d9bG\u0016\f!B]3bIj{g.Z%e)\t\ti\"\u0001\bsK\u0006$'l\u001c8f\u001f\u001a47/\u001a;\u0015\u0005\u0005E\u0002")
public class InMemoryWeaveBinaryParser
implements WeaveBinaryParser {
    private final String name;
    private final SeekableStream inputStream;
    private final EvaluationContext ctx;
    private final DataInputStream input;
    private final ArrayBuffer<Namespace> namespaces;
    private final ArrayBuffer<String> names;
    private final HashMap<Integer, ZoneId> zoneIds;
    private final HashMap<Integer, ZoneOffset> zoneOffsets;

    @Override
    public void verifyMagicWord(DataInputStream dataInputStream) {
        WeaveBinaryParser.verifyMagicWord$(this, dataInputStream);
    }

    @Override
    public void verifyVersion(DataInputStream dataInputStream) {
        WeaveBinaryParser.verifyVersion$(this, dataInputStream);
    }

    public String name() {
        return this.name;
    }

    public SeekableStream inputStream() {
        return this.inputStream;
    }

    private DataInputStream input() {
        return this.input;
    }

    private ArrayBuffer<Namespace> namespaces() {
        return this.namespaces;
    }

    private ArrayBuffer<String> names() {
        return this.names;
    }

    private HashMap<Integer, ZoneId> zoneIds() {
        return this.zoneIds;
    }

    private HashMap<Integer, ZoneOffset> zoneOffsets() {
        return this.zoneOffsets;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Value<?> parse() {
        void var2_2;
        this.verifyMagicWord(this.input());
        this.verifyVersion(this.input());
        this.input().read();
        int nextValueType = this.input().read();
        if (nextValueType == -1) {
            throw new IllegalArgumentException("Input should not be empty");
        }
        Value<?> value = this.readValue(nextValueType);
        return var2_2;
    }

    private Schema readSchema() {
        ArrayBuffer props = new ArrayBuffer();
        int propCount = this.input().readUnsignedShort();
        for (int i = 0; i < propCount; ++i) {
            int nextKeyValueType = this.input().read();
            KeyValue key = (KeyValue)this.readValue(nextKeyValueType);
            StringValue keyStrValue = StringValue$.MODULE$.apply(((QualifiedName)key.evaluate(this.ctx)).name());
            Value<?> value = this.readValue(this.input().read());
            props.$plus$eq((Object)SchemaProperty$.MODULE$.apply((Value)keyStrValue, value));
        }
        return Schema$.MODULE$.apply((Seq)props);
    }

    private Value<?> readValue(int tokenTypeWithFlags) {
        LocalDateValue localDateValue;
        int tokenType = tokenTypeWithFlags & DwTokenHelper$.MODULE$.TOKEN_TYPE_MASK();
        boolean hasSchema = DwTokenHelper$.MODULE$.hasSchemaProps(tokenTypeWithFlags);
        int n = tokenType;
        if (DwTokenType$.MODULE$.Key() == n) {
            String name = this.readLocalName();
            QualifiedName qName = new QualifiedName(name, (Option)None$.MODULE$);
            localDateValue = KeyValue$.MODULE$.apply(qName, (Option)None$.MODULE$);
        } else if (DwTokenType$.MODULE$.KeyWithNS() == n) {
            String name = this.readLocalName();
            Namespace namespace = this.readNamespace();
            QualifiedName qName = new QualifiedName(name, (Option)new Some((Object)namespace));
            localDateValue = KeyValue$.MODULE$.apply(qName, (Option)None$.MODULE$);
        } else if (DwTokenType$.MODULE$.KeyWithAttr() == n) {
            String name = this.readLocalName();
            QualifiedName qName = new QualifiedName(name, (Option)None$.MODULE$);
            Value<NameSeq> attrs = this.readAttributes();
            localDateValue = KeyValue$.MODULE$.apply(qName, (Option)new Some(attrs));
        } else if (DwTokenType$.MODULE$.KeyWithNSAttr() == n) {
            String name = this.readLocalName();
            Namespace namespace = this.readNamespace();
            QualifiedName qName = new QualifiedName(name, (Option)new Some((Object)namespace));
            Value<NameSeq> attrs = this.readAttributes();
            localDateValue = KeyValue$.MODULE$.apply(qName, (Option)new Some(attrs));
        } else if (DwTokenType$.MODULE$.String8() == n) {
            StringValue stringValue;
            int length = this.input().read();
            String str = BinaryValueRetriever$.MODULE$.readString(this.input(), length);
            if (hasSchema) {
                Schema schema = this.readSchema();
                stringValue = StringValue$.MODULE$.apply(str, (LocationCapable)UnknownLocationCapable$.MODULE$, StringType$.MODULE$.withSchema(schema));
            } else {
                stringValue = StringValue$.MODULE$.apply(str);
            }
            localDateValue = stringValue;
        } else if (DwTokenType$.MODULE$.String32() == n) {
            StringValue stringValue;
            int length = this.input().readInt();
            String str = BinaryValueRetriever$.MODULE$.readString(this.input(), length);
            if (hasSchema) {
                Schema schema = this.readSchema();
                stringValue = StringValue$.MODULE$.apply(str, (LocationCapable)UnknownLocationCapable$.MODULE$, StringType$.MODULE$.withSchema(schema));
            } else {
                stringValue = StringValue$.MODULE$.apply(str);
            }
            localDateValue = stringValue;
        } else if (DwTokenType$.MODULE$.Null() == n) {
            localDateValue = NullValue$.MODULE$;
        } else if (DwTokenType$.MODULE$.True() == n) {
            localDateValue = BooleanValue$.MODULE$.TRUE_BOOL();
        } else if (DwTokenType$.MODULE$.False() == n) {
            localDateValue = BooleanValue$.MODULE$.FALSE_BOOL();
        } else if (DwTokenType$.MODULE$.Int() == n) {
            int number = this.input().readInt();
            localDateValue = NumberValue$.MODULE$.apply(Number$.MODULE$.apply(number));
        } else if (DwTokenType$.MODULE$.Long() == n) {
            long number = this.input().readLong();
            localDateValue = NumberValue$.MODULE$.apply(Number$.MODULE$.apply(number));
        } else if (DwTokenType$.MODULE$.BigInt() == n) {
            int length = this.input().readUnsignedShort();
            byte[] buffer = new byte[length];
            this.input().readFully(buffer, 0, length);
            localDateValue = NumberValue$.MODULE$.apply(Number$.MODULE$.apply(package$.MODULE$.BigInt().apply(buffer)));
        } else if (DwTokenType$.MODULE$.Double() == n) {
            double number = this.input().readDouble();
            localDateValue = NumberValue$.MODULE$.apply(Number$.MODULE$.apply(number));
        } else if (DwTokenType$.MODULE$.BigDecimal() == n) {
            String str = BinaryValueRetriever$.MODULE$.readShortString(this.input());
            localDateValue = NumberValue$.MODULE$.apply(Number$.MODULE$.apply(package$.MODULE$.BigDecimal().apply(str)));
        } else if (DwTokenType$.MODULE$.ObjectStart() == n) {
            localDateValue = this.readObject();
        } else if (DwTokenType$.MODULE$.ArrayStart() == n) {
            localDateValue = this.readArray();
        } else if (DwTokenType$.MODULE$.Binary() == n) {
            int length = this.input().readInt();
            byte[] buffer = new byte[length];
            this.input().readFully(buffer, 0, length);
            localDateValue = BinaryValue$.MODULE$.apply(buffer, this.ctx);
        } else if (DwTokenType$.MODULE$.DeclareNS() == n) {
            this.readNSDeclaration();
            localDateValue = this.readValue(this.input().read());
        } else if (DwTokenType$.MODULE$.DeclareName() == n) {
            this.readNameDeclaration();
            localDateValue = this.readValue(this.input().read());
        } else if (DwTokenType$.MODULE$.DateTime() == n) {
            long unixTimestamp = this.input().readLong();
            int nanos = this.input().readInt();
            Instant instant = Instant.ofEpochSecond(unixTimestamp, nanos);
            ZoneId zoneId = this.readZoneId();
            ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(instant, zoneId);
            localDateValue = DateTimeValue$.MODULE$.apply(zonedDateTime);
        } else if (DwTokenType$.MODULE$.LocalDateTime() == n) {
            long unixTimestamp = this.input().readLong();
            int nanos = this.input().readInt();
            localDateValue = LocalDateTimeValue$.MODULE$.apply(LocalDateTime.ofEpochSecond(unixTimestamp, nanos, ZoneOffset.UTC));
        } else if (DwTokenType$.MODULE$.LocalDate() == n) {
            long epochDay = this.input().readLong();
            localDateValue = LocalDateValue$.MODULE$.apply(LocalDate.ofEpochDay(epochDay));
        } else if (DwTokenType$.MODULE$.Time() == n) {
            long nanoOfDay = this.input().readLong();
            LocalTime localTime = LocalTime.ofNanoOfDay(nanoOfDay);
            ZoneOffset zoneOffset = this.readZoneOffset();
            OffsetTime offsetTime = OffsetTime.of(localTime, zoneOffset);
            localDateValue = TimeValue$.MODULE$.apply(offsetTime);
        } else if (DwTokenType$.MODULE$.LocalTime() == n) {
            long nanoOfDay = this.input().readLong();
            LocalTime localTime = LocalTime.ofNanoOfDay(nanoOfDay);
            localDateValue = LocalTimeValue$.MODULE$.apply(localTime);
        } else if (DwTokenType$.MODULE$.TimeZone() == n) {
            ZoneId zoneId = this.readZoneId();
            localDateValue = TimeZoneValue$.MODULE$.apply(zoneId);
        } else {
            if (DwTokenType$.MODULE$.Period() == n) {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }
            if (DwTokenType$.MODULE$.Range() == n) {
                String str = this.input().readUTF();
                localDateValue = StringValue$.MODULE$.apply(str);
            } else {
                throw new RuntimeException(new StringBuilder(23).append("Unexpected value type: ").append(DwTokenType$.MODULE$.getNameFor(n)).toString());
            }
        }
        LocalDateValue value = localDateValue;
        return value;
    }

    private String readShortString() {
        return BinaryValueRetriever$.MODULE$.readShortString(this.input());
    }

    /*
     * WARNING - void declaration
     */
    private String readNameDeclaration() {
        void var1_1;
        String name = this.readShortString();
        this.names().$plus$eq((Object)name);
        return var1_1;
    }

    private Namespace readNSDeclaration() {
        String str = this.readShortString();
        Tuple2 tuple2 = new StringOps(Predef$.MODULE$.augmentString(str)).splitAt(str.indexOf(":"));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String prefix = (String)tuple2._1();
        String uri = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)prefix, (Object)uri);
        Tuple2 tuple23 = tuple22;
        String prefix2 = (String)tuple23._1();
        String uri2 = (String)tuple23._2();
        Namespace ns = new Namespace(prefix2, uri2.substring(1));
        this.namespaces().$plus$eq((Object)ns);
        return ns;
    }

    private ArrayValue readArray() {
        ArrayBuffer values = new ArrayBuffer();
        int nextValueType = this.input().read();
        while (nextValueType != DwTokenType$.MODULE$.StructureEnd()) {
            Value<?> value = this.readValue(nextValueType);
            values.$plus$eq(value);
            nextValueType = this.input().read();
        }
        return new InMemoryJsonArray(ArraySeq$.MODULE$.apply((Seq)values, true), (Location)UnknownLocation$.MODULE$);
    }

    private ObjectValue readObject() {
        ArrayBuffer kvps = new ArrayBuffer();
        int tokenTypeWithFlags = this.input().read();
        while (this.tokenType(tokenTypeWithFlags) != DwTokenType$.MODULE$.StructureEnd()) {
            KeyValue key = (KeyValue)this.readValue(tokenTypeWithFlags);
            Value<?> value = this.readValue(this.input().read());
            kvps.$plus$eq((Object)new KeyValuePair((Value)key, value, KeyValuePair$.MODULE$.apply$default$3()));
            tokenTypeWithFlags = this.input().read();
        }
        ObjectSeq objectSeq = ObjectSeq$.MODULE$.apply((Seq)kvps, true);
        boolean objectHasSchema = DwTokenHelper$.MODULE$.hasSchemaProps(tokenTypeWithFlags);
        if (!objectHasSchema) {
            throw Predef$.MODULE$.$qmark$qmark$qmark();
        }
        return new MaterializedObjectValue(objectSeq, (LocationCapable)UnknownLocationCapable$.MODULE$, MaterializedObjectValue$.MODULE$.$lessinit$greater$default$3());
    }

    private int tokenType(int tokenTypeWithFlags) {
        return tokenTypeWithFlags & DwTokenHelper$.MODULE$.TOKEN_TYPE_MASK();
    }

    private Value<NameSeq> readAttributes() {
        ArrayBuffer attrPairs = new ArrayBuffer();
        int attrCount = this.input().readUnsignedShort();
        for (int i = 0; i < attrCount; ++i) {
            int nextValueType = this.input().read();
            KeyValue qName = (KeyValue)this.readValue(nextValueType);
            Value<?> value = this.readValue(this.input().read());
            attrPairs.$plus$eq((Object)new NameValuePair((Value)qName, value));
        }
        return AttributesValue$.MODULE$.apply((Seq)attrPairs);
    }

    private String readLocalName() {
        int nameIndex = this.input().readUnsignedShort();
        return (String)this.names().apply(nameIndex);
    }

    /*
     * WARNING - void declaration
     */
    private Namespace readNamespace() {
        void var2_2;
        int nsIndex = this.input().readUnsignedShort();
        Namespace namespace = (Namespace)this.namespaces().apply(nsIndex);
        return var2_2;
    }

    private ZoneId readZoneId() {
        ZoneId zoneId;
        int nameIndex = this.input().readUnsignedShort();
        Option zoneIdMaybe = this.zoneIds().get((Object)Predef$.MODULE$.int2Integer(nameIndex));
        Option option = zoneIdMaybe;
        if (option instanceof Some) {
            ZoneId zoneId2;
            Some some = (Some)option;
            zoneId = zoneId2 = (ZoneId)some.value();
        } else if (None$.MODULE$.equals(option)) {
            String nameStr = (String)this.names().apply(nameIndex);
            ZoneId zoneId3 = ZoneId.of(nameStr);
            this.zoneIds().put((Object)Predef$.MODULE$.int2Integer(nameIndex), (Object)zoneId3);
            zoneId = zoneId3;
        } else {
            throw new MatchError((Object)option);
        }
        return zoneId;
    }

    private ZoneOffset readZoneOffset() {
        ZoneOffset zoneOffset;
        int nameIndex = this.input().readUnsignedShort();
        Option zoneOffsetMaybe = this.zoneOffsets().get((Object)Predef$.MODULE$.int2Integer(nameIndex));
        Option option = zoneOffsetMaybe;
        if (option instanceof Some) {
            ZoneOffset zoneId;
            Some some = (Some)option;
            zoneOffset = zoneId = (ZoneOffset)some.value();
        } else if (None$.MODULE$.equals(option)) {
            String nameStr = (String)this.names().apply(nameIndex);
            ZoneOffset zoneOffset2 = ZoneOffset.of(nameStr);
            this.zoneOffsets().put((Object)Predef$.MODULE$.int2Integer(nameIndex), (Object)zoneOffset2);
            zoneOffset = zoneOffset2;
        } else {
            throw new MatchError((Object)option);
        }
        return zoneOffset;
    }

    public InMemoryWeaveBinaryParser(String name, SeekableStream inputStream, EvaluationContext ctx) {
        this.name = name;
        this.inputStream = inputStream;
        this.ctx = ctx;
        WeaveBinaryParser.$init$(this);
        this.input = new DataInputStream(new BufferedInputStream((InputStream)inputStream));
        this.namespaces = new ArrayBuffer(0);
        this.names = new ArrayBuffer();
        this.zoneIds = new HashMap();
        this.zoneOffsets = new HashMap();
    }
}

