/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.excel;

import java.io.OutputStream;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.model.structure.ArraySeq;
import org.mule.weave.v2.model.structure.KeyValuePair;
import org.mule.weave.v2.model.structure.ObjectSeq;
import org.mule.weave.v2.model.structure.QualifiedName;
import org.mule.weave.v2.model.types.ArrayType$;
import org.mule.weave.v2.model.types.BooleanType$;
import org.mule.weave.v2.model.types.DateTimeType$;
import org.mule.weave.v2.model.types.KeyType$;
import org.mule.weave.v2.model.types.LocalDateTimeType$;
import org.mule.weave.v2.model.types.LocalDateType$;
import org.mule.weave.v2.model.types.NumberType$;
import org.mule.weave.v2.model.types.ObjectType$;
import org.mule.weave.v2.model.types.StringType$;
import org.mule.weave.v2.model.types.TimeType$;
import org.mule.weave.v2.model.values.Value;
import org.mule.weave.v2.module.ConfigurableReaderWriter;
import org.mule.weave.v2.module.excel.ExcelSettings;
import org.mule.weave.v2.module.pojo.writer.converter.DataConverter;
import org.mule.weave.v2.module.pojo.writer.converter.DataConverter$;
import org.mule.weave.v2.module.pojo.writer.converter.JavaDataConverter;
import org.mule.weave.v2.module.writer.Writer;
import org.mule.weave.v2.parser.location.Location;
import org.mule.weave.v2.parser.location.LocationCapable;
import scala.Function1;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import spire.math.Number;

@ScalaSignature(bytes="\u0006\u0001\u0005=e\u0001B\u0001\u0003\u0001=\u00111\"\u0012=dK2<&/\u001b;fe*\u00111\u0001B\u0001\u0006Kb\u001cW\r\u001c\u0006\u0003\u000b\u0019\ta!\\8ek2,'BA\u0004\t\u0003\t1(G\u0003\u0002\n\u0015\u0005)q/Z1wK*\u00111\u0002D\u0001\u0005[VdWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\r\u0001\u0001C\u0006\t\u0003#Qi\u0011A\u0005\u0006\u0002'\u0005)1oY1mC&\u0011QC\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005]QR\"\u0001\r\u000b\u0005e!\u0011AB<sSR,'/\u0003\u0002\u001c1\t1qK]5uKJD\u0001\"\b\u0001\u0003\u0002\u0003\u0006IAH\u0001\u0003_N\u0004\"a\b\u0013\u000e\u0003\u0001R!!\t\u0012\u0002\u0005%|'\"A\u0012\u0002\t)\fg/Y\u0005\u0003K\u0001\u0012AbT;uaV$8\u000b\u001e:fC6DQa\n\u0001\u0005\u0002!\na\u0001P5oSRtDCA\u0015,!\tQ\u0003!D\u0001\u0003\u0011\u0015ib\u00051\u0001\u001f\u0011\u001di\u0003A1A\u0005B9\n\u0001b]3ui&twm]\u000b\u0002_A\u0011!\u0006M\u0005\u0003c\t\u0011Q\"\u0012=dK2\u001cV\r\u001e;j]\u001e\u001c\bBB\u001a\u0001A\u0003%q&A\u0005tKR$\u0018N\\4tA!AQ\u0007\u0001EC\u0002\u0013%a'\u0001\u0002xEV\tq\u0007\u0005\u00029\u00036\t\u0011H\u0003\u0002;w\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003yu\nA\u0001_:tM*\u0011ahP\u0001\u0004a>L'B\u0001!\r\u0003\u0019\t\u0007/Y2iK&\u0011!)\u000f\u0002\u000e'b\u001b6KR,pe.\u0014wn\\6\t\u000b\u0011\u0003A\u0011I#\u0002\rI,7/\u001e7u+\u00051\u0005CA\tH\u0013\tA%CA\u0002B]fDQA\u0013\u0001\u0005B-\u000bA\u0002Z8Xe&$XMV1mk\u0016$\"\u0001\u0014-\u0015\u00055\u0003\u0006CA\tO\u0013\ty%C\u0001\u0003V]&$\b\"B)J\u0001\b\u0011\u0016aA2uqB\u00111KV\u0007\u0002)*\u0011QKB\u0001\u0006[>$W\r\\\u0005\u0003/R\u0013\u0011#\u0012<bYV\fG/[8o\u0007>tG/\u001a=u\u0011\u0015I\u0016\n1\u0001[\u0003\u00151\u0018\r\\;fa\tY6\rE\u0002]?\u0006l\u0011!\u0018\u0006\u0003=R\u000baA^1mk\u0016\u001c\u0018B\u00011^\u0005\u00151\u0016\r\\;f!\t\u00117\r\u0004\u0001\u0005\u0013\u0011D\u0016\u0011!A\u0001\u0006\u0003)'aA0%cE\u0011aM\u0012\t\u0003#\u001dL!\u0001\u001b\n\u0003\u000f9{G\u000f[5oO\")!\u000e\u0001C\u0001W\u0006QqO]5uKNCW-\u001a;\u0015\u00071t7\u0010\u0006\u0002N[\")\u0011+\u001ba\u0002%\")q.\u001ba\u0001a\u0006I1\u000f[3fi:\u000bW.\u001a\t\u0003cbt!A\u001d<\u0011\u0005M\u0014R\"\u0001;\u000b\u0005Ut\u0011A\u0002\u001fs_>$h(\u0003\u0002x%\u00051\u0001K]3eK\u001aL!!\u001f>\u0003\rM#(/\u001b8h\u0015\t9(\u0003C\u0003}S\u0002\u0007Q0\u0001\u0007tQ\u0016,GoQ8oi\u0016tG\u000fE\u0003\u007f\u0003\u000f\tiAD\u0002\u0000\u0003\u0007q1a]A\u0001\u0013\u0005\u0019\u0012bAA\u0003%\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u0005\u0003\u0017\u0011\u0001\"\u0013;fe\u0006$xN\u001d\u0006\u0004\u0003\u000b\u0011\u0002\u0007BA\b\u0003'\u0001B\u0001X0\u0002\u0012A\u0019!-a\u0005\u0005\u0015\u0005U10!A\u0001\u0002\u000b\u0005QMA\u0002`IIBq!!\u0007\u0001\t\u0003\tY\"A\be_^\u0013\u0018\u000e^3GSJ\u001cHOU8x)!\ti\"!\t\u0002,\u0005mBcA'\u0002 !1\u0011+a\u0006A\u0004IC\u0001\"a\t\u0002\u0018\u0001\u0007\u0011QE\u0001\u0006g\",W\r\u001e\t\u0004q\u0005\u001d\u0012bAA\u0015s\tQ1\u000bW*T\rNCW-\u001a;\t\u0011\u00055\u0012q\u0003a\u0001\u0003_\t\u0001B]8x-\u0006dW/\u001a\t\u0005\u0003c\t9$\u0004\u0002\u00024)\u0019\u0011Q\u0007+\u0002\u0013M$(/^2ukJ,\u0017\u0002BA\u001d\u0003g\u0011\u0011b\u00142kK\u000e$8+Z9\t\u0011\u0005u\u0012q\u0003a\u0001\u0003\u007f\taA]8x\u001dVl\u0007cA\t\u0002B%\u0019\u00111\t\n\u0003\u0007%sG\u000fC\u0004\u0002H\u0001!\t!!\u0013\u0002\u0015\u0011|wK]5uKJ{w\u000f\u0006\u0004\u0002L\u0005=\u0013\u0011\f\u000b\u0004\u001b\u00065\u0003BB)\u0002F\u0001\u000f!\u000b\u0003\u0005\u0002R\u0005\u0015\u0003\u0019AA*\u0003\r\u0011xn\u001e\t\u0004q\u0005U\u0013bAA,s\tA1\u000bW*T\rJ{w\u000f\u0003\u0005\u0002.\u0005\u0015\u0003\u0019AA\u0018\u0011\u001d\ti\u0006\u0001C\u0001\u0003?\n\u0011b\u001e:ji\u0016\u001cU\r\u001c7\u0015\r\u0005\u0005\u0014QMA8)\ri\u00151\r\u0005\u0007#\u0006m\u00039\u0001*\t\u0011\u0005\u001d\u00141\fa\u0001\u0003S\nAaY3mYB\u0019\u0001(a\u001b\n\u0007\u00055\u0014HA\u0005T1N\u001bfiQ3mY\"A\u0011\u0011OA.\u0001\u0004\t\u0019(A\u0005dK2dg+\u00197vKB\"\u0011QOA=!\u0011av,a\u001e\u0011\u0007\t\fI\bB\u0006\u0002|\u0005=\u0014\u0011!A\u0001\u0006\u0003)'aA0%g!9\u0011q\u0010\u0001\u0005\u0002\u0005\u0005\u0015!E:fi\u000e+G\u000e\u001c#bi\u00064uN]7biR)Q*a!\u0002\u0006\"A\u0011qMA?\u0001\u0004\tI\u0007C\u0004\u0002\b\u0006u\u0004\u0019\u00019\u0002\r\u0019|'/\\1u\u0011\u001d\tY\t\u0001C!\u0003\u001b\u000bQa\u00197pg\u0016$\u0012!\u0014")
public class ExcelWriter
implements Writer {
    private SXSSFWorkbook wb;
    private final OutputStream os;
    private final ExcelSettings settings;
    private volatile boolean bitmap$0;

    public void startDocument(LocationCapable location) {
        Writer.startDocument$((Writer)this, (LocationCapable)location);
    }

    public void defineNamespace(LocationCapable location, String prefix, String uri) {
        Writer.defineNamespace$((Writer)this, (LocationCapable)location, (String)prefix, (String)uri);
    }

    public void writeValue(Value<?> value, EvaluationContext ctx) {
        Writer.writeValue$((Writer)this, value, (EvaluationContext)ctx);
    }

    public String getName() {
        return Writer.getName$((Writer)this);
    }

    public void endDocument(LocationCapable location) {
        Writer.endDocument$((Writer)this, (LocationCapable)location);
    }

    public void flush() {
        Writer.flush$((Writer)this);
    }

    public void setOption(Location location, String optionName, Object value) {
        ConfigurableReaderWriter.setOption$((ConfigurableReaderWriter)this, (Location)location, (String)optionName, (Object)value);
    }

    public ExcelSettings settings() {
        return this.settings;
    }

    /*
     * WARNING - void declaration
     */
    private SXSSFWorkbook wb$lzycompute() {
        ExcelWriter excelWriter = this;
        synchronized (excelWriter) {
            if (!this.bitmap$0) {
                void var2_2;
                SXSSFWorkbook workbook = new SXSSFWorkbook(1000);
                workbook.setCompressTempFiles(true);
                this.wb = var2_2;
                this.bitmap$0 = true;
            }
        }
        return this.wb;
    }

    private SXSSFWorkbook wb() {
        return !this.bitmap$0 ? this.wb$lzycompute() : this.wb;
    }

    public Object result() {
        return this.os;
    }

    public void doWriteValue(Value<?> value, EvaluationContext ctx) {
        Iterator objectSeq = ((ObjectSeq)ObjectType$.MODULE$.coerce(value, ctx).evaluate(ctx)).toIterator(ctx);
        objectSeq.foreach((Function1 & Serializable & scala.Serializable)keyValuePair -> {
            ExcelWriter.$anonfun$doWriteValue$1(this, ctx, keyValuePair);
            return BoxedUnit.UNIT;
        });
        this.wb().write(this.os);
    }

    public void writeSheet(String sheetName, Iterator<Value<?>> sheetContent, EvaluationContext ctx) {
        SXSSFSheet sheet = this.wb().createSheet(sheetName);
        int rowNum = this.settings().headerRowNum();
        if (this.settings().header() && sheetContent.hasNext()) {
            ObjectSeq rowObjectSeq = (ObjectSeq)ObjectType$.MODULE$.coerce((Value)sheetContent.next(), ctx).evaluate(ctx);
            this.doWriteFirstRow(sheet, rowObjectSeq, rowNum, ctx);
            rowNum += 2;
        }
        while (sheetContent.hasNext()) {
            SXSSFRow row = sheet.createRow(rowNum);
            ObjectSeq rowObjectSeq = (ObjectSeq)ObjectType$.MODULE$.coerce((Value)sheetContent.next(), ctx).evaluate(ctx);
            this.doWriteRow(row, rowObjectSeq, ctx);
            ++rowNum;
        }
    }

    public void doWriteFirstRow(SXSSFSheet sheet, ObjectSeq rowValue, int rowNum, EvaluationContext ctx) {
        SXSSFRow row0 = sheet.createRow(rowNum);
        SXSSFRow row1 = sheet.createRow(rowNum + 1);
        int colNumber = this.settings().headerColNum();
        Iterator keyValuePairs = rowValue.toIterator(ctx);
        while (keyValuePairs.hasNext()) {
            KeyValuePair keyValuePair = (KeyValuePair)keyValuePairs.next();
            SXSSFCell headerCell = row0.createCell(colNumber);
            String headerString = ((QualifiedName)KeyType$.MODULE$.coerce(keyValuePair._1(), ctx).evaluate(ctx)).name();
            headerCell.setCellValue(headerString);
            SXSSFCell cell = row1.createCell(colNumber);
            this.writeCell(cell, keyValuePair._2(), ctx);
            ++colNumber;
        }
    }

    public void doWriteRow(SXSSFRow row, ObjectSeq rowValue, EvaluationContext ctx) {
        int colNumber = this.settings().headerColNum();
        Iterator keyValuePairs = rowValue.toIterator(ctx);
        while (keyValuePairs.hasNext()) {
            SXSSFCell cell = row.createCell(colNumber);
            Value cellValue = ((KeyValuePair)keyValuePairs.next())._2();
            this.writeCell(cell, cellValue, ctx);
            ++colNumber;
        }
    }

    public void writeCell(SXSSFCell cell, Value<?> cellValue, EvaluationContext ctx) {
        Value<?> value = cellValue;
        if (StringType$.MODULE$.accepts(value, ctx)) {
            String cellStr = (String)StringType$.MODULE$.coerce(value, ctx).evaluate(ctx);
            cell.setCellValue(cellStr);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (BooleanType$.MODULE$.accepts(value, ctx)) {
            boolean booleanValue = BoxesRunTime.unboxToBoolean((Object)BooleanType$.MODULE$.coerce(value, ctx).evaluate(ctx));
            cell.setCellValue(booleanValue);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (NumberType$.MODULE$.accepts(value, ctx)) {
            Number cellNumber = (Number)NumberType$.MODULE$.coerce(value, ctx).evaluate(ctx);
            cell.setCellValue(cellNumber.toDouble());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (TimeType$.MODULE$.accepts(value, ctx)) {
            OffsetTime timeValue = (OffsetTime)TimeType$.MODULE$.coerce(value, ctx).evaluate(ctx);
            String timeStr = timeValue.format(DateTimeFormatter.ofPattern("HH:mm:ss"));
            double excelTime = DateUtil.convertTime((String)timeStr);
            cell.setCellValue(excelTime);
            this.setCellDataFormat(cell, "hh:mm:ss");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (DateTimeType$.MODULE$.accepts(value, ctx) || LocalDateTimeType$.MODULE$.accepts(value, ctx)) {
            ZonedDateTime dateTime = (ZonedDateTime)DateTimeType$.MODULE$.coerce(value, ctx).evaluate(ctx);
            Calendar calendar = JavaDataConverter.CalendarDataConverter$$.MODULE$.asCalendar(dateTime);
            this.setCellDataFormat(cell, "yyyy-MM-ddThh:mm:ss");
            cell.setCellValue(calendar);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (LocalDateType$.MODULE$.accepts(value, ctx)) {
            LocalDate localDate = (LocalDate)LocalDateType$.MODULE$.coerce(value, ctx).evaluate(ctx);
            Date date = ((Calendar)DataConverter$.MODULE$.to((Object)localDate, value.valueType(ctx).schema(ctx), (DataConverter)JavaDataConverter.CalendarDataConverter$$.MODULE$).get()).getTime();
            cell.setCellValue(date);
            this.setCellDataFormat(cell, "yyyy-MM-dd");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void setCellDataFormat(SXSSFCell cell, String format) {
        CellStyle cellStyle = this.wb().createCellStyle();
        cellStyle.setDataFormat(this.wb().getCreationHelper().createDataFormat().getFormat(format));
        cell.setCellStyle(cellStyle);
    }

    public void close() {
        this.wb().dispose();
        this.os.close();
    }

    public static final /* synthetic */ void $anonfun$doWriteValue$1(ExcelWriter $this, EvaluationContext ctx$1, KeyValuePair keyValuePair) {
        String sheetName = ((QualifiedName)keyValuePair._1().evaluate(ctx$1)).name();
        ArraySeq sheetContent = (ArraySeq)ArrayType$.MODULE$.coerce(keyValuePair._2(), ctx$1).evaluate(ctx$1);
        $this.writeSheet(sheetName, sheetContent.toIterator(), ctx$1);
    }

    public ExcelWriter(OutputStream os) {
        this.os = os;
        ConfigurableReaderWriter.$init$((ConfigurableReaderWriter)this);
        Writer.$init$((Writer)this);
        this.settings = new ExcelSettings();
    }
}

