/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.excel;

import java.io.OutputStream;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import org.apache.poi.openxml4j.util.ZipSecureFile;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.model.structure.ArraySeq;
import org.mule.weave.v2.model.structure.KeyValuePair;
import org.mule.weave.v2.model.structure.ObjectSeq;
import org.mule.weave.v2.model.structure.QualifiedName;
import org.mule.weave.v2.model.types.ArrayType$;
import org.mule.weave.v2.model.types.BooleanType$;
import org.mule.weave.v2.model.types.DateTimeType$;
import org.mule.weave.v2.model.types.KeyType$;
import org.mule.weave.v2.model.types.LocalDateTimeType$;
import org.mule.weave.v2.model.types.LocalDateType$;
import org.mule.weave.v2.model.types.NumberType$;
import org.mule.weave.v2.model.types.ObjectType$;
import org.mule.weave.v2.model.types.StringType$;
import org.mule.weave.v2.model.types.TimeType$;
import org.mule.weave.v2.model.values.Value;
import org.mule.weave.v2.module.ConfigurableReaderWriter;
import org.mule.weave.v2.module.DataFormat;
import org.mule.weave.v2.module.excel.ExcelDataFormat;
import org.mule.weave.v2.module.excel.ExcelSettings;
import org.mule.weave.v2.module.excel.ExcelWriter$;
import org.mule.weave.v2.module.pojo.writer.converter.DataConverter;
import org.mule.weave.v2.module.pojo.writer.converter.DataConverter$;
import org.mule.weave.v2.module.pojo.writer.converter.JavaDataConverter;
import org.mule.weave.v2.module.writer.TargetProvider;
import org.mule.weave.v2.module.writer.Writer;
import org.mule.weave.v2.parser.location.Location;
import org.mule.weave.v2.parser.location.LocationCapable;
import scala.Function1;
import scala.Option;
import scala.Some;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import spire.math.Number;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005h\u0001B\u0001\u0003\u0001=\u00111\"\u0012=dK2<&/\u001b;fe*\u00111\u0001B\u0001\u0006Kb\u001cW\r\u001c\u0006\u0003\u000b\u0019\ta!\\8ek2,'BA\u0004\t\u0003\t1(G\u0003\u0002\n\u0015\u0005)q/Z1wK*\u00111\u0002D\u0001\u0005[VdWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\r\u0001\u0001C\u0006\t\u0003#Qi\u0011A\u0005\u0006\u0002'\u0005)1oY1mC&\u0011QC\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005]QR\"\u0001\r\u000b\u0005e!\u0011AB<sSR,'/\u0003\u0002\u001c1\t1qK]5uKJD\u0001\"\b\u0001\u0003\u0002\u0003\u0006IAH\u0001\r_V$\b/\u001e;TiJ,\u0017-\u001c\t\u0003?\u0011j\u0011\u0001\t\u0006\u0003C\t\n!![8\u000b\u0003\r\nAA[1wC&\u0011Q\u0005\t\u0002\r\u001fV$\b/\u001e;TiJ,\u0017-\u001c\u0005\tO\u0001\u0011)\u0019!C\u0001Q\u0005A1/\u001a;uS:<7/F\u0001*!\tQ3&D\u0001\u0003\u0013\ta#AA\u0007Fq\u000e,GnU3ui&twm\u001d\u0005\t]\u0001\u0011\t\u0011)A\u0005S\u0005I1/\u001a;uS:<7\u000f\t\u0005\ta\u0001\u0011\t\u0011)A\u0006c\u0005\u00191\r\u001e=\u0011\u0005I*T\"A\u001a\u000b\u0005Q2\u0011!B7pI\u0016d\u0017B\u0001\u001c4\u0005E)e/\u00197vCRLwN\\\"p]R,\u0007\u0010\u001e\u0005\u0006q\u0001!\t!O\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007ijd\b\u0006\u0002<yA\u0011!\u0006\u0001\u0005\u0006a]\u0002\u001d!\r\u0005\u0006;]\u0002\rA\b\u0005\u0006O]\u0002\r!\u000b\u0005\t\u0001\u0002A)\u0019!C\u0005\u0003\u0006\u0011qOY\u000b\u0002\u0005B\u00111\tT\u0007\u0002\t*\u0011QIR\u0001\ngR\u0014X-Y7j]\u001eT!a\u0012%\u0002\ta\u001c8O\u001a\u0006\u0003\u0013*\u000b1\u0001]8j\u0015\tYE\"\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003\u001b\u0012\u0013Qb\u0015-T'\u001a;vN]6c_>\\\u0007\"B(\u0001\t\u0003\u0002\u0016A\u0002:fgVdG/F\u0001R!\t\t\"+\u0003\u0002T%\t\u0019\u0011I\\=\t\u000bU\u0003A\u0011\u000b,\u0002\u0019\u0011|wK]5uKZ\u000bG.^3\u0015\u0005]cFC\u0001-\\!\t\t\u0012,\u0003\u0002[%\t!QK\\5u\u0011\u0015\u0001D\u000bq\u00012\u0011\u0015iF\u000b1\u0001_\u0003\u00151\u0018\r\\;fa\tyv\rE\u0002aG\u0016l\u0011!\u0019\u0006\u0003EN\naA^1mk\u0016\u001c\u0018B\u00013b\u0005\u00151\u0016\r\\;f!\t1w\r\u0004\u0001\u0005\u0013!d\u0016\u0011!A\u0001\u0006\u0003I'aA0%cE\u0011!.\u0015\t\u0003#-L!\u0001\u001c\n\u0003\u000f9{G\u000f[5oO\")a\u000e\u0001C\u0001_\u0006QqO]5uKNCW-\u001a;\u0015\u0007A\u0014x\u0010\u0006\u0002Yc\")\u0001'\u001ca\u0002c!)1/\u001ca\u0001i\u0006I1\u000f[3fi:\u000bW.\u001a\t\u0003krt!A\u001e>\u0011\u0005]\u0014R\"\u0001=\u000b\u0005et\u0011A\u0002\u001fs_>$h(\u0003\u0002|%\u00051\u0001K]3eK\u001aL!! @\u0003\rM#(/\u001b8h\u0015\tY(\u0003C\u0004\u0002\u00025\u0004\r!a\u0001\u0002\u0019MDW-\u001a;D_:$XM\u001c;\u0011\r\u0005\u0015\u0011qBA\u000b\u001d\u0011\t9!a\u0003\u000f\u0007]\fI!C\u0001\u0014\u0013\r\tiAE\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\t\"a\u0005\u0003\u0011%#XM]1u_JT1!!\u0004\u0013a\u0011\t9\"a\u0007\u0011\t\u0001\u001c\u0017\u0011\u0004\t\u0004M\u0006mAACA\u000f\u007f\u0006\u0005\t\u0011!B\u0001S\n\u0019q\f\n\u001a\t\u000f\u0005\u0005\u0002\u0001\"\u0001\u0002$\u0005yAm\\,sSR,g)\u001b:tiJ{w\u000f\u0006\u0005\u0002&\u0005%\u00121GA\")\rA\u0016q\u0005\u0005\u0007a\u0005}\u00019A\u0019\t\u0011\u0005-\u0012q\u0004a\u0001\u0003[\tQa\u001d5fKR\u00042aQA\u0018\u0013\r\t\t\u0004\u0012\u0002\u000b'b\u001b6KR*iK\u0016$\b\u0002CA\u001b\u0003?\u0001\r!a\u000e\u0002\u0011I|wOV1mk\u0016\u0004B!!\u000f\u0002@5\u0011\u00111\b\u0006\u0004\u0003{\u0019\u0014!C:ueV\u001cG/\u001e:f\u0013\u0011\t\t%a\u000f\u0003\u0013=\u0013'.Z2u'\u0016\f\b\u0002CA#\u0003?\u0001\r!a\u0012\u0002\rI|wOT;n!\r\t\u0012\u0011J\u0005\u0004\u0003\u0017\u0012\"aA%oi\"9\u0011q\n\u0001\u0005\u0002\u0005E\u0013A\u00033p/JLG/\u001a*poR1\u00111KA,\u0003C\"2\u0001WA+\u0011\u0019\u0001\u0014Q\na\u0002c!A\u0011\u0011LA'\u0001\u0004\tY&A\u0002s_^\u00042aQA/\u0013\r\ty\u0006\u0012\u0002\t'b\u001b6K\u0012*po\"A\u0011QGA'\u0001\u0004\t9\u0004C\u0004\u0002f\u0001!\t!a\u001a\u0002\u0013]\u0014\u0018\u000e^3DK2dGCBA5\u0003[\n9\bF\u0002Y\u0003WBa\u0001MA2\u0001\b\t\u0004\u0002CA8\u0003G\u0002\r!!\u001d\u0002\t\r,G\u000e\u001c\t\u0004\u0007\u0006M\u0014bAA;\t\nI1\u000bW*T\r\u000e+G\u000e\u001c\u0005\t\u0003s\n\u0019\u00071\u0001\u0002|\u0005I1-\u001a7m-\u0006dW/\u001a\u0019\u0005\u0003{\n\t\t\u0005\u0003aG\u0006}\u0004c\u00014\u0002\u0002\u0012Y\u00111QA<\u0003\u0003\u0005\tQ!\u0001j\u0005\ryFe\r\u0005\b\u0003\u000f\u0003A\u0011AAE\u0003E\u0019X\r^\"fY2$\u0015\r^1G_Jl\u0017\r\u001e\u000b\u00061\u0006-\u0015Q\u0012\u0005\t\u0003_\n)\t1\u0001\u0002r!9\u0011qRAC\u0001\u0004!\u0018A\u00024pe6\fG\u000fC\u0004\u0002\u0014\u0002!\t%!&\u0002\u000b\rdwn]3\u0015\u0003aCq!!'\u0001\t\u0003\n)*A\u0003gYV\u001c\b\u000eC\u0004\u0002\u001e\u0002!\t%a(\u0002\u0015\u0011\fG/\u0019$pe6\fG/\u0006\u0002\u0002\"B)\u0011#a)\u0002(&\u0019\u0011Q\u0015\n\u0003\r=\u0003H/[8oa\u0019\tI+a-\u0002:BA\u00111VAW\u0003c\u000b9,D\u0001\u0005\u0013\r\ty\u000b\u0002\u0002\u000b\t\u0006$\u0018MR8s[\u0006$\bc\u00014\u00024\u0012Y\u0011QWAN\u0003\u0003\u0005\tQ!\u0001j\u0005\ryF\u0005\u000e\t\u0004M\u0006eFaCA^\u00037\u000b\t\u0011!A\u0003\u0002%\u00141a\u0018\u00136\u000f\u001d\tyL\u0001E\u0001\u0003\u0003\f1\"\u0012=dK2<&/\u001b;feB\u0019!&a1\u0007\r\u0005\u0011\u0001\u0012AAc'\r\t\u0019\r\u0005\u0005\bq\u0005\rG\u0011AAe)\t\t\t\r\u0003\u0005\u0002N\u0006\rG\u0011AAh\u0003\u0015\t\u0007\u000f\u001d7z)\u0019\t\t.!6\u0002`R\u00191(a5\t\rA\nY\rq\u00012\u0011!\t9.a3A\u0002\u0005e\u0017A\u0001;q!\r9\u00121\\\u0005\u0004\u0003;D\"A\u0004+be\u001e,G\u000f\u0015:pm&$WM\u001d\u0005\u0007O\u0005-\u0007\u0019A\u0015")
public class ExcelWriter
implements Writer {
    private SXSSFWorkbook wb;
    private final OutputStream outputStream;
    private final ExcelSettings settings;
    private volatile boolean bitmap$0;

    public static ExcelWriter apply(TargetProvider targetProvider, ExcelSettings excelSettings, EvaluationContext evaluationContext) {
        return ExcelWriter$.MODULE$.apply(targetProvider, excelSettings, evaluationContext);
    }

    public void startDocument(LocationCapable location) {
        Writer.startDocument$((Writer)this, (LocationCapable)location);
    }

    public void defineNamespace(LocationCapable location, String prefix, String uri) {
        Writer.defineNamespace$((Writer)this, (LocationCapable)location, (String)prefix, (String)uri);
    }

    public final void writeValue(Value<?> value, EvaluationContext ctx) {
        Writer.writeValue$((Writer)this, value, (EvaluationContext)ctx);
    }

    public String getName() {
        return Writer.getName$((Writer)this);
    }

    public final void endDocument(LocationCapable location) {
        Writer.endDocument$((Writer)this, (LocationCapable)location);
    }

    public void doEndDocument(LocationCapable location) {
        Writer.doEndDocument$((Writer)this, (LocationCapable)location);
    }

    public void setOption(Location location, String optionName, Object value) {
        ConfigurableReaderWriter.setOption$((ConfigurableReaderWriter)this, (Location)location, (String)optionName, (Object)value);
    }

    public ExcelSettings settings() {
        return this.settings;
    }

    /*
     * WARNING - void declaration
     */
    private SXSSFWorkbook wb$lzycompute() {
        ExcelWriter excelWriter = this;
        synchronized (excelWriter) {
            if (!this.bitmap$0) {
                void var2_2;
                SXSSFWorkbook workbook = new SXSSFWorkbook(1000);
                workbook.setCompressTempFiles(true);
                this.wb = var2_2;
                this.bitmap$0 = true;
            }
        }
        return this.wb;
    }

    private SXSSFWorkbook wb() {
        return !this.bitmap$0 ? this.wb$lzycompute() : this.wb;
    }

    public Object result() {
        return this.outputStream;
    }

    public void doWriteValue(Value<?> value, EvaluationContext ctx) {
        if (!this.settings().zipBombCheck()) {
            ZipSecureFile.setMinInflateRatio((double)0.0);
        }
        Iterator objectSeq = ((ObjectSeq)ObjectType$.MODULE$.coerce(value, ctx).evaluate(ctx)).toIterator(ctx);
        objectSeq.foreach((Function1 & Serializable & scala.Serializable)keyValuePair -> {
            ExcelWriter.$anonfun$doWriteValue$1(this, ctx, keyValuePair);
            return BoxedUnit.UNIT;
        });
        this.wb().write(this.outputStream);
    }

    public void writeSheet(String sheetName, Iterator<Value<?>> sheetContent, EvaluationContext ctx) {
        SXSSFSheet sheet = this.wb().createSheet(sheetName);
        int rowNum = this.settings().headerRowNum();
        if (this.settings().header() && sheetContent.hasNext()) {
            ObjectSeq rowObjectSeq = (ObjectSeq)ObjectType$.MODULE$.coerce((Value)sheetContent.next(), ctx).evaluate(ctx);
            this.doWriteFirstRow(sheet, rowObjectSeq, rowNum, ctx);
            rowNum += 2;
        }
        while (sheetContent.hasNext()) {
            SXSSFRow row = sheet.createRow(rowNum);
            ObjectSeq rowObjectSeq = (ObjectSeq)ObjectType$.MODULE$.coerce((Value)sheetContent.next(), ctx).evaluate(ctx);
            this.doWriteRow(row, rowObjectSeq, ctx);
            ++rowNum;
        }
    }

    public void doWriteFirstRow(SXSSFSheet sheet, ObjectSeq rowValue, int rowNum, EvaluationContext ctx) {
        SXSSFRow row0 = sheet.createRow(rowNum);
        SXSSFRow row1 = sheet.createRow(rowNum + 1);
        int colNumber = this.settings().headerColNum();
        Iterator keyValuePairs = rowValue.toIterator(ctx);
        while (keyValuePairs.hasNext()) {
            KeyValuePair keyValuePair = (KeyValuePair)keyValuePairs.next();
            SXSSFCell headerCell = row0.createCell(colNumber);
            String headerString = ((QualifiedName)KeyType$.MODULE$.coerce(keyValuePair._1(), ctx).evaluate(ctx)).name();
            headerCell.setCellValue(headerString);
            SXSSFCell cell = row1.createCell(colNumber);
            this.writeCell(cell, keyValuePair._2(), ctx);
            ++colNumber;
        }
    }

    public void doWriteRow(SXSSFRow row, ObjectSeq rowValue, EvaluationContext ctx) {
        int colNumber = this.settings().headerColNum();
        Iterator keyValuePairs = rowValue.toIterator(ctx);
        while (keyValuePairs.hasNext()) {
            SXSSFCell cell = row.createCell(colNumber);
            Value cellValue = ((KeyValuePair)keyValuePairs.next())._2();
            this.writeCell(cell, cellValue, ctx);
            ++colNumber;
        }
    }

    public void writeCell(SXSSFCell cell, Value<?> cellValue, EvaluationContext ctx) {
        Value<?> value = cellValue;
        if (StringType$.MODULE$.accepts(value, ctx)) {
            String cellStr = (String)StringType$.MODULE$.coerce(value, ctx).evaluate(ctx);
            cell.setCellValue(cellStr);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (BooleanType$.MODULE$.accepts(value, ctx)) {
            boolean booleanValue = BoxesRunTime.unboxToBoolean((Object)BooleanType$.MODULE$.coerce(value, ctx).evaluate(ctx));
            cell.setCellValue(booleanValue);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (NumberType$.MODULE$.accepts(value, ctx)) {
            Number cellNumber = (Number)NumberType$.MODULE$.coerce(value, ctx).evaluate(ctx);
            cell.setCellValue(cellNumber.toDouble());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (TimeType$.MODULE$.accepts(value, ctx)) {
            OffsetTime timeValue = (OffsetTime)TimeType$.MODULE$.coerce(value, ctx).evaluate(ctx);
            String timeStr = timeValue.format(DateTimeFormatter.ofPattern("HH:mm:ss"));
            double excelTime = DateUtil.convertTime((String)timeStr);
            cell.setCellValue(excelTime);
            this.setCellDataFormat(cell, "hh:mm:ss");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (DateTimeType$.MODULE$.accepts(value, ctx) || LocalDateTimeType$.MODULE$.accepts(value, ctx)) {
            ZonedDateTime dateTime = (ZonedDateTime)DateTimeType$.MODULE$.coerce(value, ctx).evaluate(ctx);
            Calendar calendar = JavaDataConverter.CalendarDataConverter$$.MODULE$.asCalendar(dateTime);
            this.setCellDataFormat(cell, "yyyy-MM-ddThh:mm:ss");
            cell.setCellValue(calendar);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (LocalDateType$.MODULE$.accepts(value, ctx)) {
            LocalDate localDate = (LocalDate)LocalDateType$.MODULE$.coerce(value, ctx).evaluate(ctx);
            Date date = ((Calendar)DataConverter$.MODULE$.to((Object)localDate, value.valueType(ctx).schema(ctx), (DataConverter)JavaDataConverter.CalendarDataConverter$$.MODULE$, ctx).get()).getTime();
            cell.setCellValue(date);
            this.setCellDataFormat(cell, "yyyy-MM-dd");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void setCellDataFormat(SXSSFCell cell, String format) {
        CellStyle cellStyle = this.wb().createCellStyle();
        cellStyle.setDataFormat(this.wb().getCreationHelper().createDataFormat().getFormat(format));
        cell.setCellStyle(cellStyle);
    }

    public void close() {
        this.wb().dispose();
        this.outputStream.close();
    }

    public void flush() {
        this.outputStream.flush();
    }

    public Option<DataFormat<?, ?>> dataFormat() {
        return new Some((Object)new ExcelDataFormat());
    }

    public static final /* synthetic */ void $anonfun$doWriteValue$1(ExcelWriter $this, EvaluationContext ctx$1, KeyValuePair keyValuePair) {
        String sheetName = ((QualifiedName)keyValuePair._1().evaluate(ctx$1)).name();
        ArraySeq sheetContent = (ArraySeq)ArrayType$.MODULE$.coerce(keyValuePair._2(), ctx$1).evaluate(ctx$1);
        $this.writeSheet(sheetName, sheetContent.toIterator(), ctx$1);
    }

    public ExcelWriter(OutputStream outputStream, ExcelSettings settings, EvaluationContext ctx) {
        this.outputStream = outputStream;
        this.settings = settings;
        ConfigurableReaderWriter.$init$((ConfigurableReaderWriter)this);
        Writer.$init$((Writer)this);
    }
}

