/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.excel;

import java.io.OutputStream;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.compress.archivers.zip.Zip64Mode;
import org.apache.poi.openxml4j.util.ZipSecureFile;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.model.structure.ArraySeq;
import org.mule.weave.v2.model.structure.KeyValuePair;
import org.mule.weave.v2.model.structure.ObjectSeq;
import org.mule.weave.v2.model.structure.QualifiedName;
import org.mule.weave.v2.model.types.ArrayType$;
import org.mule.weave.v2.model.types.BooleanType$;
import org.mule.weave.v2.model.types.DateTimeType$;
import org.mule.weave.v2.model.types.KeyType$;
import org.mule.weave.v2.model.types.LocalDateTimeType$;
import org.mule.weave.v2.model.types.LocalDateType$;
import org.mule.weave.v2.model.types.NumberType$;
import org.mule.weave.v2.model.types.ObjectType$;
import org.mule.weave.v2.model.types.StringType$;
import org.mule.weave.v2.model.types.TimeType$;
import org.mule.weave.v2.model.values.Value;
import org.mule.weave.v2.model.values.math.Number;
import org.mule.weave.v2.module.ConfigurableReaderWriter;
import org.mule.weave.v2.module.DataFormat;
import org.mule.weave.v2.module.commons.java.writer.converter.DataConverter;
import org.mule.weave.v2.module.commons.java.writer.converter.DataConverter$;
import org.mule.weave.v2.module.excel.ExcelDataFormat;
import org.mule.weave.v2.module.excel.ExcelSettings;
import org.mule.weave.v2.module.excel.ExcelWriter$;
import org.mule.weave.v2.module.pojo.writer.converter.JavaDataConverter$;
import org.mule.weave.v2.module.writer.TargetProvider;
import org.mule.weave.v2.module.writer.Writer;
import org.mule.weave.v2.parser.location.Location;
import org.mule.weave.v2.parser.location.LocationCapable;
import scala.Function1;
import scala.Option;
import scala.Some;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005h\u0001B\u000b\u0017\u0001\rB\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\ts\u0001\u0011)\u0019!C\u0001u!Aq\b\u0001B\u0001B\u0003%1\b\u0003\u0005A\u0001\t\u0005\t\u0015a\u0003B\u0011\u00159\u0005\u0001\"\u0001I\u0011!q\u0005\u0001#b\u0001\n\u0013y\u0005\"\u0002/\u0001\t\u0003j\u0006\"B1\u0001\t#\u0012\u0007\"B=\u0001\t\u0003Q\bbBA\u001b\u0001\u0011\u0005\u0011q\u0007\u0005\b\u0003C\u0002A\u0011AA2\u0011\u001d\t)\b\u0001C\u0001\u0003oBq!!&\u0001\t\u0003\t9\nC\u0004\u0002 \u0002!\t%!)\t\u000f\u0005\r\u0006\u0001\"\u0011\u0002\"\"9\u0011Q\u0015\u0001\u0005B\u0005\u001dvaBAc-!\u0005\u0011q\u0019\u0004\u0007+YA\t!!3\t\r\u001d\u0013B\u0011AAf\u0011\u001d\tiM\u0005C\u0001\u0003\u001f\u00141\"\u0012=dK2<&/\u001b;fe*\u0011q\u0003G\u0001\u0006Kb\u001cW\r\u001c\u0006\u00033i\ta!\\8ek2,'BA\u000e\u001d\u0003\t1(G\u0003\u0002\u001e=\u0005)q/Z1wK*\u0011q\u0004I\u0001\u0005[VdWMC\u0001\"\u0003\ry'oZ\u0002\u0001'\r\u0001AE\u000b\t\u0003K!j\u0011A\n\u0006\u0002O\u0005)1oY1mC&\u0011\u0011F\n\u0002\u0007\u0003:L(+\u001a4\u0011\u0005-rS\"\u0001\u0017\u000b\u00055B\u0012AB<sSR,'/\u0003\u00020Y\t1qK]5uKJ\fAb\\;uaV$8\u000b\u001e:fC6\u0004\"AM\u001c\u000e\u0003MR!\u0001N\u001b\u0002\u0005%|'\"\u0001\u001c\u0002\t)\fg/Y\u0005\u0003qM\u0012AbT;uaV$8\u000b\u001e:fC6\f\u0001b]3ui&twm]\u000b\u0002wA\u0011A(P\u0007\u0002-%\u0011aH\u0006\u0002\u000e\u000bb\u001cW\r\\*fiRLgnZ:\u0002\u0013M,G\u000f^5oON\u0004\u0013aA2uqB\u0011!)R\u0007\u0002\u0007*\u0011AIG\u0001\u0006[>$W\r\\\u0005\u0003\r\u000e\u0013\u0011#\u0012<bYV\fG/[8o\u0007>tG/\u001a=u\u0003\u0019a\u0014N\\5u}Q\u0019\u0011\nT'\u0015\u0005)[\u0005C\u0001\u001f\u0001\u0011\u0015\u0001U\u0001q\u0001B\u0011\u0015\u0001T\u00011\u00012\u0011\u0015IT\u00011\u0001<\u0003\t9(-F\u0001Q!\t\t&,D\u0001S\u0015\t\u0019F+A\u0005tiJ,\u0017-\\5oO*\u0011QKV\u0001\u0005qN\u001chM\u0003\u0002X1\u0006\u0019\u0001o\\5\u000b\u0005e\u0003\u0013AB1qC\u000eDW-\u0003\u0002\\%\ni1\u000bW*T\r^{'o\u001b2p_.\faA]3tk2$X#\u00010\u0011\u0005\u0015z\u0016B\u00011'\u0005\r\te._\u0001\rI><&/\u001b;f-\u0006dW/\u001a\u000b\u0003G\"$\"\u0001Z4\u0011\u0005\u0015*\u0017B\u00014'\u0005\u0011)f.\u001b;\t\u000b\u0001C\u00019A!\t\u000b%D\u0001\u0019\u00016\u0002\u000bY\fG.^31\u0005-\u001c\bc\u00017pc6\tQN\u0003\u0002o\u0007\u00061a/\u00197vKNL!\u0001]7\u0003\u000bY\u000bG.^3\u0011\u0005I\u001cH\u0002\u0001\u0003\ni\"\f\t\u0011!A\u0003\u0002U\u00141a\u0018\u00132#\t1h\f\u0005\u0002&o&\u0011\u0001P\n\u0002\b\u001d>$\b.\u001b8h\u0003)9(/\u001b;f'\",W\r\u001e\u000b\u0005wv\f)\u0002\u0006\u0002ey\")\u0001)\u0003a\u0002\u0003\")a0\u0003a\u0001\u007f\u0006I1\u000f[3fi:\u000bW.\u001a\t\u0005\u0003\u0003\tyA\u0004\u0003\u0002\u0004\u0005-\u0001cAA\u0003M5\u0011\u0011q\u0001\u0006\u0004\u0003\u0013\u0011\u0013A\u0002\u001fs_>$h(C\u0002\u0002\u000e\u0019\na\u0001\u0015:fI\u00164\u0017\u0002BA\t\u0003'\u0011aa\u0015;sS:<'bAA\u0007M!9\u0011qC\u0005A\u0002\u0005e\u0011\u0001D:iK\u0016$8i\u001c8uK:$\bCBA\u000e\u0003K\tYC\u0004\u0003\u0002\u001e\u0005\u0005b\u0002BA\u0003\u0003?I\u0011aJ\u0005\u0004\u0003G1\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003O\tIC\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0015\r\t\u0019C\n\u0019\u0005\u0003[\t\t\u0004\u0005\u0003m_\u0006=\u0002c\u0001:\u00022\u0011Y\u00111GA\u000b\u0003\u0003\u0005\tQ!\u0001v\u0005\ryFEM\u0001\u0010I><&/\u001b;f\r&\u00148\u000f\u001e*poRA\u0011\u0011HA\u001f\u0003\u000f\n9\u0006F\u0002e\u0003wAQ\u0001\u0011\u0006A\u0004\u0005Cq!a\u0010\u000b\u0001\u0004\t\t%A\u0003tQ\u0016,G\u000fE\u0002R\u0003\u0007J1!!\u0012S\u0005)\u0019\u0006lU*G'\",W\r\u001e\u0005\b\u0003\u0013R\u0001\u0019AA&\u0003!\u0011xn\u001e,bYV,\u0007\u0003BA'\u0003'j!!a\u0014\u000b\u0007\u0005E3)A\u0005tiJ,8\r^;sK&!\u0011QKA(\u0005%y%M[3diN+\u0017\u000fC\u0004\u0002Z)\u0001\r!a\u0017\u0002\rI|wOT;n!\r)\u0013QL\u0005\u0004\u0003?2#aA%oi\u0006QAm\\,sSR,'k\\<\u0015\r\u0005\u0015\u0014\u0011NA:)\r!\u0017q\r\u0005\u0006\u0001.\u0001\u001d!\u0011\u0005\b\u0003WZ\u0001\u0019AA7\u0003\r\u0011xn\u001e\t\u0004#\u0006=\u0014bAA9%\nA1\u000bW*T\rJ{w\u000fC\u0004\u0002J-\u0001\r!a\u0013\u0002\u0013]\u0014\u0018\u000e^3DK2dGCBA=\u0003{\n9\tF\u0002e\u0003wBQ\u0001\u0011\u0007A\u0004\u0005Cq!a \r\u0001\u0004\t\t)\u0001\u0003dK2d\u0007cA)\u0002\u0004&\u0019\u0011Q\u0011*\u0003\u0013MC6k\u0015$DK2d\u0007bBAE\u0019\u0001\u0007\u00111R\u0001\nG\u0016dGNV1mk\u0016\u0004D!!$\u0002\u0012B!An\\AH!\r\u0011\u0018\u0011\u0013\u0003\f\u0003'\u000b9)!A\u0001\u0002\u000b\u0005QOA\u0002`IM\n\u0011c]3u\u0007\u0016dG\u000eR1uC\u001a{'/\\1u)\u0015!\u0017\u0011TAN\u0011\u001d\ty(\u0004a\u0001\u0003\u0003Ca!!(\u000e\u0001\u0004y\u0018A\u00024pe6\fG/A\u0003dY>\u001cX\rF\u0001e\u0003\u00151G.^:i\u0003)!\u0017\r^1G_Jl\u0017\r^\u000b\u0003\u0003S\u0003R!JAV\u0003_K1!!,'\u0005\u0019y\u0005\u000f^5p]B2\u0011\u0011WA^\u0003\u0003\u0004\u0002\"a-\u00026\u0006e\u0016qX\u0007\u00021%\u0019\u0011q\u0017\r\u0003\u0015\u0011\u000bG/\u0019$pe6\fG\u000fE\u0002s\u0003w#!\"!0\u0011\u0003\u0003\u0005\tQ!\u0001v\u0005\ryF\u0005\u000e\t\u0004e\u0006\u0005GACAb!\u0005\u0005\t\u0011!B\u0001k\n\u0019q\fJ\u001b\u0002\u0017\u0015C8-\u001a7Xe&$XM\u001d\t\u0003yI\u0019\"A\u0005\u0013\u0015\u0005\u0005\u001d\u0017!B1qa2LHCBAi\u0003+\fy\u000eF\u0002K\u0003'DQ\u0001\u0011\u000bA\u0004\u0005Cq!a6\u0015\u0001\u0004\tI.\u0001\u0002uaB\u00191&a7\n\u0007\u0005uGF\u0001\bUCJ<W\r\u001e)s_ZLG-\u001a:\t\u000be\"\u0002\u0019A\u001e")
public class ExcelWriter
implements Writer {
    private SXSSFWorkbook wb;
    private final OutputStream outputStream;
    private final ExcelSettings settings;
    private volatile boolean bitmap$0;

    public static ExcelWriter apply(TargetProvider targetProvider, ExcelSettings excelSettings, EvaluationContext evaluationContext) {
        return ExcelWriter$.MODULE$.apply(targetProvider, excelSettings, evaluationContext);
    }

    public boolean supportsStreaming() {
        return Writer.supportsStreaming$((Writer)this);
    }

    public void startDocument(LocationCapable location) {
        Writer.startDocument$((Writer)this, (LocationCapable)location);
    }

    public void defineNamespace(LocationCapable location, String prefix, String uri) {
        Writer.defineNamespace$((Writer)this, (LocationCapable)location, (String)prefix, (String)uri);
    }

    public final void writeValue(Value<?> value, EvaluationContext ctx) {
        Writer.writeValue$((Writer)this, value, (EvaluationContext)ctx);
    }

    public String getName() {
        return Writer.getName$((Writer)this);
    }

    public final void endDocument(LocationCapable location) {
        Writer.endDocument$((Writer)this, (LocationCapable)location);
    }

    public void doEndDocument(LocationCapable location) {
        Writer.doEndDocument$((Writer)this, (LocationCapable)location);
    }

    public void setOption(Location location, String optionName, Object value, EvaluationContext ctx) {
        ConfigurableReaderWriter.setOption$((ConfigurableReaderWriter)this, (Location)location, (String)optionName, (Object)value, (EvaluationContext)ctx);
    }

    public ExcelSettings settings() {
        return this.settings;
    }

    /*
     * WARNING - void declaration
     */
    private SXSSFWorkbook wb$lzycompute() {
        ExcelWriter excelWriter = this;
        synchronized (excelWriter) {
            if (!this.bitmap$0) {
                void var2_2;
                SXSSFWorkbook workbook = new SXSSFWorkbook(1000);
                workbook.setCompressTempFiles(true);
                workbook.setZip64Mode(Zip64Mode.AsNeeded);
                this.wb = var2_2;
                this.bitmap$0 = true;
            }
        }
        return this.wb;
    }

    private SXSSFWorkbook wb() {
        return !this.bitmap$0 ? this.wb$lzycompute() : this.wb;
    }

    public Object result() {
        return this.outputStream;
    }

    public void doWriteValue(Value<?> value, EvaluationContext ctx) {
        if (!this.settings().zipBombCheck()) {
            ZipSecureFile.setMinInflateRatio((double)0.0);
        } else if (this.settings().minInflateRatio().isDefined()) {
            ZipSecureFile.setMinInflateRatio((double)BoxesRunTime.unboxToDouble((Object)this.settings().minInflateRatio().get()));
        }
        Iterator objectSeq = ((ObjectSeq)ObjectType$.MODULE$.coerce(value, ctx).evaluate(ctx)).toIterator(ctx);
        objectSeq.foreach((Function1 & Serializable & scala.Serializable)keyValuePair -> {
            ExcelWriter.$anonfun$doWriteValue$1(this, ctx, keyValuePair);
            return BoxedUnit.UNIT;
        });
        this.wb().write(this.outputStream);
    }

    public void writeSheet(String sheetName, Iterator<Value<?>> sheetContent, EvaluationContext ctx) {
        SXSSFSheet sheet = this.wb().createSheet(sheetName);
        int rowNum = this.settings().headerRowNum();
        if (this.settings().header() && sheetContent.hasNext()) {
            Value rowValue = (Value)sheetContent.next();
            ObjectSeq rowObjectSeq = (ObjectSeq)ObjectType$.MODULE$.coerce(rowValue, ctx).evaluate(ctx);
            this.doWriteFirstRow(sheet, rowObjectSeq, rowNum, ctx);
            rowNum += 2;
        }
        while (sheetContent.hasNext()) {
            SXSSFRow row = sheet.createRow(rowNum);
            Value rowValue = (Value)sheetContent.next();
            ObjectSeq rowObjectSeq = (ObjectSeq)ObjectType$.MODULE$.coerce(rowValue, ctx).evaluate(ctx);
            this.doWriteRow(row, rowObjectSeq, ctx);
            ++rowNum;
        }
    }

    public void doWriteFirstRow(SXSSFSheet sheet, ObjectSeq rowValue, int rowNum, EvaluationContext ctx) {
        SXSSFRow row0 = sheet.createRow(rowNum);
        SXSSFRow row1 = sheet.createRow(rowNum + 1);
        int colNumber = this.settings().headerColNum();
        Iterator keyValuePairs = rowValue.toIterator(ctx);
        while (keyValuePairs.hasNext()) {
            KeyValuePair keyValuePair = (KeyValuePair)keyValuePairs.next();
            SXSSFCell headerCell = row0.createCell(colNumber);
            String headerString = ((QualifiedName)KeyType$.MODULE$.coerce(keyValuePair._1(), ctx).evaluate(ctx)).name();
            headerCell.setCellValue(headerString);
            SXSSFCell cell = row1.createCell(colNumber);
            this.writeCell(cell, keyValuePair._2(), ctx);
            ++colNumber;
        }
    }

    public void doWriteRow(SXSSFRow row, ObjectSeq rowValue, EvaluationContext ctx) {
        int colNumber = this.settings().headerColNum();
        Iterator keyValuePairs = rowValue.toIterator(ctx);
        while (keyValuePairs.hasNext()) {
            SXSSFCell cell = row.createCell(colNumber);
            Value cellValue = ((KeyValuePair)keyValuePairs.next())._2();
            this.writeCell(cell, cellValue, ctx);
            ++colNumber;
        }
    }

    public void writeCell(SXSSFCell cell, Value<?> cellValue, EvaluationContext ctx) {
        Value<?> value = cellValue;
        if (StringType$.MODULE$.accepts(value, ctx)) {
            String cellStr = StringType$.MODULE$.coerce(value, ctx).evaluate(ctx).toString();
            cell.setCellValue(cellStr);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (BooleanType$.MODULE$.accepts(value, ctx)) {
            boolean booleanValue = BoxesRunTime.unboxToBoolean((Object)BooleanType$.MODULE$.coerce(value, ctx).evaluate(ctx));
            cell.setCellValue(booleanValue);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (NumberType$.MODULE$.accepts(value, ctx)) {
            Number cellNumber = (Number)NumberType$.MODULE$.coerce(value, ctx).evaluate(ctx);
            cell.setCellValue(cellNumber.toDouble());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (TimeType$.MODULE$.accepts(value, ctx)) {
            OffsetTime timeValue = (OffsetTime)TimeType$.MODULE$.coerce(value, ctx).evaluate(ctx);
            String timeStr = timeValue.format(DateTimeFormatter.ofPattern("HH:mm:ss"));
            double excelTime = DateUtil.convertTime((String)timeStr);
            cell.setCellValue(excelTime);
            this.setCellDataFormat(cell, "hh:mm:ss");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (DateTimeType$.MODULE$.accepts(value, ctx) || LocalDateTimeType$.MODULE$.accepts(value, ctx)) {
            ZonedDateTime dateTime = (ZonedDateTime)DateTimeType$.MODULE$.coerce(value, ctx).evaluate(ctx);
            Calendar calendar = JavaDataConverter$.MODULE$.CalendarDataConverter$().asCalendar(dateTime);
            this.setCellDataFormat(cell, "yyyy-MM-ddThh:mm:ss");
            cell.setCellValue(calendar);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (LocalDateType$.MODULE$.accepts(value, ctx)) {
            LocalDate localDate = (LocalDate)LocalDateType$.MODULE$.coerce(value, ctx).evaluate(ctx);
            Date date = ((Calendar)DataConverter$.MODULE$.to((Object)localDate, value.schema(ctx), (DataConverter)JavaDataConverter$.MODULE$.CalendarDataConverter$(), ctx).get()).getTime();
            cell.setCellValue(date);
            this.setCellDataFormat(cell, "yyyy-MM-dd");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void setCellDataFormat(SXSSFCell cell, String format) {
        CellStyle cellStyle = this.wb().createCellStyle();
        cellStyle.setDataFormat(this.wb().getCreationHelper().createDataFormat().getFormat(format));
        cell.setCellStyle(cellStyle);
    }

    public void close() {
        this.wb().dispose();
        this.outputStream.close();
    }

    public void flush() {
        this.outputStream.flush();
    }

    public Option<DataFormat<?, ?>> dataFormat() {
        return new Some((Object)new ExcelDataFormat());
    }

    public static final /* synthetic */ void $anonfun$doWriteValue$1(ExcelWriter $this, EvaluationContext ctx$1, KeyValuePair keyValuePair) {
        String sheetName = ((QualifiedName)keyValuePair._1().evaluate(ctx$1)).name();
        ArraySeq sheetContent = (ArraySeq)ArrayType$.MODULE$.coerce(keyValuePair._2(), ctx$1).evaluate(ctx$1);
        $this.writeSheet(sheetName, sheetContent.toIterator(), ctx$1);
    }

    public ExcelWriter(OutputStream outputStream, ExcelSettings settings, EvaluationContext ctx) {
        this.outputStream = outputStream;
        this.settings = settings;
        ConfigurableReaderWriter.$init$((ConfigurableReaderWriter)this);
        Writer.$init$((Writer)this);
    }
}

