package org.mule.weave.v2.module.flatfile.values

import com.mulesoft.flatfile.schema.fixedwidth.DynamicData
import com.mulesoft.flatfile.schema.model.FixedRedefinesComponent
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.model.values.math.Number

import java.time.LocalDate
import java.time.LocalDateTime
import java.time.LocalTime
import java.{ math => jm }
import java.{ util => ju }

trait FlatValue extends Value[Any] {
}

object FlatValue {
  implicit def apply(value: Any, loc: FlatLocation): FlatValue = {
    value match {
      case s: String => new FlatStringValue(loc, s)
      case i: Integer => new FlatNumberValue(loc, Number(i))
      case l: Long => new FlatNumberValue(loc, Number(l))
      case b: jm.BigInteger => new FlatNumberValue(loc, Number(new jm.BigDecimal(b)))
      case d: jm.BigDecimal => new FlatNumberValue(loc, Number(d))
      case b: Boolean => new FlatBooleanValue(loc, b)
      case d: LocalDate => new FlatLocalDateValue(loc, d)
      case d: LocalDateTime => new FlatLocalDateTimeValue(loc, d)
      case t: LocalTime => new FlatLocalTimeValue(loc, t)
      case l: ju.List[_] => new FlatArrayValue(loc, l)
      case m: ju.Map[Any, Any] => new FlatObjectValue(loc, m)
      case (r: FixedRedefinesComponent, d: DynamicData) => new DynamicObjectValue(loc, d, 0, r)
      case null => new FlatNullValue(loc)
      case _ => throw new IllegalArgumentException(s"Unexpected type ${value.getClass.getName}")
    }
  }

}