package org.mule.weave.v2.module.flatfile.values

import com.mulesoft.flatfile.schema.fixedwidth.DynamicData
import com.mulesoft.flatfile.schema.model.FixedCompositeComponent
import com.mulesoft.flatfile.schema.model.FixedElementComponent
import com.mulesoft.flatfile.schema.model.SegmentComponent
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.ArraySeq
import org.mule.weave.v2.model.values.ArrayValue
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.parser.location.Location

class DynamicArrayValue(loc: FlatLocation, data: DynamicData, start: Int, comp: SegmentComponent) extends ArrayValue with FlatValue {

  //  println(s"Creating DynamicArrayValue at $loc with start $start for component ${comp.name}")

  override def evaluate(implicit ctx: EvaluationContext): T = {
    val itemSize = comp match {
      case e: FixedElementComponent   => e.element.maxSize
      case c: FixedCompositeComponent => c.composite.maxSize
    }
    ArraySeq(new DynamicDataIterator(comp.count, itemSize))
  }

  override def location(): Location = loc

  override def materialize(implicit ctx: EvaluationContext): ArrayValue = this

  class DynamicDataIterator(count: Int, itemSize: Int) extends Iterator[Value[_]] {

    import DynamicSupport.loadElement

    var currentIndex: Int = -1
    var currentValue: Value[_] = null

    override def size(): Int = count

    override def next(): Value[_] = {
      currentIndex += 1
      val itemLoc = loc.child(currentIndex)
      val itemStart = start + currentIndex * itemSize
      currentValue = comp match {
        case e: FixedElementComponent =>
          loadElement(e, data, itemStart, itemLoc)
        case c: FixedCompositeComponent =>
          new DynamicObjectValue(itemLoc, data, itemStart, c)
      }
      currentValue
    }

    override def hasNext: Boolean = currentIndex < size - 1

  }
}