package org.mule.weave.v2.module.flatfile.values

import java.{ util => ju }

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.ObjectSeq
import org.mule.weave.v2.model.values.AlreadyMaterializedObjectValue
import org.mule.weave.v2.parser.location.Location

import scala.collection.JavaConverters
import scala.collection.mutable

class FlatObjectValue(loc: FlatLocation, value: ju.Map[Any, Any]) extends AlreadyMaterializedObjectValue with FlatValue {

  lazy val objectSeq = {
    val scalaMap: mutable.Map[Any, Any] = JavaConverters.mapAsScalaMap(value)
    ObjectSeq(scalaMap, (value, key) => FlatValue(value, loc.child(key)))
  }
  override def evaluate(implicit ctx: EvaluationContext): T = {
    objectSeq
  }

  override def location(): Location = loc

}