package org.mule.weave.v2.module.flatfile.output

import java.util.HashMap

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.ObjectSeq
import org.mule.weave.v2.model.structure.QualifiedName
import org.mule.weave.v2.model.values.NullValue
import org.mule.weave.v2.model.values.Value

class MapFacade(oseq: ObjectSeq)(implicit ctx: EvaluationContext) extends HashMap[String, Object] {

  oseq.toIterator().foreach { value =>
    val kvp = value
    val key = kvp._1
    kvp._1.evaluate match {
      case qname: QualifiedName if (qname.namespace.isEmpty) => put(qname.name, ConvertValue.convertValue(kvp._2))
      case _ => throw new IllegalArgumentException("Key is not a simple string value")
    }
  }

  override def get(key: Any): Object = {
    key match {
      case str: String => super.get(key)
      case _           => throw new IllegalArgumentException("Key must be a string")
    }
  }
}