package org.mule.weave.v2.module.flatfile.output

import java.{ lang => jl }
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.types.ArrayType
import org.mule.weave.v2.model.types.BooleanType
import org.mule.weave.v2.model.types.DateTimeType
import org.mule.weave.v2.model.types.LocalDateTimeType
import org.mule.weave.v2.model.types.LocalDateType
import org.mule.weave.v2.model.types.LocalTimeType
import org.mule.weave.v2.model.types.NumberType
import org.mule.weave.v2.model.types.ObjectType
import org.mule.weave.v2.model.types.StringType
import org.mule.weave.v2.model.types.NameType
import org.mule.weave.v2.model.types.TimeType
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.model.values.math.Number

object ConvertValue {

  def convertValue(v: Value[_])(implicit ctx: EvaluationContext): Object = {
    v.evaluate match {
      case obj: ObjectType.T  => new MapFacade(obj)
      case array: ArrayType.T => new ListFacade(array)
      case str: StringType.T  => str
      case number: NumberType.T => { //Transform it to spire
        number.underlying() match {
          case l: java.lang.Long => Number(l)
          case bi: BigInt        => Number(bi)
          case _                 => Number(number.toBigDecimal)
        }
      }
      case dt: DateTimeType.T       => dt
      case ld: LocalDateType.T      => ld
      case lt: LocalTimeType.T      => lt
      case ldt: LocalDateTimeType.T => ldt
      case time: TimeType.T         => time
      case boolean: BooleanType.T   => if (boolean) jl.Boolean.TRUE else jl.Boolean.FALSE
      case null                     => null
      case name: NameType.T         => name.name
      case _                        => throw new IllegalArgumentException(s"Unsupported data type ${v.getClass.getName}")
    }
  }

}
