package org.mule.weave.v2.module.flatfile.values

import com.mulesoft.flatfile.schema.fixedwidth.DynamicData
import com.mulesoft.flatfile.schema.model.FixedCompositeComponent
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.ObjectSeq
import org.mule.weave.v2.model.values.ObjectValue
import org.mule.weave.v2.parser.location.Location

class DynamicObjectValue(loc: FlatLocation, data: DynamicData, start: Int, comp: FixedCompositeComponent) extends ObjectValue with FlatValue {

  //  println(s"Creating DynamicObjectValue at $loc with start $start for component ${comp.name} with offset ${comp.offset}")

  override def evaluate(implicit ctx: EvaluationContext): T = ObjectSeq(new DynamicDataKeyValuePairIterator(loc, data, start, comp))

  override def location(): Location = loc

  override def materialize(implicit ctx: EvaluationContext): ObjectValue = this
}