package org.mule.weave.v2.module.flatfile.output

import java.util
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.ObjectSeq
import org.mule.weave.v2.model.types.ArrayType

class ListFacade(base: ArrayType.T)(implicit ctx: EvaluationContext) extends util.AbstractList[Object] {

  private val evaluated = base.toSeq().map((value) => {
    value.evaluate match {
      case objseq: ObjectSeq => new MapFacade(objseq)
      case obj: Object       => obj
      case x                 => throw new IllegalArgumentException(s"Unsupported data type ${x.getClass.getName}")
    }
  })

  override def size(): Int = {
    evaluated.size
  }

  override def get(index: Int) = evaluated.apply(index)
}