package org.mule.weave.v2.module.flatfile

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.module.DataFormat
import org.mule.weave.v2.module.reader.SourceProvider
import org.mule.weave.v2.module.writer.DeferredWriter
import org.mule.weave.v2.module.writer.TargetProvider
import org.mule.weave.v2.parser.module.MimeType

class FlatFileDataFormat extends DataFormat[FlatFileReaderSettings, FlatFileWriterSettings] {

  /**
    * The content types supported by this module
    *
    * @return
    */
  override val defaultMimeType: MimeType = new MimeType("application", "flatfile")

  override val acceptedMimeTypes: Seq[MimeType] = Seq(new MimeType("*", "flatfile"))

  /**
    * Create a new instance of the writer using the provided target if present else it will create a new target
    *
    * @param target The target where the result will be written
    * @return The writer
    */
  override def writer(target: Option[Any], outputMimeType: MimeType = defaultMimeType)(implicit ctx: EvaluationContext): DeferredWriter[FlatFileWriterSettings] = {
    DeferredWriter(FlatFileWriter.apply, TargetProvider(target), createWriterSettings())
  }

  /**
    * Creates a new instance of the writer using the given source provider
    *
    * @param source The source provider for this reader
    * @return The Reader
    */
  override def reader(source: SourceProvider)(implicit ctx: EvaluationContext): FlatFileReader = new FlatFileReader(source, createReaderSettings())

  /**
    * The name of this module
    *
    * @return
    */
  override def name(): String = "flatfile"

  override def label(): String = "Flat File"

  /**
    * The file extensions associated with this DataFormat. (".json", ".xml", etc...)
    * Note: This can be empty
    */
  override def fileExtensions: Seq[String] = Seq(".flatfile", ".copybook")

  override def readerSettings(): FlatFileReaderSettings = new FlatFileReaderSettings()

  override def writerSettings(): FlatFileWriterSettings = new FlatFileWriterSettings(this)
}
