package org.mule.weave.v2.module.flatfile

import com.mulesoft.flatfile.schema.fixedwidth.FlatFileParserBase
import com.mulesoft.flatfile.schema.fixedwidth.FlatFileParserConfig
import com.mulesoft.flatfile.schema.fixedwidth.FlatFileSegmentParser
import com.mulesoft.flatfile.schema.fixedwidth.FlatFileStructureParser
import com.mulesoft.flatfile.schema.model.Copybook
import com.mulesoft.flatfile.schema.model.EdiSchemaVersion
import com.mulesoft.flatfile.schema.model.Structure
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.module.DataFormat
import org.mule.weave.v2.module.flatfile.values.FlatArrayValue
import org.mule.weave.v2.module.flatfile.values.FlatLocation
import org.mule.weave.v2.module.flatfile.values.FlatObjectValue
import org.mule.weave.v2.module.reader.Reader
import org.mule.weave.v2.module.reader.SourceProvider
import org.mule.weave.v2.module.reader.SourceProviderAwareReader

import java.{ util => ju }

class FlatFileReader(override val sourceProvider: SourceProvider, val settings: FlatFileReaderSettings, structOverride: Option[Structure] = None)(implicit ctx: EvaluationContext) extends Reader with SourceProviderAwareReader {

  var rootValue: Value[_] = _

  override def dataFormat: Option[DataFormat[_, _]] = Some(new FlatFileDataFormat)

  /** Build reader configuration based on settings and schema defaults. */
  private def buildConfig(version: EdiSchemaVersion): FlatFileParserConfig = {
    val defaultChar: Int = version.ediForm match {
      case Copybook => 0
      case _        => ' '
    }
    val missingChar = settings.missingValueCharacter(defaultChar)
    val (terminated, flexible) = settings.recordParsingFlags
    FlatFileParserConfig(settings.enforceRequires, terminated, flexible, flexible, missingChar, settings.zonedDecimalStrict,
      !settings.truncateDependingOn, settings.useMissCharAsDefaultForFill, settings.allowLenientWithBinaryNotEndElement,
      settings.retainEmptyStringFieldsOnParsing, settings.substituteCharacterAsMissingValue)
  }

  def ffParser: FlatFileParserBase = {
    val in = sourceProvider.asInputStream
    structOverride match {

      case Some(s) => new FlatFileStructureParser(in, sourceProvider.charset, s, buildConfig(s.version))

      case None =>
        val schema = settings.loadedSchema
        val config = buildConfig(schema.ediVersion)
        settings.getStructure(schema) match {
          case Some(s) => new FlatFileStructureParser(in, sourceProvider.charset, s, config)
          case None =>
            settings.getSegment(schema) match {
              case Some(s) => new FlatFileSegmentParser(in, sourceProvider.charset, s, config)
              case None    => throw new IllegalStateException("Need to specify structureIdent or schemaIdent in reader configuration")
            }
        }
    }
  }

  override protected def doRead(name: String): Value[_] = {
    if (rootValue == null) {
      val result = ffParser.parse.get.asInstanceOf[java.util.Map[Any, Any]]
      val data = result.get("Data")
      data match {
        case m: ju.Map[Any, Any] => rootValue = new FlatObjectValue(new FlatLocation("", ""), m)
        case l: ju.List[_]       => rootValue = new FlatArrayValue(new FlatLocation("", ""), l)
      }
    }
    rootValue
  }

}
