package org.mule.weave.v2.module.flatfile.values

import com.mulesoft.flatfile.schema.fixedwidth.DynamicData
import com.mulesoft.flatfile.schema.model.FixedCompositeComponent
import com.mulesoft.flatfile.schema.model.FixedElementComponent
import org.mule.weave.v2.model.structure.KeyValuePair

class DynamicDataKeyValuePairIterator(loc: FlatLocation, data: DynamicData, start: Int, comp: FixedCompositeComponent) extends Iterator[KeyValuePair] {

  import org.mule.weave.v2.module.flatfile.values.DynamicSupport.loadElement

  val it = comp.composite.components.map(_.key).iterator
  var index = 0

  override def hasNext: Boolean = it.hasNext

  private def keyPair(key: String): KeyValuePair = {
    val (offset, subcomp) = comp.wrappedComponents(key)
    val base = start + offset
    val subloc = loc.child(key)
    val ffKey = new FlatKeyValue(key, subloc)
    val value = subcomp match {
      case e: FixedElementComponent =>
        if (e.count == 1) loadElement(e, data, base, subloc)
        else new DynamicArrayValue(subloc, data, base, e)
      case c: FixedCompositeComponent =>
        if (c.count == 1) new DynamicObjectValue(subloc, data, base, c)
        else new DynamicArrayValue(subloc, data, base, c)
    }
    KeyValuePair(ffKey, value)
  }

  override def next: KeyValuePair = {
    val result = keyPair(it.next)
    index = index + 1
    result
  }

  private def simpleValue(key: String): FlatValue = {
    val (offset, subcomp) = comp.wrappedComponents(key)
    subcomp match {
      case e: FixedElementComponent =>
        if (e.count == 1) loadElement(e, data, start + offset, loc)
        else new DynamicArrayValue(loc, data, start, e)
      case c: FixedCompositeComponent =>
        if (c.count == 1) new DynamicObjectValue(loc, data, start + offset, c)
        else new DynamicArrayValue(loc, data, start + offset, c)
    }
  }

}