package org.mule.weave.v2.module.flatfile.values

import java.io.ByteArrayInputStream

import com.mulesoft.flatfile.lexical.FlatFileLexer
import com.mulesoft.flatfile.schema.fixedwidth.DynamicData
import com.mulesoft.flatfile.schema.model.FixedElementComponent

object DynamicSupport {
  def loadElement(e: FixedElementComponent, data: DynamicData, start: Int, loc: FlatLocation) = {
    val format = e.element.typeFormat
    val raw = format.typeCode == "Binary" || format.typeCode == "Packed"
    val lexer = FlatFileLexer.getRecordParsingImpl(new ByteArrayInputStream(data.bytes), data.charset, raw, false, false, false,
      -1, true, data.zonedPos, data.zonedNeg)
    lexer.load(start, 1)
    lexer.load(format.maxLength, 1)
    val result = format.parse(lexer)
    //    println(s" Loaded value at $loc with start $start for component ${e.name}: $result")
    FlatValue(result, loc)
  }
}
