package org.mule.weave.v2.module.flatfile.values

import java.{ util => ju }
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.ArraySeq
import org.mule.weave.v2.model.values.AlreadyMaterializedArrayValue
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.parser.location.Location

class FlatArrayValue(loc: FlatLocation, list: ju.List[_]) extends AlreadyMaterializedArrayValue with FlatValue {

  override def evaluate(implicit ctx: EvaluationContext): T = ArraySeq(new FlatFileIteratorWrapper(list.iterator))

  override def location(): Location = loc

  class FlatFileIteratorWrapper(iterator: ju.Iterator[_]) extends Iterator[Value[_]] {

    var currentIndex: Int = -1
    var currentValue: Value[_] = _

    override def size(): Int = list.size

    override def next(): Value[_] = {
      currentIndex += 1
      currentValue = FlatValue(iterator.next, loc.child(currentIndex))
      currentValue
    }

    override def hasNext: Boolean = iterator.hasNext

  }

}