package org.mule.weave.v2.module.flatfile.output

import java.util.AbstractSequentialList
import java.util.ListIterator

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.ArraySeq
import org.mule.weave.v2.model.values._

class SeqListFacade(base: ArraySeq)(implicit ctx: EvaluationContext) extends AbstractSequentialList[Object] {

  override def size(): Int = base.size.toInt

  override def listIterator(index: Int) = new SeqListFacadeIterator(index, base.toIterator())

}

class SeqListFacadeIterator(index: Int, base: Iterator[Value[_]])(implicit ctx: EvaluationContext) extends ListIterator[Object] {

  var nextOffset = 0

  while (nextOffset < index) base.next

  override def add(x$1: Object): Unit = throw new UnsupportedOperationException("Not modifiable")

  override def hasNext(): Boolean = base.hasNext

  override def hasPrevious(): Boolean = false

  override def next(): Object = base.next match {
    case v: Value[_]      => ConvertValue.convertValue(v)
    case null | NullValue => null
  }

  override def nextIndex(): Int = nextOffset

  override def previous(): Object = throw new UnsupportedOperationException("Cannot go backward")

  override def previousIndex(): Int = nextOffset - 1

  override def remove(): Unit = throw new UnsupportedOperationException("Not modifiable")

  override def set(x$1: Object): Unit = throw new UnsupportedOperationException("Not modifiable")
}