package org.mule.weave.v2.guava.cache.service

import com.google.common.cache.Cache
import org.mule.weave.v2.cache.service.{ Cache => DWCache }

class GuavaCache[K, V](cache: Cache[K, V], provider: Option[K => V]) extends DWCache[K, V] {

  override def get(key: K, provider: K => V): V = {
    cache.get(key, () => provider(key))
  }

  override def get(key: K): V = {
    provider match {
      case Some(provider) =>
        get(key, provider)
      case _ =>
        throw new RuntimeException("Missing provider function")
    }
  }

  override def getIfPresent(key: K): Option[V] = {
    val value = cache.getIfPresent(key)
    Option(value)
  }

  override def asMap(): java.util.Map[K, V] = cache.asMap()
}