/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.http.functions.utils;

import java.io.InputStream;
import java.io.Serializable;
import java.util.Optional;
import org.mule.weave.v2.core.io.SeekableStream;
import org.mule.weave.v2.core.util.ObjectValueUtils$;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.model.structure.KeyValuePair;
import org.mule.weave.v2.model.structure.ObjectSeq;
import org.mule.weave.v2.model.structure.ObjectSeq$;
import org.mule.weave.v2.model.structure.QualifiedName;
import org.mule.weave.v2.model.types.BinaryType$;
import org.mule.weave.v2.model.types.NullType$;
import org.mule.weave.v2.model.types.StringType$;
import org.mule.weave.v2.model.values.Value;
import org.mule.weave.v2.module.http.HttpHeader$;
import org.mule.weave.v2.module.http.functions.HttpClientRequestConfig;
import org.mule.weave.v2.module.http.functions.exceptions.DuplicatedCookieFieldException;
import org.mule.weave.v2.module.http.functions.utils.HttpClientRequestConverter$;
import org.mule.weave.v2.module.http.functions.utils.Url;
import org.mule.weave.v2.module.http.service.HttpClientHeaders;
import org.mule.weave.v2.module.http.service.HttpClientQueryParams;
import org.mule.weave.v2.module.http.service.HttpClientRequest;
import org.mule.weave.v2.parser.exception.WeaveRuntimeException;
import org.mule.weave.v2.parser.location.LocationCapable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005]b\u0001B\r\u001b\u0001-B\u0001B\r\u0001\u0003\u0002\u0003\u0006Ia\r\u0005\tw\u0001\u0011\t\u0011)A\u0005y!A\u0001\t\u0001B\u0001B\u0003%\u0011\tC\u0003I\u0001\u0011\u0005\u0011\nC\u0003P\u0001\u0011\u0005\u0001\u000bC\u0003_\u0001\u0011%q\fC\u0003h\u0001\u0011%\u0001\u000eC\u0003p\u0001\u0011%\u0001o\u0002\u0004\u00005!\u0005\u0011\u0011\u0001\u0004\u00073iA\t!a\u0001\t\r!SA\u0011AA\u0003\u0011%\t9A\u0003b\u0001\n\u0013\tI\u0001\u0003\u0005\u0002\u0018)\u0001\u000b\u0011BA\u0006\u0011%\tIB\u0003b\u0001\n\u0013\tI\u0001\u0003\u0005\u0002\u001c)\u0001\u000b\u0011BA\u0006\u0011%\tiB\u0003b\u0001\n\u0013\tI\u0001\u0003\u0005\u0002 )\u0001\u000b\u0011BA\u0006\u0011%\t\tC\u0003b\u0001\n\u0013\tI\u0001\u0003\u0005\u0002$)\u0001\u000b\u0011BA\u0006\u0011%\t)C\u0003b\u0001\n\u0013\tI\u0001\u0003\u0005\u0002()\u0001\u000b\u0011BA\u0006\u0011%\tIC\u0003b\u0001\n\u0013\tI\u0001\u0003\u0005\u0002,)\u0001\u000b\u0011BA\u0006\u0011\u001d\tiC\u0003C\u0001\u0003_\u0011!\u0004\u0013;ua\u000ec\u0017.\u001a8u%\u0016\fX/Z:u\u0007>tg/\u001a:uKJT!a\u0007\u000f\u0002\u000bU$\u0018\u000e\\:\u000b\u0005uq\u0012!\u00034v]\u000e$\u0018n\u001c8t\u0015\ty\u0002%\u0001\u0003iiR\u0004(BA\u0011#\u0003\u0019iw\u000eZ;mK*\u00111\u0005J\u0001\u0003mJR!!\n\u0014\u0002\u000b],\u0017M^3\u000b\u0005\u001dB\u0013\u0001B7vY\u0016T\u0011!K\u0001\u0004_J<7\u0001A\n\u0003\u00011\u0002\"!\f\u0019\u000e\u00039R\u0011aL\u0001\u0006g\u000e\fG.Y\u0005\u0003c9\u0012a!\u00118z%\u00164\u0017a\u0002:fcV,7\u000f\u001e\t\u0003iej\u0011!\u000e\u0006\u0003m]\n\u0011b\u001d;sk\u000e$XO]3\u000b\u0005a\u0012\u0013!B7pI\u0016d\u0017B\u0001\u001e6\u0005%y%M[3diN+\u0017/A\u0007sKF,Xm\u001d;D_:4\u0017n\u001a\t\u0003{yj\u0011\u0001H\u0005\u0003\u007fq\u0011q\u0003\u0013;ua\u000ec\u0017.\u001a8u%\u0016\fX/Z:u\u0007>tg-[4\u0002\u00111|7-\u0019;j_:\u0004\"A\u0011$\u000e\u0003\rS!\u0001\u0011#\u000b\u0005\u0015\u0013\u0013A\u00029beN,'/\u0003\u0002H\u0007\nyAj\\2bi&|gnQ1qC\ndW-\u0001\u0004=S:LGO\u0010\u000b\u0005\u00152ke\n\u0005\u0002L\u00015\t!\u0004C\u00033\t\u0001\u00071\u0007C\u0003<\t\u0001\u0007A\bC\u0003A\t\u0001\u0007\u0011)A\u0004d_:4XM\u001d;\u0015\u0003E#\"A\u0015-\u0011\u0005M3V\"\u0001+\u000b\u0005Us\u0012aB:feZL7-Z\u0005\u0003/R\u0013\u0011\u0003\u0013;ua\u000ec\u0017.\u001a8u%\u0016\fX/Z:u\u0011\u0015IV\u0001q\u0001[\u0003\r\u0019G\u000f\u001f\t\u00037rk\u0011aN\u0005\u0003;^\u0012\u0011#\u0012<bYV\fG/[8o\u0007>tG/\u001a=u\u0003))\u0007\u0010\u001e:bGR,&\u000f\u001c\u000b\u0004A\u00164GCA1e!\tY%-\u0003\u0002d5\t\u0019QK\u001d7\t\u000be3\u00019\u0001.\t\u000bI2\u0001\u0019A\u001a\t\u000b\u00013\u0001\u0019A!\u0002\u001d\u0015DHO]1di\"+\u0017\rZ3sgR\u0011\u0011N\u001c\u000b\u0003U6\u0004\"aU6\n\u00051$&!\u0005%uiB\u001cE.[3oi\"+\u0017\rZ3sg\")\u0011l\u0002a\u00025\")!g\u0002a\u0001g\u0005YQ\r\u001f;sC\u000e$(i\u001c3z)\t\th\u0010\u0006\u0002s{B\u0019Qf];\n\u0005Qt#AB(qi&|g\u000e\u0005\u0002ww6\tqO\u0003\u0002ys\u0006\u0011\u0011n\u001c\u0006\u0002u\u0006!!.\u0019<b\u0013\taxOA\u0006J]B,Ho\u0015;sK\u0006l\u0007\"B-\t\u0001\bQ\u0006\"\u0002\u001a\t\u0001\u0004\u0019\u0014A\u0007%uiB\u001cE.[3oiJ+\u0017/^3ti\u000e{gN^3si\u0016\u0014\bCA&\u000b'\tQA\u0006\u0006\u0002\u0002\u0002\u00051Q*\u0012+I\u001f\u0012+\"!a\u0003\u0011\t\u00055\u00111C\u0007\u0003\u0003\u001fQ1!!\u0005z\u0003\u0011a\u0017M\\4\n\t\u0005U\u0011q\u0002\u0002\u0007'R\u0014\u0018N\\4\u0002\u000f5+E\u000bS(EA\u0005\u0019QK\u0015'\u0002\tU\u0013F\nI\u0001\r#V+%+W0Q\u0003J\u000bUjU\u0001\u000e#V+%+W0Q\u0003J\u000bUj\u0015\u0011\u0002\u000f!+\u0015\tR#S'\u0006A\u0001*R!E\u000bJ\u001b\u0006%\u0001\u0003C\u001f\u0012K\u0016!\u0002\"P\tf\u0003\u0013aB\"P\u001f.KUiU\u0001\t\u0007>{5*S#TA\u0005)\u0011\r\u001d9msR9!*!\r\u00024\u0005U\u0002\"\u0002\u001a\u0019\u0001\u0004\u0019\u0004\"B\u001e\u0019\u0001\u0004a\u0004\"\u0002!\u0019\u0001\u0004\t\u0005")
public class HttpClientRequestConverter {
    private final ObjectSeq request;
    private final HttpClientRequestConfig requestConfig;
    private final LocationCapable location;

    public static HttpClientRequestConverter apply(ObjectSeq objectSeq, HttpClientRequestConfig httpClientRequestConfig, LocationCapable locationCapable) {
        return HttpClientRequestConverter$.MODULE$.apply(objectSeq, httpClientRequestConfig, locationCapable);
    }

    public HttpClientRequest convert(EvaluationContext ctx) {
        Object object;
        Object object2;
        String method = (String)ObjectValueUtils$.MODULE$.selectString(this.request, HttpClientRequestConverter$.MODULE$.org$mule$weave$v2$module$http$functions$utils$HttpClientRequestConverter$$METHOD(), ctx).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new WeaveRuntimeException(new StringBuilder(16).append("Missing '").append(HttpClientRequestConverter$.MODULE$.org$mule$weave$v2$module$http$functions$utils$HttpClientRequestConverter$$METHOD()).append("' value").toString(), $this.location.location());
        });
        HttpClientRequest.Builder builder = new HttpClientRequest.Builder().setMethod(method);
        Url url = this.extractUrl(this.request, this.location, ctx);
        builder.setUrl(url.url());
        url.queryParams().foreach((Function1 & Serializable & scala.Serializable)queryParam -> builder.addQueryParam((HttpClientQueryParams.HttpQueryParam)queryParam));
        HttpClientHeaders httpClientHeaders = this.extractHeaders(this.request, ctx);
        httpClientHeaders.getHeaders().forEach(header -> builder.addHeader((HttpClientHeaders.HttpHeader)header));
        Optional<String> maybeCookieHeader = httpClientHeaders.firstValueIgnoreCase(HttpHeader$.MODULE$.COOKIE_HEADER());
        Seq cookiesValue = ((ObjectSeq)ObjectValueUtils$.MODULE$.selectObject(this.request, HttpClientRequestConverter$.MODULE$.org$mule$weave$v2$module$http$functions$utils$HttpClientRequestConverter$$COOKIES(), ctx).getOrElse((Function0 & Serializable & scala.Serializable)() -> ObjectSeq$.MODULE$.empty())).toSeq(ctx);
        if (maybeCookieHeader.isPresent() && new StringOps(Predef$.MODULE$.augmentString(maybeCookieHeader.get())).nonEmpty() && cookiesValue.nonEmpty()) {
            throw new DuplicatedCookieFieldException(this.location.location());
        }
        if (cookiesValue.nonEmpty()) {
            String cookieValue = ((TraversableOnce)cookiesValue.map((Function1 & Serializable & scala.Serializable)kvp -> {
                String name = ((QualifiedName)kvp._1().evaluate(ctx)).name();
                String value = StringType$.MODULE$.coerce(kvp._2(), ctx).evaluate(ctx).toString();
                return new StringBuilder(1).append(name).append("=").append(value).toString();
            }, Seq$.MODULE$.canBuildFrom())).mkString(";");
            object2 = builder.addHeader(HttpHeader$.MODULE$.COOKIE_HEADER(), cookieValue);
        } else {
            object2 = BoxedUnit.UNIT;
        }
        Option<InputStream> maybeBody = this.extractBody(this.request, ctx);
        if (maybeBody.isDefined()) {
            InputStream body = (InputStream)maybeBody.get();
            object = builder.setBody(body);
        } else {
            object = BoxedUnit.UNIT;
        }
        builder.setFollowRedirect(this.requestConfig.followRedirects());
        Object object3 = this.requestConfig.readTimeout().isDefined() ? builder.setReadTimeout(BoxesRunTime.unboxToInt((Object)this.requestConfig.readTimeout().get())) : BoxedUnit.UNIT;
        Object object4 = this.requestConfig.requestTimeout().isDefined() ? builder.setRequestTimeout(BoxesRunTime.unboxToInt((Object)this.requestConfig.requestTimeout().get())) : BoxedUnit.UNIT;
        return builder.build();
    }

    private Url extractUrl(ObjectSeq request, LocationCapable location, EvaluationContext ctx) {
        Value urlValue = (Value)ObjectValueUtils$.MODULE$.select(request, HttpClientRequestConverter$.MODULE$.org$mule$weave$v2$module$http$functions$utils$HttpClientRequestConverter$$URL(), ctx).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new WeaveRuntimeException(new StringBuilder(16).append("Missing '").append(HttpClientRequestConverter$.MODULE$.org$mule$weave$v2$module$http$functions$utils$HttpClientRequestConverter$$URL()).append("' value").toString(), location.location());
        });
        Object object = urlValue.evaluate(ctx);
        if (object instanceof CharSequence) {
            CharSequence charSequence = (CharSequence)object;
            return new Url(((Object)charSequence).toString(), (Seq<HttpClientQueryParams.HttpQueryParam>)((Seq)Nil$.MODULE$));
        }
        if (object instanceof ObjectSeq) {
            ObjectSeq objectSeq = (ObjectSeq)object;
            ObjectRef queryParams = ObjectRef.create((Object)((Seq)Nil$.MODULE$));
            ObjectSeq urlObjectSeq = objectSeq.materialize(ctx);
            ObjectSeq queryParamsValue = (ObjectSeq)ObjectValueUtils$.MODULE$.selectObject(urlObjectSeq, HttpClientRequestConverter$.MODULE$.org$mule$weave$v2$module$http$functions$utils$HttpClientRequestConverter$$QUERY_PARAMS(), ctx).getOrElse((Function0 & Serializable & scala.Serializable)() -> ObjectSeq$.MODULE$.empty());
            String url = (String)ObjectValueUtils$.MODULE$.selectString(urlObjectSeq, HttpClientRequestConverter$.MODULE$.org$mule$weave$v2$module$http$functions$utils$HttpClientRequestConverter$$URL(), ctx).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new WeaveRuntimeException(new StringBuilder(16).append("Missing '").append(HttpClientRequestConverter$.MODULE$.org$mule$weave$v2$module$http$functions$utils$HttpClientRequestConverter$$URL()).append("' value").toString(), location.location());
            });
            queryParamsValue.toSeq(ctx).foreach((Function1 & Serializable & scala.Serializable)kvp -> {
                HttpClientRequestConverter.$anonfun$extractUrl$4(ctx, queryParams, kvp);
                return BoxedUnit.UNIT;
            });
            return new Url(url, (Seq<HttpClientQueryParams.HttpQueryParam>)((Seq)queryParams.elem));
        }
        throw new MatchError(object);
    }

    private HttpClientHeaders extractHeaders(ObjectSeq request, EvaluationContext ctx) {
        HttpClientHeaders.Builder builder = new HttpClientHeaders.Builder();
        ObjectSeq headersValue = (ObjectSeq)ObjectValueUtils$.MODULE$.selectObject(request, HttpClientRequestConverter$.MODULE$.org$mule$weave$v2$module$http$functions$utils$HttpClientRequestConverter$$HEADERS(), ctx).getOrElse((Function0 & Serializable & scala.Serializable)() -> ObjectSeq$.MODULE$.empty());
        headersValue.toSeq(ctx).foreach((Function1 & Serializable & scala.Serializable)kvp -> {
            String name = ((QualifiedName)kvp._1().evaluate(ctx)).name();
            String value = StringType$.MODULE$.coerce(kvp._2(), ctx).evaluate(ctx).toString();
            return builder.addHeader(name, value);
        });
        return builder.build();
    }

    private Option<InputStream> extractBody(ObjectSeq request, EvaluationContext ctx) {
        Option bodyValue = ObjectValueUtils$.MODULE$.select(request, HttpClientRequestConverter$.MODULE$.org$mule$weave$v2$module$http$functions$utils$HttpClientRequestConverter$$BODY(), ctx);
        return bodyValue.flatMap((Function1 & Serializable & scala.Serializable)body -> {
            Value value = body;
            if (NullType$.MODULE$.accepts(value, ctx)) {
                return None$.MODULE$;
            }
            if (BinaryType$.MODULE$.accepts(value, ctx)) {
                return new Some((Object)((SeekableStream)BinaryType$.MODULE$.coerce(body, ctx).evaluate(ctx)).spinOff(ctx));
            }
            return None$.MODULE$;
        });
    }

    public static final /* synthetic */ void $anonfun$extractUrl$4(EvaluationContext ctx$2, ObjectRef queryParams$1, KeyValuePair kvp) {
        String name = ((QualifiedName)kvp._1().evaluate(ctx$2)).name();
        String value = StringType$.MODULE$.coerce(kvp._2(), ctx$2).evaluate(ctx$2).toString();
        queryParams$1.elem = (Seq)((Seq)queryParams$1.elem).$colon$plus((Object)new HttpClientQueryParams.HttpQueryParam(name, value), Seq$.MODULE$.canBuildFrom());
    }

    public HttpClientRequestConverter(ObjectSeq request, HttpClientRequestConfig requestConfig, LocationCapable location) {
        this.request = request;
        this.requestConfig = requestConfig;
        this.location = location;
    }
}

