/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.http.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class HttpClientQueryParams {
    private final List<HttpQueryParam> queryParams;

    public HttpClientQueryParams(List<HttpQueryParam> queryParams) {
        this.queryParams = queryParams;
    }

    public List<HttpQueryParam> getQueryParams() {
        return Collections.unmodifiableList(this.queryParams);
    }

    public Set<String> names() {
        return this.queryParams.stream().map(HttpQueryParam::getName).collect(Collectors.toSet());
    }

    public Set<String> namesIgnoreCase() {
        TreeSet<String> names = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        this.queryParams.forEach(queryParam -> names.add(queryParam.getName()));
        return names;
    }

    public List<String> allValues(String name) {
        return this.queryParams.stream().filter(h -> h.getName().equals(name)).map(HttpQueryParam::getValue).collect(Collectors.toList());
    }

    public List<String> allValuesIgnoreCase(String name) {
        return this.queryParams.stream().filter(h -> h.getName().equalsIgnoreCase(name)).map(HttpQueryParam::getValue).collect(Collectors.toList());
    }

    public static class HttpQueryParam {
        private final String name;
        private final String value;

        public HttpQueryParam(String name, String value) {
            Objects.requireNonNull(name, "name must not be null");
            Objects.requireNonNull(value, "value must not be null");
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public static HttpQueryParam of(String name, String value) {
            return new HttpQueryParam(name, value);
        }
    }

    public static class Builder {
        private final List<HttpQueryParam> queryParams = new ArrayList<HttpQueryParam>();

        public Builder addQueryParam(String name, String value) {
            Objects.requireNonNull(name, "name cannot be null");
            Objects.requireNonNull(value, "value cannot be null");
            return this.addQueryParam(HttpQueryParam.of(name, value));
        }

        public Builder addQueryParam(HttpQueryParam queryParam) {
            Objects.requireNonNull(queryParam, "queryParam cannot be null");
            this.queryParams.add(queryParam);
            return this;
        }

        public HttpClientQueryParams build() {
            return new HttpClientQueryParams(this.queryParams);
        }
    }
}

