/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.http.service;

import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import org.mule.weave.v2.module.http.service.HttpClientHeaders;
import org.mule.weave.v2.module.http.service.HttpClientQueryParams;

public class HttpClientRequest {
    private final String url;
    private final String method;
    private final HttpClientHeaders headers;
    private final HttpClientQueryParams queryParams;
    private final InputStream body;
    private final boolean followRedirects;
    private final int readTimeout;
    private final int requestTimeout;
    private final boolean streamResponse;
    private final boolean enableMetrics;

    private HttpClientRequest(String url, String method, HttpClientHeaders headers, HttpClientQueryParams queryParams, InputStream body, boolean followRedirects, int readTimeout, int requestTimeout, boolean streamResponse, boolean enableMetrics) {
        this.url = url;
        this.method = method;
        this.headers = headers;
        this.queryParams = queryParams;
        this.body = body;
        this.followRedirects = followRedirects;
        this.readTimeout = readTimeout;
        this.requestTimeout = requestTimeout;
        this.streamResponse = streamResponse;
        this.enableMetrics = enableMetrics;
    }

    public String getUrl() {
        return this.url;
    }

    public String getMethod() {
        return this.method;
    }

    public HttpClientHeaders getHeaders() {
        return this.headers;
    }

    public HttpClientQueryParams getQueryParams() {
        return this.queryParams;
    }

    public InputStream getBody() {
        return this.body;
    }

    public boolean isFollowRedirects() {
        return this.followRedirects;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public int getRequestTimeout() {
        return this.requestTimeout;
    }

    public boolean isStreamResponse() {
        return this.streamResponse;
    }

    public boolean isEnableMetrics() {
        return this.enableMetrics;
    }

    public static final class Builder {
        private String url;
        private String method;
        private final HttpClientHeaders.Builder headersBuilder = new HttpClientHeaders.Builder();
        private final HttpClientQueryParams.Builder queryParamsBuilder = new HttpClientQueryParams.Builder();
        private InputStream body = null;
        private boolean followRedirects = false;
        private int readTimeout = 60000;
        private int requestTimeout = 60000;
        private boolean streamResponse = false;
        private boolean enableMetrics = false;

        public Builder setUrl(String url) {
            this.url = url;
            return this;
        }

        public Builder setMethod(String method) {
            this.method = method;
            return this;
        }

        public Builder addHeader(String name, String value) {
            Objects.requireNonNull(name, "name cannot be null");
            Objects.requireNonNull(value, "value cannot be null");
            this.headersBuilder.addHeader(name, value);
            return this;
        }

        public Builder addHeader(HttpClientHeaders.HttpHeader header) {
            Objects.requireNonNull(header, "header cannot be null");
            this.headersBuilder.addHeader(header);
            return this;
        }

        public Builder addHeaders(String name, List<String> values) {
            Objects.requireNonNull(name, "name cannot be null");
            Objects.requireNonNull(values, "values cannot be null");
            values.forEach(value -> this.headersBuilder.addHeader(name, (String)value));
            return this;
        }

        public Builder addQueryParam(String name, String value) {
            Objects.requireNonNull(name, "name cannot be null");
            Objects.requireNonNull(value, "value cannot be null");
            this.queryParamsBuilder.addQueryParam(name, value);
            return this;
        }

        public Builder addQueryParam(HttpClientQueryParams.HttpQueryParam queryParam) {
            Objects.requireNonNull(queryParam, "queryParam cannot be null");
            this.queryParamsBuilder.addQueryParam(queryParam);
            return this;
        }

        public Builder setBody(InputStream body) {
            Objects.requireNonNull(body, "body cannot be null");
            this.body = body;
            return this;
        }

        public Builder setFollowRedirect(boolean followRedirects) {
            this.followRedirects = followRedirects;
            return this;
        }

        public Builder setReadTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public Builder setRequestTimeout(int requestTimeout) {
            this.requestTimeout = requestTimeout;
            return this;
        }

        public Builder setStreamResponse(boolean streamResponse) {
            this.streamResponse = streamResponse;
            return this;
        }

        public Builder setEnableMetrics(boolean enableMetrics) {
            this.enableMetrics = enableMetrics;
            return this;
        }

        public HttpClientRequest build() {
            Objects.requireNonNull(this.url, "http client request 'url' must not be null");
            Objects.requireNonNull(this.method, "http client request 'method' must not be null");
            return new HttpClientRequest(this.url, this.method, this.headersBuilder.build(), this.queryParamsBuilder.build(), this.body, this.followRedirects, this.readTimeout, this.requestTimeout, this.streamResponse, this.enableMetrics);
        }
    }
}

