/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.http.functions.utils;

import java.io.InputStream;
import java.io.Serializable;
import java.net.HttpCookie;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.mule.weave.v2.core.io.SeekableStream$;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.model.structure.KeyValuePair;
import org.mule.weave.v2.model.structure.KeyValuePair$;
import org.mule.weave.v2.model.structure.schema.Schema;
import org.mule.weave.v2.model.values.BinaryValue$;
import org.mule.weave.v2.model.values.KeyValue$;
import org.mule.weave.v2.model.values.NumberValue$;
import org.mule.weave.v2.model.values.ObjectValue;
import org.mule.weave.v2.model.values.ObjectValue$;
import org.mule.weave.v2.model.values.ObjectValueBuilder;
import org.mule.weave.v2.model.values.StringValue$;
import org.mule.weave.v2.model.values.Value;
import org.mule.weave.v2.model.values.math.Number$;
import org.mule.weave.v2.module.http.functions.utils.HttpClientResponseConverter$;
import org.mule.weave.v2.module.http.functions.utils.HttpClientResponseCookieConverter;
import org.mule.weave.v2.module.http.functions.utils.MetadataConverter$;
import org.mule.weave.v2.module.http.functions.utils.StopWatch;
import org.mule.weave.v2.module.http.service.HttpClientHeaders;
import org.mule.weave.v2.module.http.service.HttpClientResponse;
import org.mule.weave.v2.module.reader.SourceProvider;
import org.mule.weave.v2.module.reader.SourceProvider$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Set$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005f\u0001B\u0011#\u0001MB\u0001B\u000f\u0001\u0003\u0002\u0003\u0006Ia\u000f\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005\u0005\")a\t\u0001C\u0001\u000f\"91\n\u0001b\u0001\n\u0013a\u0005BB+\u0001A\u0003%Q\nC\u0004W\u0001\t\u0007I\u0011B,\t\rm\u0003\u0001\u0015!\u0003Y\u0011\u001da\u0006A1A\u0005\n]Ca!\u0018\u0001!\u0002\u0013A\u0006b\u00020\u0001\u0005\u0004%Ia\u0016\u0005\u0007?\u0002\u0001\u000b\u0011\u0002-\t\u000b\u0001\u0004A\u0011A1\t\u000bE\u0004A\u0011\u0002:\t\u000f\u0005=\u0001\u0001\"\u0003\u0002\u0012!9\u0011\u0011\b\u0001\u0005\n\u0005m\u0002bBA4\u0001\u0011%\u0011\u0011N\u0004\b\u0003s\u0012\u0003\u0012AA>\r\u0019\t#\u0005#\u0001\u0002~!1aI\u0005C\u0001\u0003\u007fB\u0001\"!!\u0013\u0005\u0004%I\u0001\u0014\u0005\b\u0003\u0007\u0013\u0002\u0015!\u0003N\u0011!\t)I\u0005b\u0001\n\u0013a\u0005bBAD%\u0001\u0006I!\u0014\u0005\t\u0003\u0013\u0013\"\u0019!C\u0005\u0019\"9\u00111\u0012\n!\u0002\u0013i\u0005\u0002CAG%\t\u0007I\u0011\u0002'\t\u000f\u0005=%\u0003)A\u0005\u001b\"A\u0011\u0011\u0013\nC\u0002\u0013%A\nC\u0004\u0002\u0014J\u0001\u000b\u0011B'\t\u0011\u0005U%C1A\u0005\n1Cq!a&\u0013A\u0003%Q\nC\u0004\u0002\u001aJ!\t!a'\u00037!#H\u000f]\"mS\u0016tGOU3ta>t7/Z\"p]Z,'\u000f^3s\u0015\t\u0019C%A\u0003vi&d7O\u0003\u0002&M\u0005Ia-\u001e8di&|gn\u001d\u0006\u0003O!\nA\u0001\u001b;ua*\u0011\u0011FK\u0001\u0007[>$W\u000f\\3\u000b\u0005-b\u0013A\u0001<3\u0015\tic&A\u0003xK\u00064XM\u0003\u00020a\u0005!Q.\u001e7f\u0015\u0005\t\u0014aA8sO\u000e\u00011C\u0001\u00015!\t)\u0004(D\u00017\u0015\u00059\u0014!B:dC2\f\u0017BA\u001d7\u0005\u0019\te.\u001f*fM\u0006A!/Z:q_:\u001cX\r\u0005\u0002=\u007f5\tQH\u0003\u0002?M\u000591/\u001a:wS\u000e,\u0017B\u0001!>\u0005IAE\u000f\u001e9DY&,g\u000e\u001e*fgB|gn]3\u0002\u0013M$x\u000e],bi\u000eD\u0007CA\"E\u001b\u0005\u0011\u0013BA##\u0005%\u0019Fo\u001c9XCR\u001c\u0007.\u0001\u0004=S:LGO\u0010\u000b\u0004\u0011&S\u0005CA\"\u0001\u0011\u0015Q4\u00011\u0001<\u0011\u0015\t5\u00011\u0001C\u0003U\u0019uJ\u0014+F\u001dR{F*\u0012(H)\"{\u0006*R!E\u000bJ+\u0012!\u0014\t\u0003\u001dNk\u0011a\u0014\u0006\u0003!F\u000bA\u0001\\1oO*\t!+\u0001\u0003kCZ\f\u0017B\u0001+P\u0005\u0019\u0019FO]5oO\u000612i\u0014(U\u000b:#v\fT#O\u000fRCu\fS#B\t\u0016\u0013\u0006%\u0001\fO\u001f~\u001buJ\u0014+F\u001dR{6\u000bV!U+N{6i\u0014#F+\u0005A\u0006CA\u001bZ\u0013\tQfGA\u0002J]R\fqCT(`\u0007>sE+\u0012(U?N#\u0016\tV+T?\u000e{E)\u0012\u0011\u000219{EkX'P\t&3\u0015*\u0012#`'R\u000bE+V*`\u0007>#U)A\rO\u001fR{Vj\u0014#J\r&+EiX*U\u0003R+6kX\"P\t\u0016\u0003\u0013!\u0007*F'\u0016#vlQ(O)\u0016sEkX*U\u0003R+6kX\"P\t\u0016\u000b!DU#T\u000bR{6i\u0014(U\u000b:#vl\u0015+B)V\u001bvlQ(E\u000b\u0002\nqaY8om\u0016\u0014H\u000fF\u0001c)\t\u00197\u000e\u0005\u0002eS6\tQM\u0003\u0002gO\u00061a/\u00197vKNT!\u0001\u001b\u0016\u0002\u000b5|G-\u001a7\n\u0005),'aC(cU\u0016\u001cGOV1mk\u0016DQ\u0001\u001c\u0007A\u00045\f1a\u0019;y!\tqw.D\u0001h\u0013\t\u0001xMA\tFm\u0006dW/\u0019;j_:\u001cuN\u001c;fqR\fa\"Y:IK\u0006$WM]:WC2,X\rF\u0002t\u0003\u000b\u0001$\u0001^=\u0011\u0007\u0011,x/\u0003\u0002wK\n)a+\u00197vKB\u0011\u00010\u001f\u0007\u0001\t%QX\"!A\u0001\u0002\u000b\u00051PA\u0002`IE\n\"\u0001`@\u0011\u0005Uj\u0018B\u0001@7\u0005\u001dqu\u000e\u001e5j]\u001e\u00042!NA\u0001\u0013\r\t\u0019A\u000e\u0002\u0004\u0003:L\bbBA\u0004\u001b\u0001\u0007\u0011\u0011B\u0001\bQ\u0016\fG-\u001a:t!\ra\u00141B\u0005\u0004\u0003\u001bi$!\u0005%uiB\u001cE.[3oi\"+\u0017\rZ3sg\u0006i\u0011m]\"p_.LWMV1mk\u0016$B!a\u0005\u0002\u001eA\"\u0011QCA\r!\u0011!W/a\u0006\u0011\u0007a\fI\u0002\u0002\u0006\u0002\u001c9\t\t\u0011!A\u0003\u0002m\u00141a\u0018\u00133\u0011\u001d\tyB\u0004a\u0001\u0003C\tqaY8pW&,7\u000f\u0005\u0004\u0002$\u0005%\u0012QF\u0007\u0003\u0003KQ1!a\nR\u0003\u0011)H/\u001b7\n\t\u0005-\u0012Q\u0005\u0002\u0005\u0019&\u001cH\u000f\u0005\u0003\u00020\u0005URBAA\u0019\u0015\r\t\u0019$U\u0001\u0004]\u0016$\u0018\u0002BA\u001c\u0003c\u0011!\u0002\u0013;ua\u000e{wn[5f\u0003\u001d\tG\r\u001a\"pIf$\"\"!\u0010\u0002H\u0005]\u00131LA/)\u0011\ty$!\u0012\u0011\u0007U\n\t%C\u0002\u0002DY\u0012A!\u00168ji\")An\u0004a\u0002[\"9\u0011\u0011J\bA\u0002\u0005-\u0013\u0001\u00022pIf\u0004B!!\u0014\u0002T5\u0011\u0011q\n\u0006\u0004\u0003#\n\u0016AA5p\u0013\u0011\t)&a\u0014\u0003\u0017%s\u0007/\u001e;TiJ,\u0017-\u001c\u0005\u0007\u00033z\u0001\u0019\u0001-\u0002\u0015M$\u0018\r^;t\u0007>$W\rC\u0004\u0002\b=\u0001\r!!\u0003\t\u000f\u0005}s\u00021\u0001\u0002b\u00059!-^5mI\u0016\u0014\bc\u00013\u0002d%\u0019\u0011QM3\u0003%=\u0013'.Z2u-\u0006dW/\u001a\"vS2$WM]\u0001\u0015Kb$(/Y2u\u0007>tG/\u001a8u\u0019\u0016tw\r\u001e5\u0015\t\u0005-\u0014q\u000f\t\u0006k\u00055\u0014\u0011O\u0005\u0004\u0003_2$AB(qi&|g\u000eE\u00026\u0003gJ1!!\u001e7\u0005\u0011auN\\4\t\u000f\u0005\u001d\u0001\u00031\u0001\u0002\n\u0005Y\u0002\n\u001e;q\u00072LWM\u001c;SKN\u0004xN\\:f\u0007>tg/\u001a:uKJ\u0004\"a\u0011\n\u0014\u0005I!DCAA>\u0003\u0019\u0019F+\u0011+V'\u000691\u000bV!U+N\u0003\u0013aC*U\u0003R+6k\u0018+F1R\u000bAb\u0015+B)V\u001bv\fV#Y)\u0002\nq\u0001S#B\t\u0016\u00136+\u0001\u0005I\u000b\u0006#UIU*!\u0003\u0011\u0011u\nR-\u0002\u000b\t{E)\u0017\u0011\u0002\u000f\r{ujS%F'\u0006A1iT(L\u0013\u0016\u001b\u0006%\u0001\u0007D\u001f:#VI\u0014+`)f\u0003V)A\u0007D\u001f:#VI\u0014+`)f\u0003V\tI\u0001\u0006CB\u0004H.\u001f\u000b\u0006\u0011\u0006u\u0015q\u0014\u0005\u0006u\u0001\u0002\ra\u000f\u0005\u0006\u0003\u0002\u0002\rA\u0011")
public class HttpClientResponseConverter {
    private final HttpClientResponse response;
    private final StopWatch stopWatch;
    private final String CONTENT_LENGTH_HEADER;
    private final int NO_CONTENT_STATUS_CODE;
    private final int NOT_MODIFIED_STATUS_CODE;
    private final int RESET_CONTENT_STATUS_CODE;

    public static HttpClientResponseConverter apply(HttpClientResponse httpClientResponse, StopWatch stopWatch) {
        return HttpClientResponseConverter$.MODULE$.apply(httpClientResponse, stopWatch);
    }

    private String CONTENT_LENGTH_HEADER() {
        return this.CONTENT_LENGTH_HEADER;
    }

    private int NO_CONTENT_STATUS_CODE() {
        return this.NO_CONTENT_STATUS_CODE;
    }

    private int NOT_MODIFIED_STATUS_CODE() {
        return this.NOT_MODIFIED_STATUS_CODE;
    }

    private int RESET_CONTENT_STATUS_CODE() {
        return this.RESET_CONTENT_STATUS_CODE;
    }

    public ObjectValue convert(EvaluationContext ctx) {
        ObjectValueBuilder builder = new ObjectValueBuilder();
        builder.addPair(HttpClientResponseConverter$.MODULE$.org$mule$weave$v2$module$http$functions$utils$HttpClientResponseConverter$$STATUS(), (Value)NumberValue$.MODULE$.apply(Number$.MODULE$.apply(this.response.getStatus())));
        this.response.getStatusText().ifPresent(st -> builder.addPair(HttpClientResponseConverter$.MODULE$.org$mule$weave$v2$module$http$functions$utils$HttpClientResponseConverter$$STATUS_TEXT(), (Value)StringValue$.MODULE$.apply(st)));
        builder.addPair(HttpClientResponseConverter$.MODULE$.org$mule$weave$v2$module$http$functions$utils$HttpClientResponseConverter$$HEADERS(), this.asHeadersValue(this.response.getHeaders()));
        this.response.getBody().ifPresent(body -> this.addBody((InputStream)body, $this.response.getStatus(), $this.response.getHeaders(), builder, ctx));
        builder.addPair(HttpClientResponseConverter$.MODULE$.org$mule$weave$v2$module$http$functions$utils$HttpClientResponseConverter$$COOKIES(), this.asCookieValue(this.response.getCookies()));
        this.response.getContentType().ifPresent(contentType -> builder.addPair(HttpClientResponseConverter$.MODULE$.org$mule$weave$v2$module$http$functions$utils$HttpClientResponseConverter$$CONTENT_TYPE(), (Value)StringValue$.MODULE$.apply(contentType)));
        this.stopWatch.stop();
        Schema schema = MetadataConverter$.MODULE$.apply(this.response.getMetadata(), this.stopWatch.getTotal()).convert();
        return builder.withSchema(schema);
    }

    private Value<?> asHeadersValue(HttpClientHeaders headers) {
        Set<String> names;
        Iterable entries = headers != null ? ((names = headers.getHeaderNames()) != null ? (Iterable)((TraversableLike)JavaConverters$.MODULE$.asScalaSetConverter(names).asScala()).flatMap((Function1 & Serializable & scala.Serializable)name -> (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(headers.getHeaderValues((String)name)).asScala()).map((Function1 & Serializable & scala.Serializable)value -> new KeyValuePair((Value)KeyValue$.MODULE$.apply(name), (Value)StringValue$.MODULE$.apply(value), KeyValuePair$.MODULE$.apply$default$3()), Buffer$.MODULE$.canBuildFrom()), Set$.MODULE$.canBuildFrom()) : (Iterable)Nil$.MODULE$) : (Iterable)Nil$.MODULE$;
        return ObjectValue$.MODULE$.apply((KeyValuePair[])entries.toArray(ClassTag$.MODULE$.apply(KeyValuePair.class)));
    }

    private Value<?> asCookieValue(List<HttpCookie> cookies) {
        Seq entries = cookies != null ? (Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(cookies).asScala()).map((Function1 & Serializable & scala.Serializable)cookie -> {
            HttpClientResponseCookieConverter converter = new HttpClientResponseCookieConverter((HttpCookie)cookie);
            return new KeyValuePair((Value)KeyValue$.MODULE$.apply(cookie.getName()), (Value)converter.convert(), KeyValuePair$.MODULE$.apply$default$3());
        }, Buffer$.MODULE$.canBuildFrom()) : (Seq)Nil$.MODULE$;
        return ObjectValue$.MODULE$.apply((KeyValuePair[])entries.toArray(ClassTag$.MODULE$.apply(KeyValuePair.class)));
    }

    private void addBody(InputStream body, int statusCode, HttpClientHeaders headers, ObjectValueBuilder builder, EvaluationContext ctx) {
        block4: {
            boolean addBodyField = true;
            Option<Object> maybeContentLength = this.extractContentLength(headers);
            if (maybeContentLength.isDefined()) {
                long contentLength = BoxesRunTime.unboxToLong((Object)maybeContentLength.get());
                if (contentLength <= 0L) {
                    addBodyField = false;
                    ctx.serviceManager().loggingService().logInfo(new StringBuilder(59).append("Ignoring HTTP response body field because ").append(this.CONTENT_LENGTH_HEADER()).append(" header value is ").append(contentLength).toString());
                }
            } else if (this.NO_CONTENT_STATUS_CODE() == statusCode || this.NOT_MODIFIED_STATUS_CODE() == statusCode || this.RESET_CONTENT_STATUS_CODE() == statusCode) {
                addBodyField = false;
                ctx.serviceManager().loggingService().logInfo(new StringBuilder(76).append("Ignoring HTTP response body field because the status: ").append(statusCode).append(" does not support body").toString());
            }
            if (!addBodyField) break block4;
            SourceProvider sourceProvider = SourceProvider$.MODULE$.apply((Object)SeekableStream$.MODULE$.apply(body, ctx));
            builder.addPair(HttpClientResponseConverter$.MODULE$.org$mule$weave$v2$module$http$functions$utils$HttpClientResponseConverter$$BODY(), (Value)BinaryValue$.MODULE$.apply(sourceProvider.asInputStream(ctx), ctx));
        }
    }

    /*
     * WARNING - void declaration
     */
    private Option<Object> extractContentLength(HttpClientHeaders headers) {
        None$ none$;
        if (headers != null) {
            Optional<String> contentLengthHeaderValues = headers.getHeaderValue(this.CONTENT_LENGTH_HEADER());
            if (contentLengthHeaderValues.isPresent()) {
                void var3_3;
                None$ contentLength = None$.MODULE$;
                try {
                    contentLength = new Some((Object)BoxesRunTime.boxToLong((long)Long.parseLong(contentLengthHeaderValues.get())));
                }
                catch (NumberFormatException numberFormatException) {}
                none$ = var3_3;
            } else {
                none$ = None$.MODULE$;
            }
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public HttpClientResponseConverter(HttpClientResponse response, StopWatch stopWatch) {
        this.response = response;
        this.stopWatch = stopWatch;
        this.CONTENT_LENGTH_HEADER = "Content-Length";
        this.NO_CONTENT_STATUS_CODE = 204;
        this.NOT_MODIFIED_STATUS_CODE = 304;
        this.RESET_CONTENT_STATUS_CODE = 205;
    }
}

