/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.http.service;

import java.io.InputStream;
import java.net.HttpCookie;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.weave.v2.module.http.service.HttpClientHeaders;
import org.mule.weave.v2.module.http.service.metadata.ObjectMetadataValue;

public interface HttpClientResponse {
    public static final String LOCATION = "Location";
    public static final String SET_COOKIE = "Set-Cookie";

    public int getStatus();

    public Optional<String> getStatusText();

    public HttpClientHeaders getHeaders();

    public Optional<String> getContentType();

    public Optional<InputStream> getBody();

    default public Optional<String> getLocation() {
        return this.getHeaders().getHeaderValues(LOCATION).stream().findFirst();
    }

    default public List<HttpCookie> getCookies() {
        return this.getHeaders().getHeaderValues(SET_COOKIE).stream().map(HttpCookie::parse).flatMap(Collection::stream).collect(Collectors.toList());
    }

    default public Optional<ObjectMetadataValue> getMetadata() {
        return Optional.empty();
    }
}

