/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.http.service;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class HttpClientRequest {
    private final String url;
    private final String method;
    private final Map<String, List<String>> headers;
    private final Map<String, List<String>> queryParams;
    private final InputStream body;
    private final boolean followRedirects;
    private final int readTimeout;
    private final int requestTimeout;

    private HttpClientRequest(String url, String method, Map<String, List<String>> headers, Map<String, List<String>> queryParams, InputStream body, boolean followRedirects, int readTimeout, int requestTimeout) {
        this.url = url;
        this.method = method;
        this.headers = headers;
        this.queryParams = queryParams;
        this.body = body;
        this.followRedirects = followRedirects;
        this.readTimeout = readTimeout;
        this.requestTimeout = requestTimeout;
    }

    public String getUrl() {
        return this.url;
    }

    public String getMethod() {
        return this.method;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public Map<String, List<String>> getQueryParams() {
        return this.queryParams;
    }

    public InputStream getBody() {
        return this.body;
    }

    public boolean isFollowRedirects() {
        return this.followRedirects;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public int getRequestTimeout() {
        return this.requestTimeout;
    }

    public static final class Builder {
        private String url;
        private String method;
        private final Map<String, List<String>> headers = new HashMap<String, List<String>>();
        private final Map<String, List<String>> queryParams = new HashMap<String, List<String>>();
        private InputStream body = null;
        private boolean followRedirects = false;
        private int readTimeout = 60000;
        private int requestTimeout = 60000;

        public Builder setUrl(String url) {
            this.url = url;
            return this;
        }

        public Builder setMethod(String method) {
            this.method = method;
            return this;
        }

        public Builder addHeader(String name, String value) {
            List values = this.headers.computeIfAbsent(name, k -> new ArrayList());
            values.add(value);
            return this;
        }

        public Builder addHeaders(String name, List<String> values) {
            this.headers.put(name, values);
            return this;
        }

        public Builder addQueryParam(String name, String value) {
            List values = this.queryParams.computeIfAbsent(name, k -> new ArrayList());
            values.add(value);
            return this;
        }

        public Builder setBody(InputStream body) {
            Objects.requireNonNull(body, "body cannot be null");
            this.body = body;
            return this;
        }

        public Builder setFollowRedirect(boolean followRedirects) {
            this.followRedirects = followRedirects;
            return this;
        }

        public Builder setReadTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public Builder setRequestTimeout(int requestTimeout) {
            this.requestTimeout = requestTimeout;
            return this;
        }

        public HttpClientRequest build() {
            Objects.requireNonNull(this.url, "http client request 'url' must not be null");
            Objects.requireNonNull(this.method, "http client request 'method' must not be null");
            return new HttpClientRequest(this.url, this.method, this.headers, this.queryParams, this.body, this.followRedirects, this.readTimeout, this.requestTimeout);
        }
    }
}

