/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.http.service;

import java.util.Objects;
import org.mule.weave.v2.module.http.service.TlsConfiguration;

public class HttpClientConfiguration {
    private final int connectionTimeout;
    private final boolean compressionHeader;
    private final boolean decompress;
    private final TlsConfiguration tlsConfiguration;

    private HttpClientConfiguration(int connectionTimeout, boolean compressionHeader, boolean decompress, TlsConfiguration tlsConfiguration) {
        this.connectionTimeout = connectionTimeout;
        this.compressionHeader = compressionHeader;
        this.decompress = decompress;
        this.tlsConfiguration = tlsConfiguration;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public boolean isCompressionHeader() {
        return this.compressionHeader;
    }

    public boolean isDecompress() {
        return this.decompress;
    }

    public TlsConfiguration getTlsConfiguration() {
        return this.tlsConfiguration;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpClientConfiguration that = (HttpClientConfiguration)o;
        return this.connectionTimeout == that.connectionTimeout && this.compressionHeader == that.compressionHeader && this.decompress == that.decompress && Objects.equals(this.tlsConfiguration, that.tlsConfiguration);
    }

    public int hashCode() {
        int result = this.connectionTimeout;
        result = 31 * result + Boolean.hashCode(this.compressionHeader);
        result = 31 * result + Boolean.hashCode(this.decompress);
        result = 31 * result + Objects.hashCode(this.tlsConfiguration);
        return result;
    }

    public static final class Builder {
        private int connectionTimeout = 5000;
        private boolean compressionHeader = false;
        private boolean decompress = true;
        private TlsConfiguration tlsConfiguration;

        public Builder setConnectionTimeout(int connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        public Builder setCompressionHeader(boolean compressionHeader) {
            this.compressionHeader = compressionHeader;
            return this;
        }

        public Builder setDecompress(boolean decompress) {
            this.decompress = decompress;
            return this;
        }

        public Builder setTlsConfiguration(TlsConfiguration tlsConfiguration) {
            this.tlsConfiguration = tlsConfiguration;
            return this;
        }

        public HttpClientConfiguration build() {
            return new HttpClientConfiguration(this.connectionTimeout, this.compressionHeader, this.decompress, this.tlsConfiguration);
        }
    }
}

