/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.http.functions.utils;

import java.io.InputStream;
import java.io.Serializable;
import org.mule.weave.v2.core.io.SeekableStream;
import org.mule.weave.v2.core.util.ObjectValueUtils$;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.model.structure.KeyValuePair;
import org.mule.weave.v2.model.structure.ObjectSeq;
import org.mule.weave.v2.model.structure.ObjectSeq$;
import org.mule.weave.v2.model.structure.QualifiedName;
import org.mule.weave.v2.model.types.BinaryType$;
import org.mule.weave.v2.model.types.NullType$;
import org.mule.weave.v2.model.types.StringType$;
import org.mule.weave.v2.model.values.Value;
import org.mule.weave.v2.module.http.HttpHeader$;
import org.mule.weave.v2.module.http.functions.HttpClientRequestConfig;
import org.mule.weave.v2.module.http.functions.exceptions.DuplicatedCookieFieldException;
import org.mule.weave.v2.module.http.functions.utils.HttpClientRequestConverter$;
import org.mule.weave.v2.module.http.functions.utils.Url;
import org.mule.weave.v2.module.http.service.HttpClientRequest;
import org.mule.weave.v2.parser.exception.WeaveRuntimeException;
import org.mule.weave.v2.parser.location.LocationCapable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005uc\u0001B\r\u001b\u0001-B\u0001B\r\u0001\u0003\u0002\u0003\u0006Ia\r\u0005\tw\u0001\u0011\t\u0011)A\u0005y!A\u0001\t\u0001B\u0001B\u0003%\u0011\tC\u0003I\u0001\u0011\u0005\u0011\nC\u0003P\u0001\u0011\u0005\u0001\u000bC\u0003_\u0001\u0011%q\fC\u0003h\u0001\u0011%\u0001\u000eC\u0004\u0002\b\u0001!I!!\u0003\b\u000f\u0005\u001d\"\u0004#\u0001\u0002*\u00191\u0011D\u0007E\u0001\u0003WAa\u0001\u0013\u0006\u0005\u0002\u00055\u0002\"CA\u0018\u0015\t\u0007I\u0011BA\u0019\u0011!\tiD\u0003Q\u0001\n\u0005M\u0002\"CA \u0015\t\u0007I\u0011BA\u0019\u0011!\t\tE\u0003Q\u0001\n\u0005M\u0002\"CA\"\u0015\t\u0007I\u0011BA\u0019\u0011!\t)E\u0003Q\u0001\n\u0005M\u0002\"CA$\u0015\t\u0007I\u0011BA\u0019\u0011!\tIE\u0003Q\u0001\n\u0005M\u0002\"CA&\u0015\t\u0007I\u0011BA\u0019\u0011!\tiE\u0003Q\u0001\n\u0005M\u0002\"CA(\u0015\t\u0007I\u0011BA\u0019\u0011!\t\tF\u0003Q\u0001\n\u0005M\u0002bBA*\u0015\u0011\u0005\u0011Q\u000b\u0002\u001b\u0011R$\bo\u00117jK:$(+Z9vKN$8i\u001c8wKJ$XM\u001d\u0006\u00037q\tQ!\u001e;jYNT!!\b\u0010\u0002\u0013\u0019,hn\u0019;j_:\u001c(BA\u0010!\u0003\u0011AG\u000f\u001e9\u000b\u0005\u0005\u0012\u0013AB7pIVdWM\u0003\u0002$I\u0005\u0011aO\r\u0006\u0003K\u0019\nQa^3bm\u0016T!a\n\u0015\u0002\t5,H.\u001a\u0006\u0002S\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\f\t\u0003[Aj\u0011A\f\u0006\u0002_\u0005)1oY1mC&\u0011\u0011G\f\u0002\u0007\u0003:L(+\u001a4\u0002\u000fI,\u0017/^3tiB\u0011A'O\u0007\u0002k)\u0011agN\u0001\ngR\u0014Xo\u0019;ve\u0016T!\u0001\u000f\u0012\u0002\u000b5|G-\u001a7\n\u0005i*$!C(cU\u0016\u001cGoU3r\u00035\u0011X-];fgR\u001cuN\u001c4jOB\u0011QHP\u0007\u00029%\u0011q\b\b\u0002\u0018\u0011R$\bo\u00117jK:$(+Z9vKN$8i\u001c8gS\u001e\f\u0001\u0002\\8dCRLwN\u001c\t\u0003\u0005\u001ak\u0011a\u0011\u0006\u0003\u0001\u0012S!!\u0012\u0012\u0002\rA\f'o]3s\u0013\t95IA\bM_\u000e\fG/[8o\u0007\u0006\u0004\u0018M\u00197f\u0003\u0019a\u0014N\\5u}Q!!\nT'O!\tY\u0005!D\u0001\u001b\u0011\u0015\u0011D\u00011\u00014\u0011\u0015YD\u00011\u0001=\u0011\u0015\u0001E\u00011\u0001B\u0003\u001d\u0019wN\u001c<feR$\u0012!\u0015\u000b\u0003%b\u0003\"a\u0015,\u000e\u0003QS!!\u0016\u0010\u0002\u000fM,'O^5dK&\u0011q\u000b\u0016\u0002\u0012\u0011R$\bo\u00117jK:$(+Z9vKN$\b\"B-\u0006\u0001\bQ\u0016aA2uqB\u00111\fX\u0007\u0002o%\u0011Ql\u000e\u0002\u0012\u000bZ\fG.^1uS>t7i\u001c8uKb$\u0018AC3yiJ\f7\r^+sYR\u0019\u0001-\u001a4\u0015\u0005\u0005$\u0007CA&c\u0013\t\u0019'DA\u0002Ve2DQ!\u0017\u0004A\u0004iCQA\r\u0004A\u0002MBQ\u0001\u0011\u0004A\u0002\u0005\u000ba\"\u001a=ue\u0006\u001cG\u000fS3bI\u0016\u00148\u000fF\u0002j\u0003\u000b!2A[A\u0002!\u0011Y'/\u001e=\u000f\u00051\u0004\bCA7/\u001b\u0005q'BA8+\u0003\u0019a$o\\8u}%\u0011\u0011OL\u0001\u0007!J,G-\u001a4\n\u0005M$(aA'ba*\u0011\u0011O\f\t\u0003WZL!a\u001e;\u0003\rM#(/\u001b8h!\rIh0\u001e\b\u0003urt!!\\>\n\u0003=J!! \u0018\u0002\u000fA\f7m[1hK&\u0019q0!\u0001\u0003\u0007M+\u0017O\u0003\u0002~]!)\u0011l\u0002a\u00025\")!g\u0002a\u0001g\u0005YQ\r\u001f;sC\u000e$(i\u001c3z)\u0011\tY!!\n\u0015\t\u00055\u00111\u0005\t\u0006[\u0005=\u00111C\u0005\u0004\u0003#q#AB(qi&|g\u000e\u0005\u0003\u0002\u0016\u0005}QBAA\f\u0015\u0011\tI\"a\u0007\u0002\u0005%|'BAA\u000f\u0003\u0011Q\u0017M^1\n\t\u0005\u0005\u0012q\u0003\u0002\f\u0013:\u0004X\u000f^*ue\u0016\fW\u000eC\u0003Z\u0011\u0001\u000f!\fC\u00033\u0011\u0001\u00071'\u0001\u000eIiR\u00048\t\\5f]R\u0014V-];fgR\u001cuN\u001c<feR,'\u000f\u0005\u0002L\u0015M\u0011!\u0002\f\u000b\u0003\u0003S\ta!T#U\u0011>#UCAA\u001a!\u0011\t)$a\u000f\u000e\u0005\u0005]\"\u0002BA\u001d\u00037\tA\u0001\\1oO&\u0019q/a\u000e\u0002\u000f5+E\u000bS(EA\u0005\u0019QK\u0015'\u0002\tU\u0013F\nI\u0001\r#V+%+W0Q\u0003J\u000bUjU\u0001\u000e#V+%+W0Q\u0003J\u000bUj\u0015\u0011\u0002\u000f!+\u0015\tR#S'\u0006A\u0001*R!E\u000bJ\u001b\u0006%\u0001\u0003C\u001f\u0012K\u0016!\u0002\"P\tf\u0003\u0013aB\"P\u001f.KUiU\u0001\t\u0007>{5*S#TA\u0005)\u0011\r\u001d9msR9!*a\u0016\u0002Z\u0005m\u0003\"\u0002\u001a\u0019\u0001\u0004\u0019\u0004\"B\u001e\u0019\u0001\u0004a\u0004\"\u0002!\u0019\u0001\u0004\t\u0005")
public class HttpClientRequestConverter {
    private final ObjectSeq request;
    private final HttpClientRequestConfig requestConfig;
    private final LocationCapable location;

    public static HttpClientRequestConverter apply(ObjectSeq objectSeq, HttpClientRequestConfig httpClientRequestConfig, LocationCapable locationCapable) {
        return HttpClientRequestConverter$.MODULE$.apply(objectSeq, httpClientRequestConfig, locationCapable);
    }

    public HttpClientRequest convert(EvaluationContext ctx) {
        Object object;
        Object object2;
        String method = (String)ObjectValueUtils$.MODULE$.selectString(this.request, HttpClientRequestConverter$.MODULE$.org$mule$weave$v2$module$http$functions$utils$HttpClientRequestConverter$$METHOD(), ctx).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new WeaveRuntimeException(new StringBuilder(16).append("Missing '").append(HttpClientRequestConverter$.MODULE$.org$mule$weave$v2$module$http$functions$utils$HttpClientRequestConverter$$METHOD()).append("' value").toString(), $this.location.location());
        });
        HttpClientRequest.Builder builder = new HttpClientRequest.Builder().setMethod(method);
        Url url = this.extractUrl(this.request, this.location, ctx);
        builder.setUrl(url.url());
        url.queryParams().foreach((Function1 & Serializable & scala.Serializable)entry -> {
            HttpClientRequestConverter.$anonfun$convert$2(builder, entry);
            return BoxedUnit.UNIT;
        });
        Map<String, Seq<String>> headers = this.extractHeaders(this.request, ctx);
        headers.foreach((Function1 & Serializable & scala.Serializable)entry -> {
            HttpClientRequestConverter.$anonfun$convert$4(builder, entry);
            return BoxedUnit.UNIT;
        });
        Option maybeCookieHeader = headers.get((Object)HttpHeader$.MODULE$.COOKIE_HEADER());
        Seq cookiesValue = ((ObjectSeq)ObjectValueUtils$.MODULE$.selectObject(this.request, HttpClientRequestConverter$.MODULE$.org$mule$weave$v2$module$http$functions$utils$HttpClientRequestConverter$$COOKIES(), ctx).getOrElse((Function0 & Serializable & scala.Serializable)() -> ObjectSeq$.MODULE$.empty())).toSeq(ctx);
        if (maybeCookieHeader.isDefined() && ((TraversableOnce)maybeCookieHeader.get()).nonEmpty() && cookiesValue.nonEmpty()) {
            throw new DuplicatedCookieFieldException(this.location.location());
        }
        if (cookiesValue.nonEmpty()) {
            String cookieValue = ((TraversableOnce)cookiesValue.map((Function1 & Serializable & scala.Serializable)kvp -> {
                String name = ((QualifiedName)kvp._1().evaluate(ctx)).name();
                String value = StringType$.MODULE$.coerce(kvp._2(), ctx).evaluate(ctx).toString();
                return new StringBuilder(1).append(name).append("=").append(value).toString();
            }, Seq$.MODULE$.canBuildFrom())).mkString(";");
            object2 = builder.addHeader(HttpHeader$.MODULE$.COOKIE_HEADER(), cookieValue);
        } else {
            object2 = BoxedUnit.UNIT;
        }
        Option<InputStream> maybeBody = this.extractBody(this.request, ctx);
        if (maybeBody.isDefined()) {
            InputStream body = (InputStream)maybeBody.get();
            object = builder.setBody(body);
        } else {
            object = BoxedUnit.UNIT;
        }
        builder.setFollowRedirect(this.requestConfig.followRedirects());
        Object object3 = this.requestConfig.readTimeout().isDefined() ? builder.setReadTimeout(BoxesRunTime.unboxToInt((Object)this.requestConfig.readTimeout().get())) : BoxedUnit.UNIT;
        Object object4 = this.requestConfig.requestTimeout().isDefined() ? builder.setRequestTimeout(BoxesRunTime.unboxToInt((Object)this.requestConfig.requestTimeout().get())) : BoxedUnit.UNIT;
        return builder.build();
    }

    private Url extractUrl(ObjectSeq request, LocationCapable location, EvaluationContext ctx) {
        Value urlValue = (Value)ObjectValueUtils$.MODULE$.select(request, HttpClientRequestConverter$.MODULE$.org$mule$weave$v2$module$http$functions$utils$HttpClientRequestConverter$$URL(), ctx).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new WeaveRuntimeException(new StringBuilder(16).append("Missing '").append(HttpClientRequestConverter$.MODULE$.org$mule$weave$v2$module$http$functions$utils$HttpClientRequestConverter$$URL()).append("' value").toString(), location.location());
        });
        Object object = urlValue.evaluate(ctx);
        if (object instanceof CharSequence) {
            CharSequence charSequence = (CharSequence)object;
            return new Url(((Object)charSequence).toString(), (Map<String, Seq<String>>)Predef$.MODULE$.Map().empty());
        }
        if (object instanceof ObjectSeq) {
            ObjectSeq objectSeq = (ObjectSeq)object;
            ObjectRef queryParams = ObjectRef.create((Object)Predef$.MODULE$.Map().empty());
            ObjectSeq urlObjectSeq = objectSeq.materialize(ctx);
            ObjectSeq queryParamsValue = (ObjectSeq)ObjectValueUtils$.MODULE$.selectObject(urlObjectSeq, HttpClientRequestConverter$.MODULE$.org$mule$weave$v2$module$http$functions$utils$HttpClientRequestConverter$$QUERY_PARAMS(), ctx).getOrElse((Function0 & Serializable & scala.Serializable)() -> ObjectSeq$.MODULE$.empty());
            String url = (String)ObjectValueUtils$.MODULE$.selectString(urlObjectSeq, HttpClientRequestConverter$.MODULE$.org$mule$weave$v2$module$http$functions$utils$HttpClientRequestConverter$$URL(), ctx).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new WeaveRuntimeException(new StringBuilder(16).append("Missing '").append(HttpClientRequestConverter$.MODULE$.org$mule$weave$v2$module$http$functions$utils$HttpClientRequestConverter$$URL()).append("' value").toString(), location.location());
            });
            queryParamsValue.toSeq(ctx).foreach((Function1 & Serializable & scala.Serializable)kvp -> {
                HttpClientRequestConverter.$anonfun$extractUrl$4(ctx, queryParams, kvp);
                return BoxedUnit.UNIT;
            });
            return new Url(url, (Map<String, Seq<String>>)((Map)queryParams.elem));
        }
        throw new MatchError(object);
    }

    private Map<String, Seq<String>> extractHeaders(ObjectSeq request, EvaluationContext ctx) {
        ObjectRef headers = ObjectRef.create((Object)Predef$.MODULE$.Map().empty());
        ObjectSeq headersValue = (ObjectSeq)ObjectValueUtils$.MODULE$.selectObject(request, HttpClientRequestConverter$.MODULE$.org$mule$weave$v2$module$http$functions$utils$HttpClientRequestConverter$$HEADERS(), ctx).getOrElse((Function0 & Serializable & scala.Serializable)() -> ObjectSeq$.MODULE$.empty());
        headersValue.toSeq(ctx).foreach((Function1 & Serializable & scala.Serializable)kvp -> {
            HttpClientRequestConverter.$anonfun$extractHeaders$2(ctx, headers, kvp);
            return BoxedUnit.UNIT;
        });
        return (Map)headers.elem;
    }

    private Option<InputStream> extractBody(ObjectSeq request, EvaluationContext ctx) {
        Option bodyValue = ObjectValueUtils$.MODULE$.select(request, HttpClientRequestConverter$.MODULE$.org$mule$weave$v2$module$http$functions$utils$HttpClientRequestConverter$$BODY(), ctx);
        return bodyValue.flatMap((Function1 & Serializable & scala.Serializable)body -> {
            Value value = body;
            if (NullType$.MODULE$.accepts(value, ctx)) {
                return None$.MODULE$;
            }
            if (BinaryType$.MODULE$.accepts(value, ctx)) {
                return new Some((Object)((SeekableStream)BinaryType$.MODULE$.coerce(body, ctx).evaluate(ctx)).spinOff(ctx));
            }
            return None$.MODULE$;
        });
    }

    public static final /* synthetic */ void $anonfun$convert$2(HttpClientRequest.Builder builder$1, Tuple2 entry) {
        ((IterableLike)entry._2()).foreach((Function1 & Serializable & scala.Serializable)value -> builder$1.addQueryParam((String)entry._1(), (String)value));
    }

    public static final /* synthetic */ void $anonfun$convert$4(HttpClientRequest.Builder builder$1, Tuple2 entry) {
        ((IterableLike)entry._2()).foreach((Function1 & Serializable & scala.Serializable)value -> builder$1.addHeader((String)entry._1(), (String)value));
    }

    public static final /* synthetic */ void $anonfun$extractUrl$4(EvaluationContext ctx$2, ObjectRef queryParams$1, KeyValuePair kvp) {
        String name = ((QualifiedName)kvp._1().evaluate(ctx$2)).name();
        String value = StringType$.MODULE$.coerce(kvp._2(), ctx$2).evaluate(ctx$2).toString();
        Option maybeValues = ((Map)queryParams$1.elem).get((Object)name);
        if (maybeValues.isDefined()) {
            Seq values = (Seq)((SeqLike)maybeValues.get()).$colon$plus((Object)value, Seq$.MODULE$.canBuildFrom());
            queryParams$1.elem = ((Map)queryParams$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)values));
            return;
        }
        queryParams$1.elem = ((Map)queryParams$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)new .colon.colon((Object)value, (List)Nil$.MODULE$)));
    }

    public static final /* synthetic */ void $anonfun$extractHeaders$2(EvaluationContext ctx$3, ObjectRef headers$1, KeyValuePair kvp) {
        String name = ((QualifiedName)kvp._1().evaluate(ctx$3)).name();
        String value = StringType$.MODULE$.coerce(kvp._2(), ctx$3).evaluate(ctx$3).toString();
        Option maybeValues = ((Map)headers$1.elem).get((Object)name);
        if (maybeValues.isDefined()) {
            Seq values = (Seq)((SeqLike)maybeValues.get()).$colon$plus((Object)value, Seq$.MODULE$.canBuildFrom());
            headers$1.elem = ((Map)headers$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)values));
            return;
        }
        headers$1.elem = ((Map)headers$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)new .colon.colon((Object)value, (List)Nil$.MODULE$)));
    }

    public HttpClientRequestConverter(ObjectSeq request, HttpClientRequestConfig requestConfig, LocationCapable location) {
        this.request = request;
        this.requestConfig = requestConfig;
        this.location = location;
    }
}

