/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.http.netty;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Optional;
import java.util.concurrent.Future;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.ListenableFuture;
import org.asynchttpclient.RequestBuilder;
import org.asynchttpclient.Response;
import org.asynchttpclient.handler.BodyDeferringAsyncHandler;
import org.mule.weave.v2.module.http.functions.utils.StopWatch;
import org.mule.weave.v2.module.http.functions.utils.StopWatch$;
import org.mule.weave.v2.module.http.netty.NettyHttpClientResponse;
import org.mule.weave.v2.module.http.netty.StopWatchCompletionHandler;
import org.mule.weave.v2.module.http.netty.StopWatchCompletionHandler$;
import org.mule.weave.v2.module.http.service.HttpClient;
import org.mule.weave.v2.module.http.service.HttpClientRequest;
import org.mule.weave.v2.module.http.service.HttpClientResponse;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u001d3AAB\u0004\u0001-!AQ\u0005\u0001B\u0001B\u0003%a\u0005C\u0003-\u0001\u0011\u0005Q\u0006C\u00032\u0001\u0011\u0005#\u0007C\u0003;\u0001\u0011\u00051\bC\u0003C\u0001\u0011\u00051IA\bOKR$\u0018\u0010\u0013;ua\u000ec\u0017.\u001a8u\u0015\tA\u0011\"A\u0003oKR$\u0018P\u0003\u0002\u000b\u0017\u0005!\u0001\u000e\u001e;q\u0015\taQ\"\u0001\u0004n_\u0012,H.\u001a\u0006\u0003\u001d=\t!A\u001e\u001a\u000b\u0005A\t\u0012!B<fCZ,'B\u0001\n\u0014\u0003\u0011iW\u000f\\3\u000b\u0003Q\t1a\u001c:h\u0007\u0001\u00192\u0001A\f !\tAR$D\u0001\u001a\u0015\tQ2$\u0001\u0003mC:<'\"\u0001\u000f\u0002\t)\fg/Y\u0005\u0003=e\u0011aa\u00142kK\u000e$\bC\u0001\u0011$\u001b\u0005\t#B\u0001\u0012\n\u0003\u001d\u0019XM\u001d<jG\u0016L!\u0001J\u0011\u0003\u0015!#H\u000f]\"mS\u0016tG/\u0001\u0004dY&,g\u000e\u001e\t\u0003O)j\u0011\u0001\u000b\u0006\u0003SM\tq\"Y:z]\u000eDG\u000f\u001e9dY&,g\u000e^\u0005\u0003W!\u0012q\"Q:z]\u000eDE\u000f\u001e9DY&,g\u000e^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00059\u0002\u0004CA\u0018\u0001\u001b\u00059\u0001\"B\u0013\u0003\u0001\u00041\u0013a\u0002:fcV,7\u000f\u001e\u000b\u0003gY\u0002\"\u0001\t\u001b\n\u0005U\n#A\u0005%uiB\u001cE.[3oiJ+7\u000f]8og\u0016DQ!M\u0002A\u0002]\u0002\"\u0001\t\u001d\n\u0005e\n#!\u0005%uiB\u001cE.[3oiJ+\u0017/^3ti\u0006)1\r\\8tKR\tA\b\u0005\u0002>\u00016\taHC\u0001@\u0003\u0015\u00198-\u00197b\u0013\t\teH\u0001\u0003V]&$\u0018\u0001C5t\u00072|7/\u001a3\u0015\u0003\u0011\u0003\"!P#\n\u0005\u0019s$a\u0002\"p_2,\u0017M\u001c")
public class NettyHttpClient
implements HttpClient {
    private final AsyncHttpClient client;

    public HttpClientResponse request(HttpClientRequest request) {
        StopWatch stopWatch = StopWatch$.MODULE$.apply(request.isEnableMetrics());
        RequestBuilder builder = new RequestBuilder();
        builder.setUrl(request.getUrl());
        builder.setMethod(request.getMethod());
        if (request.getQueryParams() != null) {
            request.getQueryParams().getQueryParams().forEach(q -> builder.addQueryParam(q.getName(), q.getValue()));
        }
        if (request.getHeaders() != null) {
            request.getHeaders().getHeaders().forEach(h -> builder.addHeader((CharSequence)h.getName(), h.getValue()));
        }
        Object object = request.getBody() != null ? builder.setBody(request.getBody()) : BoxedUnit.UNIT;
        builder.setFollowRedirect(request.isFollowRedirects());
        builder.setReadTimeout(request.getReadTimeout());
        builder.setRequestTimeout(request.getRequestTimeout());
        if (request.isStreamResponse()) {
            PipedOutputStream pipedOutputStream = new PipedOutputStream();
            PipedInputStream pipedInputStream = new PipedInputStream(pipedOutputStream);
            BodyDeferringAsyncHandler bodyDeferringHandler = new BodyDeferringAsyncHandler((OutputStream)pipedOutputStream);
            ListenableFuture responseFuture = this.client.prepareRequest(builder).execute((AsyncHandler)bodyDeferringHandler);
            Response response = bodyDeferringHandler.getResponse();
            BodyDeferringAsyncHandler.BodyDeferringInputStream inputStream = new BodyDeferringAsyncHandler.BodyDeferringInputStream((Future)responseFuture, bodyDeferringHandler, (InputStream)pipedInputStream);
            return new NettyHttpClientResponse(response, Optional.ofNullable(inputStream), stopWatch);
        }
        StopWatchCompletionHandler handler = StopWatchCompletionHandler$.MODULE$.apply(stopWatch);
        ListenableFuture responseFuture = this.client.prepareRequest(builder).execute((AsyncHandler)handler);
        Response response = (Response)responseFuture.get();
        Optional<InputStream> responseStream = response.hasResponseBody() ? Optional.ofNullable(response.getResponseBodyAsStream()) : Optional.empty();
        return new NettyHttpClientResponse(response, responseStream, stopWatch);
    }

    public void close() {
        this.client.close();
    }

    public boolean isClosed() {
        return this.client.isClosed();
    }

    public NettyHttpClient(AsyncHttpClient client) {
        this.client = client;
    }
}

