/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.http.netty;

import io.netty.buffer.ByteBufInputStream;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpChunkedInput;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.stream.ChunkedInput;
import io.netty.handler.stream.ChunkedStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.List;
import org.mule.weave.v2.module.http.netty.WeaveChunkedStream;
import org.mule.weave.v2.module.http.netty.WeaveChunkedStream$;
import org.mule.weave.v2.module.http.service.HttpServerRequest;
import org.mule.weave.v2.module.http.service.HttpServerResponse;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.MapLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ChannelHandler.Sharable
@ScalaSignature(bytes="\u0006\u0001\u0005}c\u0001B\u0005\u000b\u0001eA\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!\f\u0005\u0006y\u0001!\t!\u0010\u0005\u0006\u0003\u0002!\tB\u0011\u0005\u0006{\u0002!\tA \u0005\b\u0003\u0003\u0001A\u0011AA\u0002\u0011\u001d\t)\u0002\u0001C\u0001\u0003/Aq!!\u000b\u0001\t\u0003\tY\u0003C\u0004\u00022\u0001!\t%a\r\u0003%!#H\u000f]*feZL7-\u001a%b]\u0012dWM\u001d\u0006\u0003\u00171\tQA\\3uifT!!\u0004\b\u0002\t!$H\u000f\u001d\u0006\u0003\u001fA\ta!\\8ek2,'BA\t\u0013\u0003\t1(G\u0003\u0002\u0014)\u0005)q/Z1wK*\u0011QCF\u0001\u0005[VdWMC\u0001\u0018\u0003\ry'oZ\u0002\u0001'\t\u0001!\u0004E\u0002\u001cC\rj\u0011\u0001\b\u0006\u0003;y\tqa\u00195b]:,GN\u0003\u0002\f?)\t\u0001%\u0001\u0002j_&\u0011!\u0005\b\u0002\u001c'&l\u0007\u000f\\3DQ\u0006tg.\u001a7J]\n|WO\u001c3IC:$G.\u001a:\u0011\u0005\u0011RS\"A\u0013\u000b\u000551#BA\u0014)\u0003\u0015\u0019w\u000eZ3d\u0015\tIc$A\u0004iC:$G.\u001a:\n\u0005-*#a\u0004$vY2DE\u000f\u001e9SKF,Xm\u001d;\u0002\u0011\r\fG\u000e\u001c2bG.\u0004BAL\u00194s5\tqFC\u00011\u0003\u0015\u00198-\u00197b\u0013\t\u0011tFA\u0005Gk:\u001cG/[8ocA\u0011AgN\u0007\u0002k)\u0011a\u0007D\u0001\bg\u0016\u0014h/[2f\u0013\tATGA\tIiR\u00048+\u001a:wKJ\u0014V-];fgR\u0004\"\u0001\u000e\u001e\n\u0005m*$A\u0005%uiB\u001cVM\u001d<feJ+7\u000f]8og\u0016\fa\u0001P5oSRtDC\u0001 A!\ty\u0004!D\u0001\u000b\u0011\u0015a#\u00011\u0001.\u00031\u0019\u0007.\u00198oK2\u0014V-\u001931)\r\u0019ei\u0013\t\u0003]\u0011K!!R\u0018\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u000f\u000e\u0001\r\u0001S\u0001\u0004GRD\bCA\u000eJ\u0013\tQEDA\u000bDQ\u0006tg.\u001a7IC:$G.\u001a:D_:$X\r\u001f;\t\u000b1\u001b\u0001\u0019A\u0012\u0002\u000fI,\u0017/^3ti\"\u001a1AT/\u0011\u00079z\u0015+\u0003\u0002Q_\t1A\u000f\u001b:poN\u0004\"A\u0015.\u000f\u0005MCfB\u0001+X\u001b\u0005)&B\u0001,\u0019\u0003\u0019a$o\\8u}%\t\u0001'\u0003\u0002Z_\u00059\u0001/Y2lC\u001e,\u0017BA.]\u0005%)\u0005pY3qi&|gN\u0003\u0002Z_E\"aD\u00184}!\ty6M\u0004\u0002aCB\u0011AkL\u0005\u0003E>\na\u0001\u0015:fI\u00164\u0017B\u00013f\u0005\u0019\u0019FO]5oO*\u0011!mL\u0019\u0006G\u001d\\w\u000f\\\u000b\u0003Q&,\u0012A\u0018\u0003\u0006Ub\u0011\ra\u001c\u0002\u0002)&\u0011A.\\\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u0019\u000b\u00059|\u0013A\u0002;ie><8/\u0005\u0002qgB\u0011a&]\u0005\u0003e>\u0012qAT8uQ&tw\r\u0005\u0002uk:\u0011a\u0006W\u0005\u0003mr\u0013\u0011\u0002\u00165s_^\f'\r\\32\u000b\rB\u0018P\u001f8\u000f\u00059J\u0018B\u000180c\u0011\u0011cfL>\u0003\u000bM\u001c\u0017\r\\12\u0005\u0019\n\u0016A\u0004;p/\u0016\fg/\u001a*fcV,7\u000f\u001e\u000b\u0003g}DQ\u0001\u0014\u0003A\u0002\r\nQ\u0002^8IiR\u0004\b*Z1eKJ\u001cH\u0003BA\u0003\u0003\u0017\u00012\u0001JA\u0004\u0013\r\tI!\n\u0002\f\u0011R$\b\u000fS3bI\u0016\u00148\u000fC\u0004\u0002\u000e\u0015\u0001\r!a\u0004\u0002\u000f!,\u0017\rZ3sgB)q,!\u0005_=&\u0019\u00111C3\u0003\u00075\u000b\u0007/A\bge>l\u0007\n\u001e;q\u0011\u0016\fG-\u001a:t)\u0011\tI\"!\n\u0011\u000bI\u000bY\"a\b\n\u0007\u0005uALA\u0002TKF\u0004RALA\u0011=zK1!a\t0\u0005\u0019!V\u000f\u001d7fe!9\u0011q\u0005\u0004A\u0002\u0005\u0015\u0011a\u00035uiBDU-\u00193feN\fqB\u001a:p[F+XM]=TiJLgn\u001a\u000b\u0005\u00033\ti\u0003\u0003\u0004\u00020\u001d\u0001\rAX\u0001\u0004kJL\u0017aE2iC:tW\r\u001c*fC\u0012\u001cu.\u001c9mKR,GcA\"\u00026!)q\t\u0003a\u0001\u0011\"\"\u0001BTA\u001dc\u0019qb,a\u000f\u0002BE21eZ6\u0002>1\fda\t=z\u0003\u007fq\u0017\u0007\u0002\u0012/_m\f$AJ))\u0007\u0001\t)\u0005\u0005\u0003\u0002H\u0005ec\u0002BA%\u0003+rA!a\u0013\u0002T9!\u0011QJA)\u001d\r!\u0016qJ\u0005\u0002A%\u00111bH\u0005\u0003;yI1!a\u0016\u001d\u00039\u0019\u0005.\u00198oK2D\u0015M\u001c3mKJLA!a\u0017\u0002^\tA1\u000b[1sC\ndWMC\u0002\u0002Xq\u0001")
public class HttpServiceHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private final Function1<HttpServerRequest, HttpServerResponse> callback;

    public void channelRead0(ChannelHandlerContext ctx, FullHttpRequest request) throws Exception {
        HttpServerRequest weaveRequest = this.toWeaveRequest(request);
        HttpServerResponse weaveResponse = (HttpServerResponse)this.callback.apply((Object)weaveRequest);
        try {
            ChannelFuture channelFuture;
            HttpHeaders headers = this.toHttpHeaders((Map<String, String>)weaveResponse.headers());
            boolean contentLength = headers.contains((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
            boolean keepAlive = HttpUtil.isKeepAlive((HttpMessage)request);
            Object object = !keepAlive ? headers.set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE) : BoxedUnit.UNIT;
            if (!contentLength) {
                headers.set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
                DefaultHttpResponse headerResponse = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)weaveResponse.statusCode()), headers);
                ctx.write((Object)headerResponse);
                channelFuture = ctx.writeAndFlush((Object)new HttpChunkedInput((ChunkedInput)new ChunkedStream(weaveResponse.body())));
            } else {
                DefaultHttpResponse headerResponse = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)weaveResponse.statusCode()), headers);
                ctx.write((Object)headerResponse);
                channelFuture = ctx.writeAndFlush((Object)new HttpChunkedInput((ChunkedInput)new WeaveChunkedStream(weaveResponse.body(), new StringOps(Predef$.MODULE$.augmentString(headers.get((CharSequence)HttpHeaderNames.CONTENT_LENGTH))).toLong(), WeaveChunkedStream$.MODULE$.$lessinit$greater$default$3())), (ChannelPromise)ctx.newProgressivePromise());
            }
            ChannelFuture contentFuture = channelFuture;
            contentFuture.addListener(future -> weaveResponse.closeCallBack().apply$mcV$sp());
            if (!keepAlive) {
                contentFuture.addListener(future -> future.channel().close());
            }
        }
        catch (Exception exception) {
            weaveResponse.closeCallBack().apply$mcV$sp();
        }
    }

    public HttpServerRequest toWeaveRequest(FullHttpRequest request) {
        Iterator uriParts = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(request.uri())).split('?'))).iterator();
        String path = (String)uriParts.next();
        return new HttpServerRequest((InputStream)new ByteBufInputStream(request.content()), path, request.method().name(), this.fromHttpHeaders(request.headers()), this.fromQueryString(request.uri()));
    }

    public HttpHeaders toHttpHeaders(Map<String, String> headers) {
        return (HttpHeaders)headers.foldLeft((Object)new DefaultHttpHeaders(), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                DefaultHttpHeaders httpHeaders = (DefaultHttpHeaders)tuple2._1();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    String key = (String)tuple22._1();
                    String value = (String)tuple22._2();
                    return (DefaultHttpHeaders)httpHeaders.add(key, (Object)value);
                }
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public Seq<Tuple2<String, String>> fromHttpHeaders(HttpHeaders httpHeaders) {
        ArrayBuffer headers = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        httpHeaders.forEach(entry -> headers.$plus$eq((Object)new Tuple2(entry.getKey(), entry.getValue())));
        return headers;
    }

    public Seq<Tuple2<String, String>> fromQueryString(String uri) {
        QueryStringDecoder decoder = new QueryStringDecoder(uri);
        Seq toSeq = ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(decoder.parameters()).asScala()).toSeq();
        return (Seq)toSeq.flatMap((Function1 & Serializable & scala.Serializable)pair -> (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)pair._2()).asScala()).map((Function1 & Serializable & scala.Serializable)value -> new Tuple2(pair._1(), value), Buffer$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
    }

    public HttpServiceHandler(Function1<HttpServerRequest, HttpServerResponse> callback) {
        this.callback = callback;
    }
}

